/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.server;

import com.samskivert.util.Invoker;
import com.samskivert.util.ResultListener;
import com.threerings.presents.Log;
import com.threerings.presents.net.AuthRequest;
import com.threerings.presents.net.AuthResponse;
import com.threerings.presents.net.AuthResponseData;
import com.threerings.presents.server.net.AuthingConnection;

public abstract class Authenticator {
    public void authenticateConnection(Invoker invoker, final AuthingConnection conn, final ResultListener<AuthingConnection> onComplete) {
        final AuthRequest req = conn.getAuthRequest();
        final AuthResponseData rdata = this.createResponseData();
        final AuthResponse rsp = new AuthResponse(rdata);
        invoker.postUnit(new Invoker.Unit("authenticateConnection"){

            public boolean invoke() {
                try {
                    Authenticator.this.processAuthentication(conn, rsp);
                    if ("success".equals(rdata.code) && conn.getAuthName() == null) {
                        throw new IllegalStateException("Authenticator failed to provide authname");
                    }
                }
                catch (AuthException e) {
                    rdata.code = e.getMessage();
                }
                catch (Exception e) {
                    Log.log.warning((Object)"Error authenticating user", new Object[]{"areq", req, e});
                    rdata.code = "m.server_error";
                }
                return true;
            }

            public void handleResult() {
                conn.setAuthResponse(rsp);
                conn.postMessage(rsp);
                if ("success".equals(rdata.code)) {
                    onComplete.requestCompleted((Object)conn);
                }
            }
        });
    }

    protected AuthResponseData createResponseData() {
        return new AuthResponseData();
    }

    protected abstract void processAuthentication(AuthingConnection var1, AuthResponse var2) throws Exception;

    protected static class AuthException
    extends Exception {
        public AuthException(String code) {
            super(code);
        }
    }
}

