/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.data;

import com.threerings.presents.dobj.DObject;

public class TimeBaseObject
extends DObject {
    public static final String EVEN_BASE = "evenBase";
    public static final String ODD_BASE = "oddBase";
    public long evenBase;
    public long oddBase;

    public short toShortDelta(long timeStamp) {
        return (short)this.getDelta(timeStamp, 32767L);
    }

    public int toIntDelta(long timeStamp) {
        return (int)this.getDelta(timeStamp, Integer.MAX_VALUE);
    }

    public long fromDelta(int delta) {
        long time;
        boolean even = delta > 0;
        long l = time = even ? this.evenBase : this.oddBase;
        time = even ? (time += (long)delta) : (time += (long)(-1 - delta));
        return time;
    }

    protected long getDelta(long timeStamp, long maxValue) {
        boolean even = this.evenBase > this.oddBase;
        long base = even ? this.evenBase : this.oddBase;
        long delta = timeStamp - base;
        if (delta < 0L) {
            String errmsg = "Time stamp too old for conversion to delta time";
            throw new IllegalArgumentException(errmsg);
        }
        if (delta > maxValue) {
            if (even) {
                this.setOddBase(timeStamp);
            } else {
                this.setEvenBase(timeStamp);
            }
            delta = 0L;
        }
        if (!even) {
            delta = -1L - delta;
        }
        return delta;
    }

    public void setEvenBase(long value) {
        long ovalue = this.evenBase;
        this.requestAttributeChange(EVEN_BASE, value, ovalue);
        this.evenBase = value;
    }

    public void setOddBase(long value) {
        long ovalue = this.oddBase;
        this.requestAttributeChange(ODD_BASE, value, ovalue);
        this.oddBase = value;
    }
}

