/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.client;

import com.samskivert.util.RunAnywhere;
import com.threerings.presents.Log;
import com.threerings.presents.client.Client;
import com.threerings.presents.client.ClientDObjectMgr;
import com.threerings.presents.client.LogonException;
import com.threerings.presents.client.ObserverOps;
import com.threerings.presents.net.AuthResponse;
import com.threerings.presents.net.AuthResponseData;
import com.threerings.presents.net.Message;
import com.threerings.presents.net.UpstreamMessage;

public abstract class Communicator {
    protected boolean isLogoned = false;
    protected Client _client;
    protected ClientDObjectMgr _omgr;
    protected long _lastWrite;

    public Communicator(Client client) {
        this._client = client;
    }

    public abstract void logon();

    public boolean isLogoned() {
        return this.isLogoned;
    }

    public abstract void logoff();

    public abstract void gotBootstrap();

    public abstract void postMessage(UpstreamMessage var1);

    public abstract void setClassLoader(ClassLoader var1);

    public long getLastWrite() {
        return this._lastWrite;
    }

    public boolean getTransmitDatagrams() {
        return false;
    }

    protected synchronized void updateWriteStamp() {
        this._lastWrite = RunAnywhere.currentTimeMillis();
    }

    protected void gotAuthResponse(AuthResponse rsp) throws LogonException {
        AuthResponseData data = rsp.getData();
        if (!data.code.equals("success")) {
            throw new LogonException(data.code);
        }
        this.logonSucceeded(data);
    }

    protected synchronized void logonSucceeded(AuthResponseData data) {
        this._omgr = new ClientDObjectMgr(this, this._client);
        this._client._authData = data;
        this.isLogoned = true;
    }

    protected void processMessage(Message msg) {
        this._omgr.processMessage(msg);
    }

    protected void notifyClientObservers(ObserverOps.Session op) {
        if (this._client != null) {
            this._client.notifyObservers(op);
        } else {
            Log.log.warning((Object)"Dropping client observer notification.", new Object[]{"op", op});
        }
    }

    protected void clientCleanup(Exception logonError) {
        if (this._client != null) {
            this._client.cleanup(logonError);
            this._client = null;
        }
    }
}

