/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.io;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.util.StringUtil;
import com.threerings.NaryaLog;
import com.threerings.io.ClassMapping;
import com.threerings.io.Streamer;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class ObjectInputStream
extends DataInputStream {
    protected List<ClassMapping> _classmap;
    protected List<String> _internmap;
    protected Object _current;
    protected Streamer _streamer;
    protected ClassLoader _loader;
    protected Map<String, String> _translations;
    protected static final boolean STREAM_DEBUG = false;

    public ObjectInputStream(InputStream source) {
        super(source);
    }

    public void setClassLoader(ClassLoader loader) {
        this._loader = loader;
    }

    public void addTranslation(String oldname, String newname) {
        if (this._translations == null) {
            this._translations = Maps.newHashMap();
        }
        this._translations.put(oldname, newname);
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        ClassMapping cmap;
        block3: {
            try {
                cmap = this.readClassMapping();
                if (cmap != null) break block3;
                return null;
            }
            catch (OutOfMemoryError oome) {
                throw (IOException)new IOException("Malformed object data").initCause(oome);
            }
        }
        Object target = cmap.streamer.createObject(this);
        this.readBareObject(target, cmap.streamer, true);
        return target;
    }

    public String readIntern() throws IOException {
        String value;
        short code;
        if (this._internmap == null) {
            this._internmap = Lists.newArrayList();
            this._internmap.add(null);
        }
        if ((code = this.readShort()) == 0) {
            return null;
        }
        if (code < 0) {
            code = (short)(code * -1);
            String value2 = this.readUTF().intern();
            this.mapIntern(code, value2);
            return value2;
        }
        String string = value = code < this._internmap.size() ? this._internmap.get(code) : null;
        if (value == null) {
            NaryaLog.log.warning((Object)"Internal stream error, no intern value", new Object[]{"code", code, "ois", this, new Exception()});
            NaryaLog.log.warning((Object)"ObjectInputStream mappings", new Object[]{"map", this._internmap});
            String errmsg = "Read intern code for which we have no registered value metadata [code=" + code + "]";
            throw new RuntimeException(errmsg);
        }
        return value;
    }

    protected void mapIntern(short code, String value) throws IOException {
        this._internmap.add(code, value);
    }

    protected ClassMapping readClassMapping() throws IOException, ClassNotFoundException {
        ClassMapping cmap;
        short code;
        if (this._classmap == null) {
            this._classmap = Lists.newArrayList();
            this._classmap.add(null);
        }
        if ((code = this.readShort()) == 0) {
            return null;
        }
        if (code < 0) {
            String tname;
            code = (short)(code * -1);
            String cname = this.readUTF();
            if (this._translations != null && (tname = this._translations.get(cname)) != null) {
                cname = tname;
            }
            return this.mapClass(code, cname);
        }
        ClassMapping classMapping = cmap = code < this._classmap.size() ? this._classmap.get(code) : null;
        if (cmap == null) {
            NaryaLog.log.warning((Object)"Internal stream error, no class metadata", new Object[]{"code", code, "ois", this, new Exception()});
            NaryaLog.log.warning((Object)"ObjectInputStream mappings", new Object[]{"map", this._classmap});
            String string = "Read object code for which we have no registered class metadata [code=" + code + "]";
        }
        return cmap;
    }

    protected ClassMapping mapClass(short code, String cname) throws IOException, ClassNotFoundException {
        ClassMapping cmap = this.createClassMapping(code, cname);
        this._classmap.add(code, cmap);
        return cmap;
    }

    protected ClassMapping createClassMapping(short code, String cname) throws IOException, ClassNotFoundException {
        ClassLoader loader = this._loader != null ? this._loader : Thread.currentThread().getContextClassLoader();
        Class<?> sclass = Class.forName(cname, true, loader);
        Streamer streamer = Streamer.getStreamer(sclass);
        if (streamer == null) {
            String errmsg = "Aiya! Unable to create streamer for newly seen class [code=" + code + ", class=" + cname + "]";
            throw new RuntimeException(errmsg);
        }
        return new ClassMapping(code, sclass, streamer);
    }

    public void readBareObject(Object object) throws IOException, ClassNotFoundException {
        this.readBareObject(object, Streamer.getStreamer(object.getClass()), true);
    }

    protected void readBareObject(Object object, Streamer streamer, boolean useReader) throws IOException, ClassNotFoundException {
        this._current = object;
        this._streamer = streamer;
        try {
            this._streamer.readObject(object, this, useReader);
        }
        finally {
            this._current = null;
            this._streamer = null;
        }
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException {
        if (this._current == null) {
            throw new RuntimeException("defaultReadObject() called illegally.");
        }
        this._streamer.readObject(this._current, this, false);
    }

    public String readUnmodifiedUTF() throws IOException {
        int utflen = this.readUnsignedShort();
        byte[] bbuf = new byte[utflen];
        this.in.read(bbuf);
        return new String(bbuf, "UTF-8");
    }

    public String toString() {
        return "[hash=" + this.hashCode() + ", mappings=" + this._classmap.size() + ", current=" + StringUtil.safeToString((Object)this._current) + ", streamer=" + this._streamer + "]";
    }
}

