/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.crowd.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.threerings.bureau.data.BureauClientObject;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.crowd.server.BodyLocator;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.dobj.AccessController;
import com.threerings.presents.dobj.DEvent;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.ProxySubscriber;
import com.threerings.presents.dobj.Subscriber;
import com.threerings.presents.server.PresentsObjectAccess;

public class CrowdObjectAccess {

    @Singleton
    public static class BureauAccessController
    extends PlaceAccessController {
        @Override
        public boolean allowSubscribe(DObject object, Subscriber<?> sub) {
            ClientObject co;
            if (sub instanceof ProxySubscriber && (co = ((ProxySubscriber)sub).getClientObject()) instanceof BureauClientObject) {
                return true;
            }
            return super.allowSubscribe(object, sub);
        }

        @Override
        public boolean allowDispatch(DObject object, DEvent event) {
            return super.allowDispatch(object, event);
        }
    }

    @Singleton
    public static class PlaceAccessController
    implements AccessController {
        @Inject
        protected BodyLocator _locator;

        @Override
        public boolean allowSubscribe(DObject object, Subscriber<?> sub) {
            if (sub instanceof ProxySubscriber) {
                ClientObject co = ((ProxySubscriber)sub).getClientObject();
                return ((PlaceObject)object).occupants.contains(this._locator.forClient(co).getOid());
            }
            return true;
        }

        @Override
        public boolean allowDispatch(DObject object, DEvent event) {
            return PresentsObjectAccess.DEFAULT.allowDispatch(object, event);
        }
    }
}

