/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.server;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.util.StringUtil;
import com.threerings.presents.Log;
import com.threerings.presents.dobj.RootDObjectManager;

@Singleton
public class ReportManager {
    public static final String DEFAULT_TYPE = "";
    public static final String PROFILE_TYPE = "profile";
    protected long _serverStartTime;
    protected long _lastReportStamp;
    protected Multimap<String, Reporter> _reporters;
    @Inject
    protected RootDObjectManager _omgr;
    protected static final long REPORT_INTERVAL = 900000L;
    protected static final String LOG_REPORT_HEADER = "State of server report:\n";

    public ReportManager() {
        this._lastReportStamp = this._serverStartTime = System.currentTimeMillis();
        this._reporters = ArrayListMultimap.create();
    }

    public void activatePeriodicReport() {
        this._omgr.newInterval(new Runnable(){

            @Override
            public void run() {
                ReportManager.this.logReport(ReportManager.LOG_REPORT_HEADER + ReportManager.this.generateReport(ReportManager.DEFAULT_TYPE, System.currentTimeMillis(), true));
            }
        }).schedule(this.getReportInterval(), true);
    }

    public void registerReporter(Reporter reporter) {
        this.registerReporter(DEFAULT_TYPE, reporter);
    }

    public void registerReporter(String type, Reporter reporter) {
        this._reporters.put((Object)type, (Object)reporter);
    }

    public String generateReport() {
        return this.generateReport(DEFAULT_TYPE);
    }

    public String generateReport(String type) {
        return this.generateReport(type, System.currentTimeMillis(), false);
    }

    protected String generateReport(String type, long now, boolean reset) {
        long sinceLast = now - this._lastReportStamp;
        long uptime = now - this._serverStartTime;
        StringBuilder report = new StringBuilder();
        if (DEFAULT_TYPE.equals(type)) {
            report.append("- Uptime: ");
            report.append(StringUtil.intervalToString((long)uptime)).append("\n");
            report.append("- Report period: ");
            report.append(StringUtil.intervalToString((long)sinceLast)).append("\n");
            Runtime rt = Runtime.getRuntime();
            long total = rt.totalMemory();
            long max = rt.maxMemory();
            long used = total - rt.freeMemory();
            report.append("- Memory: ").append(used / 1024L).append("k used, ");
            report.append(total / 1024L).append("k total, ");
            report.append(max / 1024L).append("k max\n");
        }
        for (Reporter rptr : this._reporters.get((Object)type)) {
            try {
                rptr.appendReport(report, now, sinceLast, reset);
            }
            catch (Throwable t) {
                Log.log.warning((Object)"Reporter choked", new Object[]{"rptr", rptr, t});
            }
        }
        int blen = report.length();
        if (report.length() > 0 && report.charAt(blen - 1) == '\n') {
            report.delete(blen - 1, blen);
        }
        if (reset) {
            this._lastReportStamp = now;
        }
        return report.toString();
    }

    protected void logReport(String report) {
        Log.log.info((Object)report, new Object[0]);
    }

    protected long getReportInterval() {
        return 900000L;
    }

    public static interface Reporter {
        public void appendReport(StringBuilder var1, long var2, long var4, boolean var6);
    }
}

