/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.server;

import com.google.inject.Module;
import com.samskivert.util.StringUtil;
import com.threerings.presents.Log;
import com.threerings.presents.net.AuthResponse;
import com.threerings.presents.server.Authenticator;
import com.threerings.presents.server.PresentsServer;
import com.threerings.presents.server.net.AuthingConnection;
import com.threerings.util.MessageBundle;

public class Rejector
extends PresentsServer {
    protected static String _errmsg;
    protected static int[] _ports;

    @Override
    protected int[] getListenPorts() {
        return _ports;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: Rejector ports error_msg [args]");
            System.exit(-1);
        }
        _ports = StringUtil.parseIntArray((String)args[0]);
        _errmsg = args[1];
        if (args.length > 2) {
            String[] eargs = new String[args.length - 2];
            System.arraycopy(args, 2, eargs, 0, eargs.length);
            _errmsg = MessageBundle.tcompose((String)_errmsg, (String[])eargs);
        }
        Rejector.runServer(new Module[]{new RejectorModule(), new PresentsServer.PresentsServerModule(Rejector.class)});
    }

    protected class RejectingAuthenticator
    extends Authenticator {
        protected RejectingAuthenticator() {
        }

        @Override
        protected void processAuthentication(AuthingConnection conn, AuthResponse rsp) throws Exception {
            Log.log.info((Object)("Rejecting request: " + conn.getAuthRequest()), new Object[0]);
            throw new Authenticator.AuthException(_errmsg);
        }
    }

    public static class RejectorModule
    extends PresentsServer.PresentsModule {
        @Override
        protected void configure() {
            super.configure();
            this.bind(Authenticator.class).to(RejectingAuthenticator.class);
        }
    }
}

