/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.server;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.util.Histogram;
import com.samskivert.util.IntMap;
import com.samskivert.util.IntMaps;
import com.samskivert.util.Interval;
import com.samskivert.util.Queue;
import com.samskivert.util.StringUtil;
import com.samskivert.util.Throttle;
import com.threerings.presents.Log;
import com.threerings.presents.dobj.AccessController;
import com.threerings.presents.dobj.CompoundEvent;
import com.threerings.presents.dobj.DEvent;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.DObjectManager;
import com.threerings.presents.dobj.InvocationRequestEvent;
import com.threerings.presents.dobj.NoSuchObjectException;
import com.threerings.presents.dobj.ObjectAccessException;
import com.threerings.presents.dobj.ObjectAddedEvent;
import com.threerings.presents.dobj.ObjectDestroyedEvent;
import com.threerings.presents.dobj.ObjectRemovedEvent;
import com.threerings.presents.dobj.OidList;
import com.threerings.presents.dobj.RootDObjectManager;
import com.threerings.presents.dobj.Subscriber;
import com.threerings.presents.server.InvocationManager;
import com.threerings.presents.server.ReportManager;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Singleton
public class PresentsDObjectMgr
implements RootDObjectManager {
    private ExecutorService[] executor = new ExecutorService[]{new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10000))};
    protected boolean _running = true;
    protected Queue<Object> _evqueue = new Queue();
    protected IntMap<DObject> _objects = IntMaps.newHashIntMap();
    protected int _nextOid = 0;
    protected long _eventCount = 0L;
    protected Throttle _fatalThrottle = new Throttle(30, 60000L);
    protected IntMap<Reference[]> _refs = IntMaps.newHashIntMap();
    protected AccessController _defaultController;
    protected IntMap<ProxyReference> _proxies = IntMaps.newHashIntMap();
    protected Thread _dobjThread;
    protected long _nextEventId = 1L;
    protected Map<String, UnitProfile> _profiles = Maps.newHashMap();
    protected Stats _recent;
    protected Stats _current = this._recent = new Stats();
    protected Map<Class<?>, EventHelper> _helpers = Maps.newHashMap();
    protected InvocationManager _invmgr;
    protected int _unitProfInterval = 100;
    protected static final boolean UNIT_PROF_ENABLED = true;
    protected static final int DEFREFVEC_SIZE = 4;
    protected static final int DUMMY_OID = 0;

    @Inject
    public PresentsDObjectMgr(ReportManager repmgr) {
        DObject dummy = new DObject();
        dummy.setOid(0);
        this._objects.put(0, (Object)dummy);
        repmgr.registerReporter("", new ReportManager.Reporter(){

            @Override
            public void appendReport(StringBuilder report, long now, long elapsed, boolean reset) {
                report.append("* presents.PresentsDObjectMgr:\n");
                Stats stats = PresentsDObjectMgr.this.getStats(reset);
                int queueSize = PresentsDObjectMgr.this._evqueue.size();
                report.append("- Queue size: ").append(queueSize).append("\n");
                report.append("- Max queue size: ").append(stats.maxQueueSize).append("\n");
                report.append("- Units executed: ").append(stats.eventCount);
                if (elapsed != 0L) {
                    report.append(" (").append((long)stats.eventCount / (elapsed / 1000L)).append("/s)\n");
                } else {
                    report.append(" (inf/s)\n");
                }
            }
        });
        repmgr.registerReporter("profile", new ReportManager.Reporter(){

            @Override
            public void appendReport(StringBuilder report, long now, long elapsed, boolean reset) {
                report.append("* presents.PresentsDObjectMgr:\n");
                report.append("- Unit profiles: ").append(PresentsDObjectMgr.this._profiles.size()).append("\n");
                for (Map.Entry<String, UnitProfile> entry : PresentsDObjectMgr.this._profiles.entrySet()) {
                    report.append("  ").append(entry.getKey());
                    report.append(" ").append(entry.getValue()).append("\n");
                }
            }
        });
        this.registerEventHelpers();
    }

    public synchronized long getNextEventId(boolean increment) {
        long l;
        if (increment) {
            long l2 = this._nextEventId;
            l = l2;
            this._nextEventId = l2 + 1L;
        } else {
            l = this._nextEventId;
        }
        return l;
    }

    public void setDefaultAccessController(AccessController controller) {
        AccessController oldDefault = this._defaultController;
        this._defaultController = controller;
        for (DObject obj : this._objects.values()) {
            if (oldDefault != obj.getAccessController()) continue;
            obj.setAccessController(controller);
        }
    }

    public void registerProxyObject(DObject object, DObjectManager omgr) {
        int origObjectId = object.getOid();
        this.registerObject(object);
        this._proxies.put(object.getOid(), (Object)new ProxyReference(origObjectId, omgr));
    }

    public void clearProxyObject(int origObjectId, DObject object) {
        if (this._proxies.remove(object.getOid()) == null) {
            Log.log.warning((Object)"Missing proxy mapping for cleared proxy", new Object[]{"ooid", origObjectId});
        }
        this._objects.remove(object.getOid());
    }

    @Override
    public boolean isManager(DObject object) {
        return true;
    }

    @Override
    public <T extends DObject> void subscribeToObject(int oid, Subscriber<T> target) {
        this.postEvent(new AccessObjectEvent<T>(oid, target, 0));
    }

    @Override
    public <T extends DObject> void unsubscribeFromObject(int oid, Subscriber<T> target) {
        this.postEvent(new AccessObjectEvent<T>(oid, target, 1));
    }

    @Override
    public void postEvent(DEvent event) {
        if (!this._running) {
            Log.log.warning((Object)"Posting message to inactive object manager", new Object[]{"event", event, new Exception()});
        }
        event.eventId = this.getNextEventId(true);
        this._evqueue.append((Object)event);
    }

    @Override
    public void removedLastSubscriber(DObject obj, boolean deathWish) {
        if (deathWish) {
            this.destroyObject(obj.getOid());
        }
    }

    @Override
    public <T extends DObject> T registerObject(T object) {
        if (this._dobjThread != null && !this.isDispatchThread()) {
            Log.log.warning((Object)"Registering DObject on non-dobject thread", new Object[]{"class", object.getClass().getName(), new Exception()});
        }
        int oid = this.getNextOid();
        object.setOid(oid);
        object.setManager(this);
        if (object.getAccessController() == null) {
            object.setAccessController(this._defaultController);
        }
        this._objects.put(oid, object);
        return object;
    }

    @Override
    public void destroyObject(int oid) {
        if (oid == 0) {
            Log.log.warning((Object)"Denying request to destroy the dummy object!", new Object[]{new Exception()});
            return;
        }
        this.postEvent(new ObjectDestroyedEvent(oid));
    }

    @Override
    public Interval newInterval(final Runnable action) {
        return new Interval(this){

            public void expired() {
                action.run();
            }

            public String toString() {
                return "DObjectManagerInterval(" + action + ")";
            }

            protected void noteRejected() {
            }
        };
    }

    @Override
    public DObject getObject(int oid) {
        return (DObject)this._objects.get(oid);
    }

    public Stats getStats(boolean snapshot) {
        if (snapshot) {
            this._recent = this._current;
            this._current = new Stats();
            this._current.maxQueueSize = this._evqueue.size();
        }
        return this._recent;
    }

    @Override
    public void execute(Runnable command) {
        this.postRunnable(command);
    }

    public void postRunnable(Runnable unit) {
        if (!this._running) {
            Log.log.warning((Object)"Posting runnable to inactive object manager", new Object[]{"unit", unit, new Exception()});
        }
        this._evqueue.append((Object)unit);
    }

    public synchronized boolean isDispatchThread() {
        return Thread.currentThread() == this._dobjThread;
    }

    public synchronized void requireEventThread() {
        if (this._dobjThread != null && !this.isDispatchThread()) {
            throw new IllegalStateException("This method must be called on the dobj event thread.");
        }
    }

    public void refuseEventThread() {
        if (this.isDispatchThread()) {
            throw new IllegalStateException("This method must not be called on the dobj event thread.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        Log.log.info((Object)"DOMGR running.", new Object[0]);
        var1_1 = this;
        synchronized (var1_1) {
            this._dobjThread = Thread.currentThread();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var1_1
            if (true) ** GOTO lbl13
        }
        do {
            obj = this._evqueue.get();
            this.processUnit(obj);
lbl13:
            // 2 sources

        } while (this.isRunning());
        Log.log.info((Object)"DOMGR exited.", new Object[0]);
    }

    public void harshShutdown() {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                PresentsDObjectMgr.this._running = false;
            }
        });
    }

    public void setUnitProfInterval(int interval) {
        this._unitProfInterval = interval;
    }

    public int getUnitProfInterval() {
        return this._unitProfInterval;
    }

    public void dumpUnitProfiles() {
        for (Map.Entry<String, UnitProfile> entry : this._profiles.entrySet()) {
            Log.log.info((Object)("P: " + entry.getKey() + " => " + entry.getValue()), new Object[0]);
        }
    }

    public void clearUnitProfiles() {
        this._profiles.clear();
    }

    public boolean objectDestroyed(DEvent event, DObject target) {
        Field[] fields;
        Reference[] refs;
        int oid = target.getOid();
        if (oid == 0) {
            Log.log.warning((Object)"Denying attempt to destroy dummy object!", new Object[]{new Exception()});
            return false;
        }
        this._objects.remove(oid);
        target.setManager(null);
        if (target.getAccessController() == this._defaultController) {
            target.setAccessController(null);
        }
        if ((refs = (Reference[])this._refs.remove(oid)) != null) {
            Reference[] referenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                Reference ref = referenceArray[n2];
                if (ref != null) {
                    DObject reffer = (DObject)this._objects.get(ref.reffingOid);
                    if (reffer != null) {
                        this.postEvent(new ObjectRemovedEvent(ref.reffingOid, ref.field, oid));
                    } else {
                        Log.log.info((Object)("Dangling reference from inactive object " + ref + "."), new Object[0]);
                    }
                }
                ++n2;
            }
        }
        Class<?> oclass = target.getClass();
        Field[] fieldArray = fields = oclass.getFields();
        int n = fields.length;
        int n3 = 0;
        while (n3 < n) {
            Field field = fieldArray[n3];
            int mods = field.getModifiers();
            if ((mods & 8) == 0 && (mods & 1) != 0 && OidList.class.isAssignableFrom(field.getType())) {
                try {
                    OidList list = (OidList)field.get(target);
                    int ii = 0;
                    while (ii < list.size()) {
                        this.clearReference(target, field.getName(), list.get(ii));
                        ++ii;
                    }
                }
                catch (Exception e) {
                    Log.log.warning((Object)"Unable to clean up after oid list field", new Object[]{"target", target, "field", field});
                }
            }
            ++n3;
        }
        return true;
    }

    public boolean objectAdded(DEvent event, DObject target) {
        ObjectAddedEvent oae = (ObjectAddedEvent)event;
        int oid = oae.getOid();
        if (!this._objects.containsKey(oid)) {
            Log.log.info((Object)"Rejecting object added event of non-existent object", new Object[]{"refferOid", target.getOid(), "reffedOid", oid});
            return false;
        }
        Reference[] refs = (Reference[])this._refs.get(oid);
        if (refs == null) {
            refs = new Reference[4];
            this._refs.put(oid, (Object)refs);
        }
        Reference ref = new Reference(target.getOid(), oae.getName(), oid);
        int rpos = -1;
        int ii = 0;
        while (ii < refs.length) {
            if (ref.equals(refs[ii])) {
                Log.log.warning((Object)("Ignoring request to track existing reference " + ref + "."), new Object[0]);
                return true;
            }
            if (refs[ii] == null && rpos == -1) {
                rpos = ii;
            }
            ++ii;
        }
        if (rpos == -1) {
            Reference[] nrefs = new Reference[refs.length * 2];
            System.arraycopy(refs, 0, nrefs, 0, refs.length);
            rpos = refs.length;
            refs = nrefs;
            this._refs.put(oid, (Object)nrefs);
        }
        refs[rpos] = ref;
        return true;
    }

    public boolean objectRemoved(DEvent event, DObject target) {
        ObjectRemovedEvent ore = (ObjectRemovedEvent)event;
        String field = ore.getName();
        int toid = target.getOid();
        int oid = ore.getOid();
        Reference[] refs = (Reference[])this._refs.get(oid);
        if (refs == null) {
            return true;
        }
        int ii = 0;
        while (ii < refs.length) {
            Reference ref = refs[ii];
            if (ref != null && ref.equals(toid, field)) {
                refs[ii] = null;
                return true;
            }
            ++ii;
        }
        Log.log.warning((Object)"Unable to locate reference for removal", new Object[]{"reffingOid", toid, "field", field, "reffedOid", oid});
        return true;
    }

    public boolean queueIsEmpty() {
        return !this._evqueue.hasElements();
    }

    public synchronized boolean isRunning() {
        return this._running;
    }

    protected void processUnit(Object unit) {
        long start = System.nanoTime();
        int queueSize = this._evqueue.size();
        if (queueSize > this._current.maxQueueSize) {
            this._current.maxQueueSize = queueSize;
        }
        try {
            if (unit instanceof Runnable) {
                ((Runnable)unit).run();
            } else {
                DEvent event = (DEvent)unit;
                ProxyReference proxy = (ProxyReference)this._proxies.get(event.getTargetOid());
                if (proxy != null) {
                    event.setTargetOid(proxy.origObjectId);
                    proxy.origManager.postEvent(event);
                } else if (event instanceof CompoundEvent) {
                    this.processCompoundEvent((CompoundEvent)event);
                } else {
                    this.processEvent(event);
                }
            }
        }
        catch (VirtualMachineError e) {
            this.handleFatalError(unit, e);
        }
        catch (Throwable t) {
            Log.log.warning((Object)"Execution unit failed", new Object[]{"unit", unit, t});
        }
        long elapsed = (System.nanoTime() - start) / 1000L;
        if (elapsed > 500000L && !(unit instanceof LongRunnable)) {
            Log.log.warning((Object)("Long dobj unit " + StringUtil.shortClassName((Object)unit)), new Object[]{"unit", unit, "time", String.valueOf(elapsed / 1000L) + "ms"});
        }
        if (this._eventCount % (long)this._unitProfInterval == 0L) {
            InvocationRequestEvent ire;
            Class<?> c;
            String cname = unit instanceof Interval.RunBuddy ? StringUtil.shortClassName((String)((Interval.RunBuddy)unit).getIntervalClassName()) : (unit instanceof InvocationRequestEvent ? ((c = this._invmgr.getDispatcherClass((ire = (InvocationRequestEvent)unit).getInvCode())) == null ? "dobj.InvocationRequestEvent:(no longer registered)" : String.valueOf(StringUtil.shortClassName(c)) + ":" + ire.getMethodId()) : StringUtil.shortClassName((Object)unit));
            UnitProfile uprof = this._profiles.get(cname);
            if (uprof == null) {
                uprof = new UnitProfile();
                this._profiles.put(cname, uprof);
            }
            uprof.record(elapsed);
        }
    }

    protected void processCompoundEvent(CompoundEvent event) {
        List<DEvent> events = event.getEvents();
        int ecount = events.size();
        DObject target = (DObject)this._objects.get(event.getTargetOid());
        if (target == null) {
            Log.log.debug((Object)"Compound event target no longer exists", new Object[]{"event", event});
            return;
        }
        int ii = 0;
        while (ii < ecount) {
            DEvent sevent = events.get(ii);
            if (!target.checkPermissions(sevent)) {
                Log.log.warning((Object)"Event failed permissions check", new Object[]{"event", sevent, "target", target});
                return;
            }
            ++ii;
        }
        ii = 0;
        while (ii < ecount) {
            this.dispatchEvent(events.get(ii), target);
            ++ii;
        }
        target.notifyProxies(event);
    }

    protected void processEvent(DEvent event) {
        DObject target = (DObject)this._objects.get(event.getTargetOid());
        if (target == null) {
            Log.log.debug((Object)"Event target no longer exists", new Object[]{"event", event});
            return;
        }
        if (!target.checkPermissions(event)) {
            Log.log.warning((Object)"Event failed permissions check", new Object[]{"event", event, "target", target});
            return;
        }
        if (this.dispatchEvent(event, target)) {
            target.notifyProxies(event);
        }
    }

    protected boolean dispatchEvent(DEvent event, DObject target) {
        boolean notify;
        block5: {
            notify = true;
            EventHelper helper = this._helpers.get(event.getClass());
            if (helper == null || helper.invoke(event, target)) break block5;
            return false;
        }
        try {
            notify = event.applyToObject(target);
            if (notify) {
                target.notifyListeners(event);
            }
        }
        catch (VirtualMachineError e) {
            this.handleFatalError(event, e);
        }
        catch (Throwable t) {
            Log.log.warning((Object)"Failure processing event", new Object[]{"event", event, "target", target, t});
        }
        ++this._eventCount;
        ++this._current.eventCount;
        return true;
    }

    protected void handleFatalError(Object causer, Error error) {
        if (this._fatalThrottle.throttleOp()) {
            throw error;
        }
        Log.log.warning((Object)("Fatal error caused by '" + causer + "': " + error), new Object[]{error});
    }

    protected void clearReference(DObject reffer, String field, int reffedOid) {
        Reference[] refs = (Reference[])this._refs.get(reffedOid);
        Reference ref = null;
        if (refs != null) {
            int ii = 0;
            while (ii < refs.length) {
                if (refs[ii].equals(reffer.getOid(), field)) {
                    ref = refs[ii];
                    refs[ii] = null;
                    break;
                }
                ++ii;
            }
        }
        if (ref == null && this._objects.containsKey(reffedOid)) {
            Log.log.warning((Object)"Requested to clear out non-existent reference", new Object[]{"refferOid", reffer.getOid(), "field", field, "reffedOid", reffedOid});
        }
    }

    protected int getNextOid() {
        do {
            this._nextOid = (this._nextOid + 1) % Integer.MAX_VALUE;
        } while (this._objects.containsKey(this._nextOid));
        return this._nextOid;
    }

    protected void registerEventHelpers() {
        try {
            this._helpers.put(ObjectDestroyedEvent.class, new EventHelper(){

                @Override
                public boolean invoke(DEvent event, DObject target) {
                    return PresentsDObjectMgr.this.objectDestroyed(event, target);
                }
            });
            this._helpers.put(ObjectAddedEvent.class, new EventHelper(){

                @Override
                public boolean invoke(DEvent event, DObject target) {
                    return PresentsDObjectMgr.this.objectAdded(event, target);
                }
            });
            this._helpers.put(ObjectRemovedEvent.class, new EventHelper(){

                @Override
                public boolean invoke(DEvent event, DObject target) {
                    return PresentsDObjectMgr.this.objectRemoved(event, target);
                }
            });
        }
        catch (Exception e) {
            Log.log.warning((Object)"Unable to register event helpers", new Object[]{"error", e});
        }
    }

    protected static <T extends DObject> void informObjectAvailable(Subscriber<T> sub, T obj) {
        try {
            sub.objectAvailable(obj);
        }
        catch (Exception e) {
            Log.log.warning((Object)"Subscriber choked during object available", new Object[]{"obj", StringUtil.safeToString(obj), "sub", sub, e});
        }
    }

    protected class AccessObjectEvent<T extends DObject>
    extends DEvent {
        public static final int SUBSCRIBE = 0;
        public static final int UNSUBSCRIBE = 1;
        protected int _oid;
        protected Subscriber<T> _target;
        protected int _action;

        public AccessObjectEvent(int oid, Subscriber<T> target, int action) {
            super(0);
            this._oid = oid;
            this._target = target;
            this._action = action;
        }

        @Override
        public boolean isPrivate() {
            return true;
        }

        @Override
        public boolean applyToObject(DObject target) throws ObjectAccessException {
            if (this._oid <= 0) {
                this._target.requestFailed(this._oid, new ObjectAccessException("Invalid oid " + this._oid + "."));
                return false;
            }
            DObject obj = (DObject)PresentsDObjectMgr.this._objects.get(this._oid);
            if (this._action == 1) {
                if (obj != null) {
                    obj.removeSubscriber(this._target);
                }
                return false;
            }
            if (obj == null) {
                this._target.requestFailed(this._oid, new NoSuchObjectException(this._oid));
                return false;
            }
            if (!obj.checkPermissions(this._target)) {
                String errmsg = "m.access_denied\t" + this._oid;
                this._target.requestFailed(this._oid, new ObjectAccessException(errmsg));
                return false;
            }
            obj.addSubscriber(this._target);
            PresentsDObjectMgr.informObjectAvailable(this._target, obj);
            return false;
        }
    }

    protected static interface EventHelper {
        public boolean invoke(DEvent var1, DObject var2);
    }

    public static interface LongRunnable
    extends Runnable {
    }

    protected static class ProxyReference {
        public int origObjectId;
        public DObjectManager origManager;

        public ProxyReference(int origObjectId, DObjectManager origManager) {
            this.origObjectId = origObjectId;
            this.origManager = origManager;
        }
    }

    protected static class Reference {
        public int reffingOid;
        public String field;
        public int reffedOid;

        public Reference(int reffingOid, String field, int reffedOid) {
            this.reffingOid = reffingOid;
            this.field = field;
            this.reffedOid = reffedOid;
        }

        public boolean equals(Reference other) {
            if (other == null) {
                return false;
            }
            return this.reffingOid == other.reffingOid && this.field.equals(other.field);
        }

        public boolean equals(int oReffingOid, String oField) {
            return this.reffingOid == oReffingOid && this.field.equals(oField);
        }

        public int hashCode() {
            return this.reffingOid ^ this.field.hashCode();
        }

        public String toString() {
            return "[reffingOid=" + this.reffingOid + ", field=" + this.field + ", reffedOid=" + this.reffedOid + "]";
        }
    }

    public static class Stats {
        public int maxQueueSize;
        public int eventCount;
    }

    protected static class UnitProfile {
        protected long _totalElapsed;
        protected long _longest;
        protected Histogram _histo = new Histogram(0, 20000, 10);

        protected UnitProfile() {
        }

        public void record(long elapsed) {
            this._totalElapsed += elapsed;
            this._histo.addValue((int)elapsed);
            this._longest = Math.max(elapsed, this._longest);
        }

        public String toString() {
            int count = this._histo.size();
            return String.valueOf(this._totalElapsed) + "us/" + count + " = " + this._totalElapsed / (long)count + "us avg " + StringUtil.toString((Object)this._histo.getBuckets()) + " " + this._longest + "us longest";
        }
    }
}

