/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.net;

import com.samskivert.util.StringUtil;
import com.threerings.presents.data.AuthCodes;
import com.threerings.presents.net.AuthResponse;
import com.threerings.presents.net.AuthResponseData;
import com.threerings.presents.net.PublicKeyCredentials;
import com.threerings.presents.util.SecureUtil;
import java.security.PrivateKey;

public class SecureResponse
extends AuthResponse
implements AuthCodes {
    public SecureResponse() {
    }

    public SecureResponse(String code) {
        this._data = new AuthResponseData();
        this._data.code = code;
    }

    public byte[] createSecret(PublicKeyCredentials pkcred, PrivateKey key, int length) {
        this._data = new AuthResponseData();
        byte[] clientSecret = pkcred.getSecret(key);
        if (clientSecret == null) {
            this._data.code = "m.failed_to_secure";
            return null;
        }
        byte[] secret = SecureUtil.createRandomKey(length);
        this._data.code = StringUtil.hexlate((byte[])SecureUtil.xorBytes(secret, clientSecret));
        return secret;
    }

    public byte[] getCodeBytes(PublicKeyCredentials pkcreds) {
        return pkcreds == null || this._data.code == null || this._data.code.equals("m.failed_to_secure") ? null : SecureUtil.xorBytes(StringUtil.unhexlate((String)this._data.code), pkcreds.getSecret());
    }
}

