/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.dobj;

import com.threerings.io.Streamable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class OidList
implements Streamable,
Iterable<Integer> {
    private int[] _oids;
    private int _size;
    protected static final int DEFAULT_SIZE = 4;

    public OidList() {
        this(4);
    }

    public OidList(int initialSize) {
        this._oids = new int[Math.max(initialSize, 2)];
    }

    public int size() {
        return this._size;
    }

    public boolean add(int oid) {
        int ii = 0;
        while (ii < this._size) {
            if (this._oids[ii] == oid) {
                return false;
            }
            ++ii;
        }
        if (this._size + 1 >= this._oids.length) {
            this.expand();
        }
        this._oids[this._size++] = oid;
        return true;
    }

    public boolean remove(int oid) {
        int ii = 0;
        while (ii < this._size) {
            if (this._oids[ii] == oid) {
                System.arraycopy(this._oids, ii + 1, this._oids, ii, --this._size - ii);
                return true;
            }
            ++ii;
        }
        return false;
    }

    public boolean contains(int oid) {
        int ii = 0;
        while (ii < this._size) {
            if (this._oids[ii] == oid) {
                return true;
            }
            ++ii;
        }
        return false;
    }

    public int get(int index) {
        return this._oids[index];
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        int ii = 0;
        while (ii < this._size) {
            if (ii > 0) {
                buf.append(", ");
            }
            buf.append(this._oids[ii]);
            ++ii;
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public Iterator<Integer> iterator() {
        return new OidIterator();
    }

    private void expand() {
        int[] oids = new int[this._oids.length * 2];
        System.arraycopy(this._oids, 0, oids, 0, this._oids.length);
        this._oids = oids;
    }

    protected class OidIterator
    implements Iterator<Integer> {
        protected int _index = 0;

        protected OidIterator() {
        }

        @Override
        public boolean hasNext() {
            return this._index < OidList.this.size();
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return OidList.this.get(this._index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

