/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.client;

import com.google.common.collect.Lists;
import com.samskivert.util.HashIntMap;
import com.threerings.presents.Log;
import com.threerings.presents.client.Client;
import com.threerings.presents.client.InvocationDecoder;
import com.threerings.presents.client.InvocationReceiver;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.data.InvocationMarshaller;
import com.threerings.presents.dobj.DEvent;
import com.threerings.presents.dobj.DObjectManager;
import com.threerings.presents.dobj.DSet;
import com.threerings.presents.dobj.EventListener;
import com.threerings.presents.dobj.InvocationNotificationEvent;
import com.threerings.presents.dobj.InvocationRequestEvent;
import com.threerings.presents.dobj.InvocationResponseEvent;
import com.threerings.presents.dobj.MessageEvent;
import com.threerings.presents.dobj.ObjectAccessException;
import com.threerings.presents.dobj.Subscriber;
import com.threerings.presents.net.Transport;
import java.util.ArrayList;
import java.util.Iterator;

public class InvocationDirector
implements EventListener {
    protected DObjectManager _omgr;
    protected Client _client;
    protected ClientObject _clobj;
    protected short _requestId;
    protected short _receiverId;
    protected HashIntMap<InvocationMarshaller.ListenerMarshaller> _listeners = new HashIntMap();
    protected HashIntMap<InvocationDecoder> _receivers = new HashIntMap();
    protected ArrayList<InvocationDecoder> _reclist = Lists.newArrayList();
    protected long _lastFlushTime;
    protected static final long LISTENER_FLUSH_INTERVAL = 15000L;
    protected static final long LISTENER_MAX_AGE = 90000L;

    public void init(DObjectManager omgr, final int cloid, Client client) {
        if (this._clobj != null) {
            Log.log.warning((Object)"Zoiks, client object around during invmgr init!", new Object[0]);
            this.cleanup();
        }
        this._omgr = omgr;
        this._client = client;
        this._omgr.subscribeToObject(cloid, new Subscriber<ClientObject>(){

            @Override
            public void objectAvailable(ClientObject clobj) {
                clobj.addListener(InvocationDirector.this);
                InvocationDirector.this._clobj = clobj;
                InvocationDirector.this.assignReceiverIds();
                InvocationDirector.this._client.gotClientObject(InvocationDirector.this._clobj);
            }

            @Override
            public void requestFailed(int oid, ObjectAccessException cause) {
                Log.log.warning((Object)"Invocation director unable to subscribe to client object", new Object[]{"cloid", cloid, "cause", cause + "]!"});
                InvocationDirector.this._client.getClientObjectFailed(cause);
            }
        });
    }

    public void cleanup() {
        this._clobj = null;
        this._receivers.clear();
        this._listeners.clear();
        this._requestId = 0;
        this._receiverId = 0;
    }

    public void registerReceiver(InvocationDecoder decoder) {
        this._reclist.add(decoder);
        if (this._clobj != null) {
            this.assignReceiverId(decoder);
        }
    }

    public void unregisterReceiver(String receiverCode) {
        Iterator<InvocationDecoder> iter = this._reclist.iterator();
        while (iter.hasNext()) {
            InvocationDecoder decoder = iter.next();
            if (!decoder.getReceiverCode().equals(receiverCode)) continue;
            iter.remove();
        }
        if (this._clobj != null) {
            InvocationReceiver.Registration rreg = this._clobj.receivers.get((Comparable<?>)((Object)receiverCode));
            if (rreg == null) {
                Log.log.warning((Object)"Receiver unregistered for which we have no id to code mapping", new Object[]{"code", receiverCode});
            } else {
                this._receivers.remove((int)rreg.receiverId);
            }
            this._clobj.removeFromReceivers((Comparable<?>)((Object)receiverCode));
        }
    }

    protected void assignReceiverIds() {
        this._clobj.startTransaction();
        try {
            this._clobj.setReceivers(new DSet<InvocationReceiver.Registration>());
            for (InvocationDecoder decoder : this._reclist) {
                this.assignReceiverId(decoder);
            }
        }
        finally {
            this._clobj.commitTransaction();
        }
    }

    protected void assignReceiverId(InvocationDecoder decoder) {
        InvocationReceiver.Registration reg = new InvocationReceiver.Registration(decoder.getReceiverCode(), this.nextReceiverId());
        this._clobj.addToReceivers(reg);
        this._receivers.put((int)reg.receiverId, (Object)decoder);
    }

    public void sendRequest(int invOid, int invCode, int methodId, Object[] args) {
        this.sendRequest(invOid, invCode, methodId, args, Transport.DEFAULT);
    }

    public void sendRequest(int invOid, int invCode, int methodId, Object[] args, Transport transport) {
        if (this._clobj == null) {
            Log.log.warning((Object)"Dropping invocation request on shutdown director", new Object[]{"code", invCode, "methodId", methodId});
            return;
        }
        int acount = args.length;
        int ii = 0;
        while (ii < acount) {
            Object arg = args[ii];
            if (arg instanceof InvocationMarshaller.ListenerMarshaller) {
                InvocationMarshaller.ListenerMarshaller lm = (InvocationMarshaller.ListenerMarshaller)arg;
                lm.requestId = this.nextRequestId();
                lm.mapStamp = System.currentTimeMillis();
                this._listeners.put((int)lm.requestId, (Object)lm);
            }
            ++ii;
        }
        InvocationRequestEvent event = new InvocationRequestEvent(invOid, invCode, methodId, args);
        event.setTransport(transport);
        event.setSourceOid(this._clobj.getOid());
        this._omgr.postEvent(event);
    }

    @Override
    public void eventReceived(DEvent event) {
        MessageEvent mevt;
        if (event instanceof InvocationResponseEvent) {
            InvocationResponseEvent ire = (InvocationResponseEvent)event;
            this.handleInvocationResponse(ire.getRequestId(), ire.getMethodId(), ire.getArgs());
        } else if (event instanceof InvocationNotificationEvent) {
            InvocationNotificationEvent ine = (InvocationNotificationEvent)event;
            this.handleInvocationNotification(ine.getReceiverId(), ine.getMethodId(), ine.getArgs());
        } else if (event instanceof MessageEvent && (mevt = (MessageEvent)event).getName().equals("!clobj_changed!")) {
            this.handleClientObjectChanged((Integer)mevt.getArgs()[0]);
        }
    }

    protected void handleInvocationResponse(int reqId, int methodId, Object[] args) {
        InvocationMarshaller.ListenerMarshaller listener = (InvocationMarshaller.ListenerMarshaller)this._listeners.remove(reqId);
        if (listener == null) {
            Log.log.warning((Object)"Received invocation response for which we have no registered listener. It is possible that this listener was flushed because the response did not arrive within 90000 milliseconds.", new Object[]{"reqId", reqId, "methId", methodId, "args", args});
            return;
        }
        try {
            listener.dispatchResponse(methodId, args);
        }
        catch (Throwable t) {
            Log.log.warning((Object)"Invocation response listener choked", new Object[]{"listener", listener, "methId", methodId, "args", args, t});
        }
        long now = System.currentTimeMillis();
        if (now - this._lastFlushTime > 15000L) {
            this._lastFlushTime = now;
            this.flushListeners(now);
        }
    }

    protected void handleInvocationNotification(int receiverId, int methodId, Object[] args) {
        InvocationDecoder decoder = (InvocationDecoder)this._receivers.get(receiverId);
        if (decoder == null) {
            Log.log.warning((Object)"Received notification for which we have no registered receiver", new Object[]{"recvId", receiverId, "methodId", methodId, "args", args});
            return;
        }
        try {
            decoder.dispatchNotification(methodId, args);
        }
        catch (Throwable t) {
            Log.log.warning((Object)"Invocation notification receiver choked", new Object[]{"receiver", decoder.receiver, "methId", methodId, "args", args, t});
        }
    }

    protected void handleClientObjectChanged(int newCloid) {
        this._omgr.subscribeToObject(newCloid, new Subscriber<ClientObject>(){

            @Override
            public void objectAvailable(ClientObject clobj) {
                DSet<InvocationReceiver.Registration> receivers = InvocationDirector.this._clobj.receivers;
                InvocationDirector.this._clobj = clobj;
                InvocationDirector.this._clobj.addListener(InvocationDirector.this);
                InvocationDirector.this._clobj.startTransaction();
                try {
                    InvocationDirector.this._clobj.setReceivers(new DSet<InvocationReceiver.Registration>());
                    for (InvocationReceiver.Registration reg : receivers) {
                        InvocationDirector.this._clobj.addToReceivers(reg);
                    }
                }
                finally {
                    InvocationDirector.this._clobj.commitTransaction();
                }
                InvocationDirector.this._client.clientObjectDidChange(InvocationDirector.this._clobj);
            }

            @Override
            public void requestFailed(int oid, ObjectAccessException cause) {
                Log.log.warning((Object)"Aiya! Unable to subscribe to changed client object", new Object[]{"cloid", oid, "cause", cause});
            }
        });
    }

    protected void flushListeners(long now) {
        if (this._listeners.size() > 0) {
            long then = now - 90000L;
            Iterator iter = this._listeners.values().iterator();
            while (iter.hasNext()) {
                InvocationMarshaller.ListenerMarshaller lm = (InvocationMarshaller.ListenerMarshaller)iter.next();
                if (then <= lm.mapStamp) continue;
                iter.remove();
            }
        }
    }

    protected synchronized short nextRequestId() {
        short s = this._requestId;
        this._requestId = (short)(s + 1);
        return s;
    }

    protected synchronized short nextReceiverId() {
        short s = this._receiverId;
        this._receiverId = (short)(s + 1);
        return s;
    }
}

