/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.admin.web.client;

import com.google.common.collect.Maps;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.TabLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.threerings.admin.web.client.ConfigEditorTab;
import com.threerings.admin.web.gwt.ConfigField;
import com.threerings.admin.web.gwt.ConfigService;
import com.threerings.admin.web.gwt.ConfigServiceAsync;
import com.threerings.gwt.util.PopupCallback;
import java.util.Map;

public abstract class ConfigEditorPanel
extends TabLayoutPanel
implements ConfigEditorTab.ConfigAccessor {
    protected Map<String, ConfigEditorTab> _tabs = Maps.newHashMap();
    protected static final ConfigServiceAsync _configsvc = (ConfigServiceAsync)GWT.create(ConfigService.class);

    public ConfigEditorPanel(int barPixelHeight) {
        this(barPixelHeight, Style.Unit.PX);
    }

    public ConfigEditorPanel(int barHeight, Style.Unit unit) {
        super((double)barHeight, unit);
        this.addStyleName("configEditorPanel");
        ((ServiceDefTarget)_configsvc).setServiceEntryPoint(this.getServiceEntryPoint());
        _configsvc.getConfiguration((AsyncCallback<ConfigService.ConfigurationResult>)new PopupCallback<ConfigService.ConfigurationResult>(){

            public void onSuccess(ConfigService.ConfigurationResult result) {
                ConfigEditorPanel.this.gotData(result);
            }
        });
    }

    @Override
    public void submitChanges(String key, ConfigField[] modified, AsyncCallback<ConfigService.ConfigurationRecord> callback) {
        _configsvc.updateConfiguration(key, modified, callback);
    }

    protected void gotData(ConfigService.ConfigurationResult result) {
        this.clear();
        if (result.records.isEmpty()) {
            return;
        }
        for (Map.Entry<String, ConfigService.ConfigurationRecord> tab : result.records.entrySet()) {
            String tabKey = tab.getKey();
            ConfigEditorTab widget = new ConfigEditorTab(this, tabKey, tab.getValue());
            this._tabs.put(tabKey, widget);
            this.add((Widget)widget, tabKey);
        }
        this.selectTab(0);
    }

    protected abstract String getServiceEntryPoint();
}

