/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.admin.client;

import com.google.common.base.Objects;
import com.samskivert.swing.HGroupLayout;
import com.threerings.admin.Log;
import com.threerings.presents.dobj.AttributeChangeListener;
import com.threerings.presents.dobj.AttributeChangedEvent;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.util.PresentsContext;
import java.awt.Color;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.Field;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class FieldEditor
extends JPanel
implements AttributeChangeListener,
ActionListener,
FocusListener {
    protected PresentsContext _ctx;
    protected Field _field;
    protected Accessor _accessor;
    protected JLabel _label;

    public FieldEditor(PresentsContext ctx, Field field, DObject object) {
        this._ctx = ctx;
        this._field = field;
        this.setAccessor(new DObjectAccessor(object));
        this.setLayout((LayoutManager)new HGroupLayout(HGroupLayout.STRETCH));
        this._label = new JLabel(this._field.getName());
        this.add(this._label);
        this.updateBorder(false);
    }

    public void setAccessor(Accessor accessor) {
        this._accessor = accessor;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._accessor.added();
        this.displayValue(this.getValue());
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this._accessor.removed();
    }

    @Override
    public void attributeChanged(AttributeChangedEvent event) {
        this.noteUpdatedExternally();
    }

    public void noteUpdatedExternally() {
        this.displayValue(this.getValue());
        this.updateBorder(false);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object value = null;
        try {
            value = this.getDisplayValue();
        }
        catch (Exception e) {
            this.updateBorder(true);
            return;
        }
        if (!this.valueMatches(value)) {
            this._accessor.set(this._field, value);
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
    }

    @Override
    public void focusLost(FocusEvent event) {
        Object dvalue = null;
        try {
            dvalue = this.getDisplayValue();
        }
        catch (Exception e) {
            Log.log.warning((Object)("Failed to parse display value " + e + "."), new Object[0]);
            this.displayValue(this.getValue());
        }
        this.updateBorder(!this.valueMatches(dvalue));
    }

    protected boolean valueMatches(Object dvalue) {
        return Objects.equal((Object)dvalue, (Object)this.getValue());
    }

    protected abstract Object getDisplayValue() throws Exception;

    protected abstract void displayValue(Object var1);

    protected Object getValue() {
        return this._accessor.get(this._field);
    }

    protected void updateBorder(boolean modified) {
        if (modified) {
            this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, Color.red));
        } else {
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }
    }

    public static interface Accessor {
        public void added();

        public void removed();

        public void set(Field var1, Object var2);

        public Object get(Field var1);
    }

    protected class DObjectAccessor
    implements Accessor {
        protected DObject _obj;

        public DObjectAccessor(DObject obj) {
            this._obj = obj;
        }

        @Override
        public void added() {
            this._obj.addListener(FieldEditor.this);
        }

        @Override
        public void removed() {
            this._obj.removeListener(FieldEditor.this);
        }

        @Override
        public void set(Field field, Object value) {
            this._obj.changeAttribute(field.getName(), value);
        }

        @Override
        public Object get(Field field) {
            try {
                return field.get(this._obj);
            }
            catch (Exception e) {
                Log.log.warning((Object)"Failed to fetch field", new Object[]{"field", field, "object", this._obj, "error", e});
                return null;
            }
        }
    }
}

