/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.tools.cpp;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.threerings.presents.tools.InvocationTask;
import com.threerings.presents.tools.cpp.CPPArgBuilder;
import java.util.List;

public class MethodDescriptor {
    public final String methodName;
    public final String vectorArguments;
    public final String arguments;
    public final String clientArguments;
    public final List<String> serviceArguments;

    public static List<MethodDescriptor> from(List<InvocationTask.ServiceMethod> methods) {
        return Lists.transform(methods, (Function)new Function<InvocationTask.ServiceMethod, MethodDescriptor>(){

            public MethodDescriptor apply(InvocationTask.ServiceMethod from) {
                return new MethodDescriptor(from);
            }
        });
    }

    public MethodDescriptor(InvocationTask.ServiceMethod methodSource) {
        this.methodName = methodSource.method.getName();
        this.vectorArguments = new CPPArgBuilder().getArgumentsFromVector(methodSource);
        this.arguments = new CPPArgBuilder().getArguments(methodSource);
        this.clientArguments = new CPPArgBuilder().getArguments(methodSource, "Shared<presents::PresentsClient> client");
        this.serviceArguments = new CPPArgBuilder().getServiceArguments(methodSource);
    }
}

