/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.tools;

import com.google.common.collect.Lists;
import com.threerings.io.Streamable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;

public class StreamableClassRequirements {
    public final List<Field> streamedFields = Lists.newArrayList();
    public final boolean superclassStreamable;
    public final Class<?> klass;

    public StreamableClassRequirements(Class<?> klass) {
        this.klass = klass;
        this.superclassStreamable = klass.getSuperclass() != null && Streamable.class.isAssignableFrom(klass.getSuperclass());
        for (Field field : klass.getDeclaredFields()) {
            int mods = field.getModifiers();
            if (Modifier.isStatic(mods) || Modifier.isTransient(mods)) continue;
            this.streamedFields.add(field);
        }
    }
}

