/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.tools;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.samskivert.util.StringUtil;
import com.threerings.presents.client.InvocationService;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.data.InvocationMarshaller;
import com.threerings.presents.server.InvocationDispatcher;
import com.threerings.presents.server.InvocationException;
import com.threerings.presents.server.InvocationProvider;
import com.threerings.presents.tools.ActionScriptUtils;
import com.threerings.presents.tools.GenUtil;
import com.threerings.presents.tools.ImportSet;
import com.threerings.presents.tools.InvocationTask;
import com.threerings.util.ActionScript;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GenServiceTask
extends InvocationTask {
    protected boolean _verbose;
    protected File _asroot;
    protected Set<String> _providerless = Sets.newHashSet();
    protected Set<String> _aslistenerAdapters = Sets.newHashSet();
    protected static final String MARSHALLER_TMPL = "com/threerings/presents/tools/marshaller.tmpl";
    protected static final String DISPATCHER_TMPL = "com/threerings/presents/tools/dispatcher.tmpl";
    protected static final String PROVIDER_TMPL = "com/threerings/presents/tools/provider.tmpl";
    protected static final String AS_SERVICE_TMPL = "com/threerings/presents/tools/service_as.tmpl";
    protected static final String AS_LISTENER_SERVICE_TMPL = "com/threerings/presents/tools/service_listener_as.tmpl";
    protected static final String AS_LISTENER_ADAPTER_SERVICE_TMPL = "com/threerings/presents/tools/service_listener_adapter_as.tmpl";
    protected static final String AS_MARSHALLER_TMPL = "com/threerings/presents/tools/marshaller_as.tmpl";
    protected static final String AS_LISTENER_MARSHALLER_TMPL = "com/threerings/presents/tools/marshaller_listener_as.tmpl";

    public void setVerbose(boolean verbose) {
        this._verbose = verbose;
    }

    public void setAsroot(File asroot) {
        this._asroot = asroot;
    }

    public Providerless createProviderless() {
        return new Providerless();
    }

    public Adapter createAdapter() {
        return new Adapter();
    }

    @Override
    public void processClass(File source, Class<?> service) throws Exception {
        System.out.println("Processing " + service.getName() + "...");
        if (!service.getName().endsWith("Service")) {
            System.err.println("Cannot process '" + service.getName() + "':");
            System.err.println("Service classes must be named SomethingService.");
            return;
        }
        ServiceDescription desc = new ServiceDescription(service);
        this.generateMarshaller(source, desc);
        if (!this._providerless.contains(service.getSimpleName())) {
            this.generateProvider(source, desc);
        }
    }

    protected void generateMarshaller(File source, ServiceDescription sdesc) throws Exception {
        if (this._verbose) {
            System.out.println("Generating marshaller");
        }
        String sname = sdesc.sname;
        String name = sname.replace("Service", "");
        String mname = sname.replace("Service", "Marshaller");
        String mpackage = sdesc.spackage.replace(".client", ".data");
        ImportSet imports = sdesc.constructAllImports();
        imports.add(sdesc.service);
        imports.add(InvocationMarshaller.class);
        imports.add("javax.annotation.Generated");
        if (sdesc.callerTypeSpecified) {
            imports.add(sdesc.callerType);
        }
        imports.translateClassArrays();
        imports.removeGlobals();
        imports.removeArrays();
        imports.duplicateAndMunge("*Listener", "Service", "Marshaller", "Listener", "Marshaller", ".client.", ".data.");
        imports.swapInnerClassesForParents();
        imports.removeSamePackage(mpackage);
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("name", name);
        ctx.put("generated", this.getGeneratedAnnotation(name));
        ctx.put("package", mpackage);
        ctx.put("methods", sdesc.methods);
        ctx.put("listeners", sdesc.listeners);
        ctx.put("typeParameters", sdesc.callerTypeSpecified ? "<" + sdesc.callerType.getSimpleName() + ">" : "");
        ctx.put("importGroups", imports.toGroups());
        String mpath = source.getPath();
        mpath = mpath.replace("Service", "Marshaller");
        mpath = GenServiceTask.replacePath(mpath, "/client/", "/data/");
        this.writeTemplate(MARSHALLER_TMPL, mpath, ctx);
        if (this._asroot == null || sdesc.skipAS) {
            return;
        }
        imports = sdesc.imports.clone();
        imports.add(sdesc.service);
        imports.add(InvocationMarshaller.class);
        imports.translateInnerClasses();
        imports.duplicateAndMunge("*.InvocationService_InvocationListener", "InvocationService_InvocationListener", "InvocationMarshaller_ListenerMarshaller", ".client.", ".data.");
        imports.pushOut("*.InvocationService_InvocationListener");
        imports.duplicateAndMunge("*Listener", "Service", "Marshaller", "Listener", "Marshaller", ".client.", ".data.");
        imports.popIn();
        for (InvocationTask.ServiceMethod method : sdesc.methods) {
            method.gatherASWrappedArgListImports(imports);
        }
        ActionScriptUtils.convertBaseClasses(imports);
        imports.removeSamePackage(mpackage);
        ctx.put("importGroups", imports.toGroups());
        String mppath = mpackage.replace('.', File.separatorChar);
        new File(this._asroot + File.separator + mppath).mkdirs();
        String ampath = this._asroot + File.separator + mppath + File.separator + mname + ".as";
        this.writeTemplate(AS_MARSHALLER_TMPL, ampath, ctx);
        Class<InvocationMarshaller.ListenerMarshaller> imlm = InvocationMarshaller.ListenerMarshaller.class;
        for (ServiceListener listener : sdesc.listeners) {
            imports = listener.imports.clone();
            imports.add(imlm);
            imports.add(listener.listener);
            imports.translateInnerClasses();
            ActionScriptUtils.convertBaseClasses(imports);
            imports.removeSamePackage(mpackage);
            ctx.put("importGroups", imports.toGroups());
            ctx.put("listener", listener);
            String aslpath = this._asroot + File.separator + mppath + File.separator + mname + "_" + listener.getListenerName() + "Marshaller.as";
            this.writeTemplate(AS_LISTENER_MARSHALLER_TMPL, aslpath, ctx);
        }
        imports = sdesc.imports.clone();
        imports.add(InvocationService.class);
        imports.translateInnerClasses();
        imports.remove("boolean");
        imports.remove("byte");
        imports.remove("short");
        imports.remove("char");
        ActionScriptUtils.convertBaseClasses(imports);
        imports.removeSamePackage(sdesc.spackage);
        ctx.put("importGroups", imports.toGroups());
        ctx.put("package", sdesc.spackage);
        String sppath = sdesc.spackage.replace('.', File.separatorChar);
        new File(this._asroot + File.separator + sppath).mkdirs();
        String aspath = this._asroot + File.separator + sppath + File.separator + sname + ".as";
        this.writeTemplate(AS_SERVICE_TMPL, aspath, ctx);
        Class<InvocationService.InvocationListener> isil = InvocationService.InvocationListener.class;
        for (ServiceListener listener : sdesc.listeners) {
            imports = listener.imports.clone();
            imports.add(isil);
            imports.add(listener.listener);
            imports.translateInnerClasses();
            ActionScriptUtils.convertBaseClasses(imports);
            imports.removeSamePackage(sdesc.spackage);
            ctx.put("importGroups", imports.toGroups());
            ctx.put("listener", listener);
            String aslpath = this._asroot + File.separator + sppath + File.separator + sname + "_" + listener.getListenerName() + "Listener.as";
            this.writeTemplate(AS_LISTENER_SERVICE_TMPL, aslpath, ctx);
            if (!this._aslistenerAdapters.contains(sname)) continue;
            String aslapath = this._asroot + File.separator + sppath + File.separator + sname + "_" + listener.getListenerName() + "ListenerAdapter.as";
            this.writeTemplate(AS_LISTENER_ADAPTER_SERVICE_TMPL, aslapath, ctx);
        }
    }

    protected void generateDispatcher(File source, ServiceDescription sdesc) throws Exception {
        if (this._verbose) {
            System.out.println("Generating dispatcher");
        }
        String name = sdesc.sname.replace("Service", "");
        String dpackage = sdesc.spackage.replace(".client", ".server");
        ImportSet imports = sdesc.imports.clone();
        if (sdesc.listeners.size() > 0) {
            imports.add(sdesc.service);
        }
        imports.add(sdesc.callerType);
        imports.add(InvocationDispatcher.class);
        imports.add(InvocationException.class);
        imports.translateClassArrays();
        imports.removeGlobals();
        imports.removeArrays();
        imports.addMunged(sdesc.service, "Service", "Marshaller", ".client.", ".data.");
        imports.swapInnerClassesForParents();
        imports.removeSamePackage(dpackage);
        String mpath = source.getPath();
        mpath = mpath.replace("Service", "Dispatcher");
        mpath = GenServiceTask.replacePath(mpath, "/client/", "/server/");
        this.writeTemplate(DISPATCHER_TMPL, mpath, "name", name, "generated", this.getGeneratedAnnotation(name), "package", dpackage, "methods", sdesc.methods, "imports", imports.toList());
    }

    protected void generateProvider(File source, ServiceDescription sdesc) throws Exception {
        if (this._verbose) {
            System.out.println("Generating provider");
        }
        String name = sdesc.sname.replace("Service", "");
        String mpackage = sdesc.spackage.replace(".client", ".server");
        ImportSet imports = sdesc.imports.clone();
        if (!sdesc.methods.isEmpty()) {
            imports.add(sdesc.callerType);
        }
        imports.add(InvocationProvider.class);
        imports.add(sdesc.service);
        imports.add("javax.annotation.Generated");
        if (sdesc.hasAnyListenerArgs()) {
            imports.add(InvocationException.class);
        }
        imports.translateClassArrays();
        imports.removeGlobals();
        imports.removeArrays();
        imports.swapInnerClassesForParents();
        imports.removeSamePackage(mpackage);
        String mpath = source.getPath();
        mpath = mpath.replace("Service", "Provider");
        mpath = GenServiceTask.replacePath(mpath, "/client/", "/server/");
        this.writeTemplate(PROVIDER_TMPL, mpath, "name", name, "generated", this.getGeneratedAnnotation(name), "package", mpackage, "methods", sdesc.methods, "listeners", sdesc.listeners, "callerType", sdesc.callerType.getSimpleName(), "importGroups", imports.toGroups());
    }

    protected String getGeneratedAnnotation(String name) {
        return GenUtil.getGeneratedAnnotation(((Object)((Object)this)).getClass(), 0, false, "Derived from " + name + "Service.java.");
    }

    protected class ServiceDescription {
        public Class<?> callerType = ClientObject.class;
        public boolean callerTypeSpecified;
        public Class<?> service;
        public String sname;
        public String spackage;
        public ImportSet imports = new ImportSet();
        public List<InvocationTask.ServiceMethod> methods = Lists.newArrayList();
        public List<ServiceListener> listeners = Lists.newArrayList();
        public final boolean skipAS;

        public ServiceDescription(Class<?> serviceClass) {
            Method[] methdecls;
            this.service = serviceClass;
            Type[] genint = this.service.getGenericInterfaces();
            if (genint.length > 0 && genint[0] instanceof ParameterizedType) {
                this.callerType = (Class)((ParameterizedType)genint[0]).getActualTypeArguments()[0];
                this.callerTypeSpecified = true;
            }
            this.sname = this.service.getSimpleName();
            this.spackage = this.service.getPackage().getName();
            ActionScript asa = this.service.getAnnotation(ActionScript.class);
            this.skipAS = asa != null && asa.omit();
            for (Method m : methdecls = this.service.getDeclaredMethods()) {
                Class<?>[] args;
                if (!Modifier.isPublic(m.getModifiers()) && !Modifier.isAbstract(m.getModifiers())) continue;
                for (Class<?> arg : args = m.getParameterTypes()) {
                    if (!GenServiceTask.this._ilistener.isAssignableFrom(arg) || !GenUtil.simpleName(arg).startsWith(this.sname + ".")) continue;
                    InvocationTask.checkedAdd(this.listeners, new ServiceListener(this.service, arg));
                }
                if (GenServiceTask.this._verbose) {
                    System.out.println("Adding " + m + ", imports are " + StringUtil.toString((Object)this.imports));
                }
                this.methods.add(GenServiceTask.this.createAndGatherImports(m, this.imports));
                if (!GenServiceTask.this._verbose) continue;
                System.out.println("Added " + m + ", imports are " + StringUtil.toString((Object)this.imports));
            }
            Collections.sort(this.listeners);
            Collections.sort(this.methods);
        }

        public boolean hasAnyListenerArgs() {
            return Iterables.any(this.methods, (Predicate)new Predicate<InvocationTask.ServiceMethod>(){

                public boolean apply(InvocationTask.ServiceMethod sm) {
                    return !sm.listenerArgs.isEmpty();
                }
            });
        }

        public ImportSet constructAllImports() {
            ImportSet allimports = this.imports.clone();
            for (ServiceListener listener : this.listeners) {
                allimports.addAll(listener.imports);
            }
            return allimports;
        }
    }

    public class Adapter {
        public void setService(String className) {
            GenServiceTask.this._aslistenerAdapters.add(className);
        }
    }

    public class Providerless {
        public void setService(String className) {
            GenServiceTask.this._providerless.add(className);
        }
    }

    public class ServiceListener
    implements Comparable<ServiceListener> {
        public Class<?> listener;
        public List<InvocationTask.ServiceMethod> methods = Lists.newArrayList();
        public ImportSet imports = new ImportSet();

        public ServiceListener(Class<?> service, Class<?> listener) {
            this.listener = listener;
            HashSet ifaces = Sets.newHashSet();
            this.addInterfaces(listener, ifaces);
            for (Class iface : ifaces) {
                Method[] methdecls;
                for (Method m : methdecls = iface.getDeclaredMethods()) {
                    if (!Modifier.isPublic(m.getModifiers()) && !Modifier.isAbstract(m.getModifiers())) continue;
                    if (GenServiceTask.this._verbose) {
                        System.out.println("Adding " + m + ", imports are " + StringUtil.toString((Object)this.imports));
                    }
                    this.methods.add(GenServiceTask.this.createAndGatherImports(m, this.imports));
                    if (!GenServiceTask.this._verbose) continue;
                    System.out.println("Added " + m + ", imports are " + StringUtil.toString((Object)this.imports));
                }
            }
            Collections.sort(this.methods);
        }

        protected void addInterfaces(Class<?> listener, Set<Class<?>> ifaces) {
            if (!GenServiceTask.this._ilistener.isAssignableFrom(listener) || GenServiceTask.this._ilistener.equals(listener)) {
                return;
            }
            ifaces.add(listener);
            for (Class<?> iface : listener.getInterfaces()) {
                this.addInterfaces(iface, ifaces);
            }
        }

        public boolean hasParameterizedMethodArgs() {
            return Iterables.any(this.methods, (Predicate)new Predicate<InvocationTask.ServiceMethod>(){

                public boolean apply(InvocationTask.ServiceMethod sm) {
                    return sm.hasParameterizedArgs();
                }
            });
        }

        public String getListenerName() {
            String name = GenUtil.simpleName(this.listener);
            name = name.replace("Listener", "");
            int didx = name.indexOf(".");
            return name.substring(didx + 1);
        }

        public String adapterCtorArgs() {
            StringBuilder sb = new StringBuilder();
            for (InvocationTask.ServiceMethod m : this.methods) {
                sb.append(m.method.getName() + " :Function, ");
            }
            return sb.toString();
        }

        @Override
        public int compareTo(ServiceListener other) {
            return this.getListenerName().compareTo(other.getListenerName());
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && this.listener.equals(((ServiceListener)other).listener);
        }

        public int hashCode() {
            return this.listener.getName().hashCode();
        }
    }
}

