/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.tools.cpp;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.threerings.presents.tools.GenServiceTask;
import com.threerings.presents.tools.InvocationTask;
import com.threerings.presents.tools.cpp.CPPArgBuilder;
import com.threerings.presents.tools.cpp.CPPType;
import com.threerings.presents.tools.cpp.CPPUtil;
import com.threerings.presents.tools.cpp.MethodDescriptor;
import java.io.File;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;

public class GenCPPServiceTask
extends GenServiceTask {
    protected File _cpproot;
    protected static final String HEADER_TMPL = "com/threerings/presents/tools/cpp/marshaller_h.mustache";
    protected static final String CPP_TMPL = "com/threerings/presents/tools/cpp/marshaller_cpp.mustache";

    public void setCpproot(File asroot) {
        this._cpproot = asroot;
    }

    protected void generateMarshaller(File source, GenServiceTask.ServiceDescription sdesc) throws Exception {
        String name = sdesc.sname.replace("Service", "Marshaller");
        String mpackage = sdesc.spackage.replace(".client", ".data");
        List<String> namespaces = CPPUtil.makeNamespaces(mpackage);
        HashMap ctx = Maps.newHashMap();
        ctx.put("name", name);
        ctx.put("javaName", mpackage + "." + name);
        ctx.put("namespaces", namespaces);
        ctx.put("namespace", Joiner.on((String)"::").join(namespaces));
        ctx.put("methods", MethodDescriptor.from(sdesc.methods));
        ctx.put("listeners", sdesc.listeners);
        ctx.put("argbuilder", new CPPArgBuilder());
        TreeSet includes = Sets.newTreeSet();
        TreeSet implIncludes = Sets.newTreeSet();
        for (InvocationTask.ServiceMethod meth : sdesc.methods) {
            for (Type type : meth.method.getGenericParameterTypes()) {
                CPPType cppType = new CPPType(type);
                if (cppType.primitive) {
                    implIncludes.add("presents/box/Boxed" + cppType.interpreter + ".h");
                }
                while (cppType != null) {
                    if (cppType.representationImport != null) {
                        includes.add(cppType.representationImport);
                    }
                    cppType = cppType.dependent;
                }
            }
        }
        ctx.put("includes", implIncludes);
        this.writeTemplate(CPP_TMPL, CPPUtil.makePath(this._cpproot, namespaces, name, ".cpp"), ctx);
        ctx.put("includes", includes);
        this.writeTemplate(HEADER_TMPL, CPPUtil.makePath(this._cpproot, namespaces, name, ".h"), ctx);
        super.generateMarshaller(source, sdesc);
    }
}

