/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.tools;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.samskivert.io.StreamUtil;
import com.samskivert.mustache.Mustache;
import com.threerings.presents.tools.GenUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.ClasspathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenTask
extends Task {
    protected static String EOL = System.getProperty("line.separator");
    protected List<FileSet> _filesets = Lists.newArrayList();
    protected ClassLoader _cloader;
    protected String _header;
    protected boolean _checking;
    protected Set<String> _modifiedPaths = Sets.newHashSet();

    public void addFileset(FileSet set) {
        this._filesets.add(set);
    }

    public void setHeader(File header) {
        try {
            this._header = StreamUtil.toString((Reader)new FileReader(header));
        }
        catch (IOException ioe) {
            System.err.println("Unabled to load header '" + header + ": " + ioe.getMessage());
        }
    }

    public void setClasspathref(Reference pathref) {
        this._cloader = ClasspathUtils.getClassLoaderForPath((Project)this.getProject(), (Reference)pathref);
        ((AntClassLoader)this._cloader).setParent(((Object)((Object)this)).getClass().getClassLoader());
    }

    public void setChecking(boolean checking) {
        this._checking = checking;
    }

    public void execute() {
        if (this._checking) {
            this.log("Only checking if generation would change files", 3);
        }
        for (FileSet fs : this._filesets) {
            String[] srcFiles;
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File fromDir = fs.getDir(this.getProject());
            for (String srcFile : srcFiles = ds.getIncludedFiles()) {
                File source = new File(fromDir, srcFile);
                try {
                    this.processClass(source, this.loadClass(source));
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e);
                }
            }
        }
        if (this._checking && !this._modifiedPaths.isEmpty()) {
            throw new BuildException("Generation would produce changes!");
        }
    }

    protected void writeTemplate(String templatePath, String outputPath, Object ... data) throws IOException {
        this.writeTemplate(templatePath, outputPath, this.createMap(data));
    }

    protected void writeTemplate(String templatePath, String outputPath, Map<String, Object> data) throws IOException {
        String output = this.mergeTemplate(templatePath, data);
        if (this._header != null) {
            output = this.convertEols(this._header) + output;
        }
        this.writeFile(outputPath, output);
    }

    protected void writeFile(String outputPath, String output) throws IOException {
        File dest = new File(outputPath);
        if (dest.exists()) {
            if (this.wouldProduceSameFile(output, dest)) {
                this.log("Skipping '" + outputPath + "' as it hasn't changed", 3);
                return;
            }
        } else if (!dest.getParentFile().exists() && !dest.getParentFile().mkdirs()) {
            throw new BuildException("Unable to create directory for '" + dest.getAbsolutePath() + "'");
        }
        this._modifiedPaths.add(outputPath);
        if (this._checking) {
            this.log("Generating '" + outputPath + "' would have produced changes!", 0);
            return;
        }
        this.log("Writing file " + outputPath, 3);
        new PrintWriter(dest, "UTF-8").append(output).close();
    }

    protected boolean wouldProduceSameFile(String generated, File existing) throws IOException {
        Iterator generatedLines = Splitter.on((String)EOL).split((CharSequence)generated).iterator();
        for (String prev : Files.readLines((File)existing, (Charset)Charsets.UTF_8)) {
            if (!generatedLines.hasNext()) {
                return false;
            }
            String cur = (String)generatedLines.next();
            if (prev.equals(cur) || prev.startsWith("// $Id") && cur.startsWith("// $Id")) continue;
            return false;
        }
        if (generatedLines.hasNext()) {
            return ((String)generatedLines.next()).equals("") && !generatedLines.hasNext();
        }
        return true;
    }

    protected String mergeTemplate(String template, Object ... data) throws IOException {
        return this.mergeTemplate(template, this.createMap(data));
    }

    protected String mergeTemplate(String template, Map<String, Object> data) throws IOException {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(template), Charsets.UTF_8);
        return this.convertEols(Mustache.compiler().escapeHTML(false).compile((Reader)reader).execute(data));
    }

    protected Map<String, Object> createMap(Object ... data) {
        HashMap ctx = Maps.newHashMap();
        for (int ii = 0; ii < data.length; ii += 2) {
            ctx.put((String)data[ii], data[ii + 1]);
        }
        return ctx;
    }

    protected abstract void processClass(File var1, Class<?> var2) throws Exception;

    protected Class<?> loadClass(File source) {
        String name;
        try {
            name = GenUtil.readClassName(source);
        }
        catch (Exception e) {
            throw new BuildException("Failed to parse " + source, (Throwable)e);
        }
        return this.loadClass(name);
    }

    protected Class<?> loadClass(String name) {
        if (this._cloader == null) {
            throw new BuildException("This task requires a 'classpathref' attribute to be set to the project's classpath.");
        }
        try {
            return this._cloader.loadClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            throw new BuildException("Failed to load " + name + ".  Be sure to set the 'classpathref' attribute to a " + "classpath that contains your project's presents classes.", (Throwable)cnfe);
        }
    }

    protected String convertEols(String str) {
        return str.replace("\n", EOL);
    }
}

