/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.samskivert.util.ObjectUtil;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadLocalLogger {
    private static boolean isDebug = false;
    private static ThreadLocal<Object> local = new ThreadLocal();
    private static AtomicInteger index = new AtomicInteger(0);

    public static void start(Object obj, String phaser, Object msg) {
        if (isDebug) {
            local.set(obj);
            System.out.println("<<start index=" + index.getAndIncrement() + "," + phaser + "," + msg);
        }
    }

    public static void stop(Object obj, String phaser, Object msg) {
        if (isDebug && ObjectUtil.equals((Object)obj, (Object)local.get())) {
            local.set(null);
            System.out.println(">>>end index=" + index.getAndIncrement() + "," + phaser + "," + msg);
        }
    }

    public static void log(String phaser, Object msg) {
        if (isDebug && local.get() != null) {
            System.out.println("index=" + index.getAndIncrement() + "," + phaser + "," + msg);
        }
    }
}

