/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.threerings.ClydeLog;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.prefs.Preferences;

public class ResourceUtil {
    protected static Preferences _prefs = Preferences.userNodeForPackage(ResourceUtil.class);
    protected static String _prefPrefix = "";

    public static String getPreferredResourceDir() {
        return _prefs.get("resource_dir", null);
    }

    public static void setPreferredResourceDir(String dir) {
        if (dir == null) {
            _prefs.remove("resource_dir");
        } else {
            _prefs.put("resource_dir", dir);
        }
    }

    public static String[] loadStrings(String path) {
        ArrayList<String> strings = new ArrayList<String>();
        InputStream stream = ResourceUtil.getResourceAsStream(path);
        if (stream != null) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                while ((line = reader.readLine()) != null) {
                    strings.add(line);
                }
            }
            catch (IOException e) {
                ClydeLog.log.warning((Object)("Failed to read strings from resource [path=" + path + ", error=" + e + "]."), new Object[0]);
            }
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static Properties loadProperties(String path) {
        Properties props = new Properties();
        InputStream stream = ResourceUtil.getResourceAsStream(path);
        if (stream != null) {
            try {
                props.load(stream);
            }
            catch (IOException e) {
                ClydeLog.log.warning((Object)("Failed to read properties from resource [path=" + path + ", error=" + e + "]."), new Object[0]);
            }
        }
        return props;
    }

    public static InputStream getResourceAsStream(String path) {
        InputStream stream = ResourceUtil.class.getResourceAsStream("/" + path);
        if (stream == null) {
            ClydeLog.log.warning((Object)"Missing resource.", new Object[]{"path", path});
            stream = new ByteArrayInputStream(new byte[0]);
        }
        return stream;
    }

    public static String getPrefsPrefix() {
        return _prefPrefix;
    }
}

