/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.threerings.ClydeLog;
import com.threerings.util.Inner;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;

public class ReflectionUtil {
    protected static HashMap<Class<?>, Field> _outers = new HashMap();
    protected static HashMap<Class<?>, Class<?>> _oclasses = new HashMap();
    protected static HashMap<Class<?>, Constructor> _ctors = new HashMap();

    public static Object newInstance(String classname) {
        return ReflectionUtil.newInstance(classname, null);
    }

    public static Object newInstance(String classname, Object outer) {
        try {
            return ReflectionUtil.newInstance(Class.forName(classname), outer);
        }
        catch (Exception e) {
            ClydeLog.log.warning((Object)("Failed to get class by name [class=" + classname + "]."), new Object[]{e});
            return null;
        }
    }

    public static Object newInstance(Class<?> clazz) {
        return ReflectionUtil.newInstance(clazz, null);
    }

    public static Object newInstance(Class<?> clazz, Object outer) {
        Constructor<?> ctor;
        if (!ReflectionUtil.isInner(clazz)) {
            outer = null;
        }
        if ((ctor = _ctors.get(clazz)) == null) {
            for (Constructor<?> octor : clazz.getDeclaredConstructors()) {
                Class<?>[] ptypes = octor.getParameterTypes();
                if (!(outer == null ? ptypes.length == 0 : ptypes.length == 1 && ptypes[0].isInstance(outer))) continue;
                ctor = octor;
                break;
            }
            if (ctor == null) {
                ClydeLog.log.warning((Object)"Class has no default constructor.", new Object[]{"class", clazz, new Exception()});
                return null;
            }
            ctor.setAccessible(true);
            _ctors.put(clazz, ctor);
        }
        try {
            return outer == null ? ctor.newInstance(new Object[0]) : ctor.newInstance(outer);
        }
        catch (Exception e) {
            ClydeLog.log.warning((Object)"Failed to create new instance.", new Object[]{"class", clazz, e});
            return null;
        }
    }

    public static void setOuter(Object object, Object outer) {
        Class<?> clazz = object.getClass();
        if (!ReflectionUtil.isInner(clazz)) {
            return;
        }
        if (object instanceof Inner) {
            ((Inner)object).setOuter(outer);
            return;
        }
        try {
            ReflectionUtil.getOuterField(clazz).set(object, outer);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static Object getOuter(Object object) {
        Class<?> clazz = object.getClass();
        if (!ReflectionUtil.isInner(clazz)) {
            return null;
        }
        if (object instanceof Inner) {
            return ((Inner)object).getOuter();
        }
        try {
            return ReflectionUtil.getOuterField(clazz).get(object);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static boolean isInner(Class<?> clazz) {
        return ReflectionUtil.getOuterClass(clazz) != null;
    }

    public static Class<?> getOuterClass(Class<?> clazz) {
        Class<Object> oclazz = _oclasses.get(clazz);
        if (oclazz == null) {
            Class<?> dclazz = clazz.getDeclaringClass();
            if (dclazz != null && !Modifier.isStatic(clazz.getModifiers())) {
                oclazz = dclazz;
            } else if (Inner.class.isAssignableFrom(clazz)) {
                for (Constructor<?> ctor : clazz.getDeclaredConstructors()) {
                    Class<?>[] ptypes = ctor.getParameterTypes();
                    if (ptypes.length <= 0) continue;
                    oclazz = ptypes[0];
                    break;
                }
            } else {
                oclazz = Void.class;
            }
            _oclasses.put(clazz, oclazz);
        }
        return oclazz == Void.class ? null : oclazz;
    }

    protected static Field getOuterField(Class<?> clazz) {
        Field field = _outers.get(clazz);
        if (field == null) {
            Class<?> dclazz = clazz.getDeclaringClass();
            for (Field ofield : clazz.getDeclaredFields()) {
                if (!ofield.isSynthetic() || ofield.getType() != dclazz || !ofield.getName().startsWith("this")) continue;
                field = ofield;
                break;
            }
            field.setAccessible(true);
            _outers.put(clazz, field);
        }
        return field;
    }
}

