/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.util;

import com.threerings.math.FloatMath;
import com.threerings.math.Vector2f;
import com.threerings.tudey.util.Direction;

public class DirectionUtil {
    public static boolean alterStep(Vector2f step, int directions) {
        if (directions == 0) {
            return true;
        }
        for (int ii = 0; ii < 4; ++ii) {
            if ((directions & 1 << ii) == 0 || !(step.dot(Direction.CARDINAL_VALUES[ii].getVector2f()) < 0.0f)) continue;
            Vector2f vec = Direction.CARDINAL_VALUES[(ii + 3) % 4].getVector2f();
            float dot = step.dot(vec);
            if (dot > 0.0f) {
                step.set(vec.mult(dot));
                continue;
            }
            vec = Direction.CARDINAL_VALUES[(ii + 1) % 4].getVector2f();
            dot = step.dot(vec);
            if (dot > 0.0f) {
                step.set(vec.mult(dot));
                continue;
            }
            step.set(0.0f, 0.0f);
            return false;
        }
        return true;
    }

    public static int rotateDirections(int directions, float angle) {
        if (directions == 0) {
            return 0;
        }
        Vector2f vec = Vector2f.UNIT_Y.rotate(angle);
        int offset = 0;
        float minDist = Float.POSITIVE_INFINITY;
        for (int ii = 0; ii < 4; ++ii) {
            float dist = Direction.CARDINAL_VALUES[ii].getVector2f().distanceSquared(vec);
            if (!(dist < minDist)) continue;
            minDist = dist;
            offset = ii;
        }
        if (offset != 0) {
            return DirectionUtil.rotateCardinal(directions, offset);
        }
        return directions;
    }

    public static int rotateCardinal(int directions, int rotation) {
        int cardinal = directions & 0xF;
        int rotCardinal = (cardinal << rotation | cardinal >> 4 - rotation) & 0xF;
        directions = directions & 0xFFFFFFF0 | rotCardinal;
        return directions;
    }

    public static float normalize4Direction(float rotation) {
        if ((rotation = FloatMath.normalizeAnglePositive(rotation)) > 5.4977875f || rotation <= 0.7853982f) {
            rotation = 0.0f;
        } else if (rotation > 0.7853982f && rotation <= 2.3561945f) {
            rotation = 1.5707964f;
        } else if (rotation <= 3.926991f && rotation > 2.3561945f) {
            rotation = (float)Math.PI;
        } else if (rotation <= 5.4977875f && rotation > 3.926991f) {
            rotation = 4.712389f;
        }
        return rotation;
    }

    public static float normalize2Direction(float rotation) {
        rotation = (rotation = FloatMath.normalizeAnglePositive(rotation)) > 1.5707964f && rotation < 4.712389f ? (float)Math.PI : 0.0f;
        return rotation;
    }

    public static void main(String[] args) {
        System.out.println(DirectionUtil.rotateDirections(4, 1.5707964f));
    }
}

