/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.util;

import com.google.common.collect.Maps;
import com.samskivert.util.ObjectUtil;
import com.threerings.tudey.data.actor.Active;
import com.threerings.tudey.data.actor.Actor;
import com.threerings.tudey.util.ActorAdvancer;
import com.threerings.tudey.util.MobileAdvancer;
import java.util.Map;

public class ActiveAdvancer
extends MobileAdvancer {
    protected Activity _lastActivity;
    protected Active _active;
    protected Map<Long, Activity> _activities = Maps.newHashMap();

    public ActiveAdvancer(ActorAdvancer.Environment environment, Active active, int timestamp) {
        super(environment, active, timestamp);
    }

    public boolean canMove() {
        Activity activity = this.getActivity();
        return activity == null || activity.allowsMovement();
    }

    public boolean canRotate() {
        Activity activity = this.getActivity();
        return activity == null || activity.allowsRotation();
    }

    @Override
    public void init(Actor actor, int timestamp) {
        super.init(actor, timestamp);
        this._active = (Active)actor;
    }

    @Override
    protected void step(float elapsed) {
        Activity activity = this.getActivity();
        int activityStart = this._active.getActivityStarted();
        if (!ObjectUtil.equals((Object)activity, (Object)this._lastActivity)) {
            if (this._lastActivity != null) {
                this._lastActivity.stop(activity);
            }
            this._lastActivity = activity;
            if (activity != null) {
                activity.start(activityStart);
            }
        }
        if (activity != null) {
            activity.step(elapsed);
        }
        super.step(elapsed);
    }

    @Override
    public void afterAdvance(int timestamp) {
        Activity activity = this.getActivity();
        if (activity != null) {
            activity.afterStep();
        }
    }

    @Override
    protected void mobileStep(float elapsed, int timestamp) {
        if (!this.canMove()) {
            this._active.clear(2);
        }
        super.mobileStep(elapsed, timestamp);
    }

    protected Activity getActivity() {
        return this._activities.get(this._active.getActivity());
    }

    protected boolean canStart(int activity, long currentTimeMillis) {
        Activity act = this._activities.get(activity);
        if (act != null) {
            return act.canStart(currentTimeMillis);
        }
        return false;
    }

    protected class Activity {
        protected boolean _stopped = true;
        protected boolean _movement;
        protected boolean _rotation;
        protected int _clear;
        protected int _activityStart;
        protected long _id;

        public Activity(long id, int clear) {
            this(id, false, clear);
        }

        public Activity(long id, boolean movement, int clear) {
            this(id, movement, movement, clear);
        }

        public Activity(long id, boolean movement, boolean rotation, int clear) {
            this._id = id;
            this._movement = movement;
            this._rotation = rotation;
            this._clear = clear;
        }

        public boolean allowsMovement() {
            return this._movement;
        }

        public boolean allowsRotation() {
            return this._rotation;
        }

        public boolean canStart(long current) {
            return this._stopped;
        }

        public void start(int activityStart) {
            this._stopped = false;
            this._activityStart = activityStart;
        }

        protected void wasStopped(Activity next) {
        }

        protected void stop(Activity next) {
            if (!this._stopped) {
                this.wasStopped(next);
                this._stopped = true;
            }
        }

        public void step(float elapsed) {
        }

        public void afterStep() {
            int started = ActiveAdvancer.this._active.getActivityStarted();
            if (ActiveAdvancer.this._timestamp - started >= this._clear) {
                this.stop(null);
                this.cleared(started);
            } else if (!ActiveAdvancer.this.canMove()) {
                ActiveAdvancer.this._active.clear(2);
            }
        }

        public void cleared(int started) {
            ActiveAdvancer.this._active.setActivity(0L, started + this._clear);
        }

        public void updateInput() {
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Activity)) {
                return false;
            }
            return this._id == ((Activity)obj)._id;
        }

        public int hashCode() {
            return Long.hashCode(this._id);
        }

        public String toString() {
            return "[id=" + this._id + ",activityStart=" + this._activityStart + ",movement=" + this._movement + ",rotation=" + this._rotation + "]";
        }
    }
}

