/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.tools;

import com.samskivert.util.RandomUtil;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Image;
import com.threerings.opengl.gui.Label;
import com.threerings.opengl.gui.UserInterfaceWindow;
import com.threerings.opengl.gui.icon.Icon;
import com.threerings.opengl.gui.icon.ImageIcon;
import com.threerings.opengl.renderer.Texture;
import com.threerings.opengl.renderer.Texture2D;
import com.threerings.opengl.renderer.config.TextureConfig;
import com.threerings.opengl.util.Phaser;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.util.TudeyContext;
import com.threerings.util.MessageBundle;

public class LoadingWindow
extends UserInterfaceWindow {
    protected TudeyContext _ctx;
    protected TudeySceneView _view;
    protected MessageBundle _msgs;
    protected boolean _wasFirstTime;
    protected static boolean _firstTime = true;
    protected static final String DEFAULT_BACKGROUND = "default.jpg";
    protected static int _helpTipCount = -1;

    public static Icon createTipIcon(TudeyContext ctx, String file) {
        TextureConfig tconfig = ctx.getConfigManager().getConfig(TextureConfig.class, "2D/File/Default", "File", (Object)file, new Object[0]);
        Texture texture = tconfig.getTexture(ctx);
        if (texture instanceof Texture2D) {
            return new ImageIcon(new Image((Texture2D)texture));
        }
        return null;
    }

    public LoadingWindow(TudeyContext ctx, TudeySceneView view) {
        super(ctx, true, "ui/loading/interface.dat", "Background", "ui/loading/images/default.jpg", new Object[0]);
        this._ctx = ctx;
        this._msgs = ctx.getMessageManager().getBundle("helptips");
        this._view = view;
        this.setLayer(1);
        int loadingIdx = 0;
        this._wasFirstTime = _firstTime;
        if (_firstTime) {
            _firstTime = false;
        } else {
            loadingIdx = this.getTip();
        }
        ((Label)this.getComponent("tipheader")).setText(this._msgs.get("t.loading" + loadingIdx));
        ((Label)this.getComponent("tipbody")).setText(this._msgs.get("m.loading" + loadingIdx));
        String ikey = "i.loading" + loadingIdx;
        String image = this._msgs.exists(ikey) ? this._msgs.get(ikey) : "tip_exclamation.png";
        ((Label)this.getComponent("image")).setIcon(LoadingWindow.createTipIcon(ctx, "ui/tip/" + image));
    }

    protected int getTip() {
        if (_helpTipCount == -1) {
            _helpTipCount = 0;
            while (this._msgs.exists("t.loading" + _helpTipCount)) {
                ++_helpTipCount;
            }
        }
        return RandomUtil.getInt((int)_helpTipCount);
    }

    public void update(float pct) {
        if (pct == 1.0f) {
            this.fadeOut();
        } else {
            ((Label)this.getComponent("progress")).setText(this._msgs.get("m.loading", new String[]{String.valueOf(Math.round(pct * 100.0f))}));
        }
    }

    protected void fadeOut() {
        Label progress = (Label)this.getComponent("progress");
        progress.setText("");
        final Label title = (Label)this.getComponent("title");
        final Label subtitle = (Label)this.getComponent("subtitle");
        this._ctx.getApp().getStreamGain().value = 0.0f;
        if (this._wasFirstTime) {
            this._ctx.getRoot().moveToTop(this);
        }
        this._ctx.getRoot().addTickParticipant(new Phaser(new Object[]{"fadeBackground", Float.valueOf(3.0f), "linger", Float.valueOf(1.0f), "fadeTitle", Float.valueOf(1.0f)}){
            protected boolean _calledFadedIn;

            @Override
            public void tick(float elapsed) {
                this.completed();
            }

            protected void fadeBackground() {
                LoadingWindow.this.setAlpha(this._cpct);
                title.setAlpha(1.0f);
                subtitle.setAlpha(1.0f);
                LoadingWindow.this._ctx.getApp().getStreamGain().value = 1.0f * this._pct;
            }

            protected void linger() {
                if (!this._calledFadedIn) {
                    LoadingWindow.this.fadedIn();
                    this._calledFadedIn = true;
                }
            }

            protected void fadeTitle() {
                title.setAlpha(this._cpct);
                subtitle.setAlpha(this._cpct);
            }

            @Override
            protected void completed() {
                LoadingWindow.this._ctx.getRoot().removeWindow(LoadingWindow.this);
                LoadingWindow.this._ctx.getRoot().removeTickParticipant(this);
                LoadingWindow.this._ctx.getApp().getStreamGain().value = 1.0f;
            }
        });
    }

    @Override
    public Component getHitComponent(int mx, int my) {
        return this._alpha == 1.0f ? super.getHitComponent(mx, my) : null;
    }

    protected void fadedIn() {
    }

    @Override
    protected void wasAdded() {
        super.wasAdded();
    }

    @Override
    protected void wasRemoved() {
        super.wasRemoved();
    }
}

