/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.tools;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.inject.internal.Lists;
import com.samskivert.util.ArrayUtil;
import com.threerings.config.ConfigReference;
import com.threerings.editor.Editable;
import com.threerings.math.FloatMath;
import com.threerings.math.Vector3f;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.scene.SceneElement;
import com.threerings.tudey.client.sprite.GraphSprite;
import com.threerings.tudey.config.GraphConfig;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.tools.ConfigTool;
import com.threerings.tudey.tools.SceneEditor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class GraphDefiner
extends ConfigTool<GraphConfig> {
    private static final long serialVersionUID = 1L;
    protected TudeySceneModel.GraphEntry _entry;
    protected int _idx;
    protected TudeySceneModel.Edge _edge;
    protected Vector3f _isect = new Vector3f();
    protected final Predicate<SceneElement> Graph_FILTER = new Predicate<SceneElement>(){

        public boolean apply(SceneElement element) {
            Object obj = element.getUserObject();
            if (obj instanceof GraphSprite) {
                int idx = ((GraphSprite)obj).getVertexIndex((Model)element);
                if (idx != -1) {
                    if (GraphDefiner.this._edge != null) {
                        for (TudeySceneModel.Edge edge : GraphDefiner.this._entry.edges) {
                            if (edge.start != GraphDefiner.this._edge.start && edge.end != GraphDefiner.this._edge.start && edge.end != GraphDefiner.this._edge.start && edge.end != GraphDefiner.this._edge.end || idx != edge.end && idx != edge.start) continue;
                            return false;
                        }
                    }
                    if (GraphDefiner.this._idx >= 0 && idx == GraphDefiner.this._idx) {
                        return false;
                    }
                } else {
                    idx = ((GraphSprite)obj).getEdgeIndex((Model)element);
                    if (idx != -1) {
                        TudeySceneModel.Edge edge = GraphDefiner.this._entry.edges[idx];
                        if (edge.start == GraphDefiner.this._idx || edge.end == GraphDefiner.this._idx) {
                            return false;
                        }
                    }
                }
                return GraphDefiner.this._editor.getLayerPredicate().apply((Object)((GraphSprite)obj).getEntry());
            }
            return false;
        }
    };

    public GraphDefiner(SceneEditor editor) {
        super(editor, GraphConfig.class, new GraphReference());
    }

    @Override
    public void deactivate() {
        super.deactivate();
        if (this._entry != null) {
            this.release(this._entry);
        }
    }

    @Override
    public void sceneChanged(TudeySceneModel scene) {
        super.sceneChanged(scene);
        this._entry = null;
        this._idx = -1;
        this._edge = null;
        for (TudeySceneModel.Entry entry : scene.getEntries()) {
            if (!(entry instanceof TudeySceneModel.GraphEntry)) continue;
            this._entry = (TudeySceneModel.GraphEntry)entry;
            break;
        }
        if (this._entry == null) {
            this._entry = new TudeySceneModel.GraphEntry();
            scene.addEntry(this._entry);
        }
    }

    @Override
    public void entryUpdated(TudeySceneModel.Entry oentry, TudeySceneModel.Entry nentry) {
        if (this._entry != null && this._entry.getKey().equals(oentry.getKey()) && this._entry != nentry) {
            this._entry = (TudeySceneModel.GraphEntry)nentry;
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this._editor.isSpecialDown()) {
            return;
        }
        int button = event.getButton();
        if (this._editor.getMouseRay(this._pick)) {
            if (button == 1) {
                Model model = (Model)this._editor.getView().getScene().getIntersection(this._pick, this._isect, this.Graph_FILTER);
                TudeySceneModel.GraphEntry entry = (TudeySceneModel.GraphEntry)this._entry.clone();
                if (model != null) {
                    GraphSprite sprite = (GraphSprite)model.getUserObject();
                    int idx = sprite.getVertexIndex(model);
                    if (idx != -1) {
                        if (this._idx != -1) {
                            ArrayList oneLevelNeighbor = Lists.newArrayList();
                            ArrayList twoLevelNeighbor = Lists.newArrayList();
                            for (TudeySceneModel.Edge edge : entry.edges) {
                                if (edge.end == this._idx) {
                                    oneLevelNeighbor.add(edge.start);
                                }
                                if (edge.start != this._idx) continue;
                                oneLevelNeighbor.add(edge.end);
                            }
                            for (TudeySceneModel.Edge edge : entry.edges) {
                                if (oneLevelNeighbor.contains(edge.start)) {
                                    twoLevelNeighbor.add(edge.end);
                                }
                                if (!oneLevelNeighbor.contains(edge.end)) continue;
                                twoLevelNeighbor.add(edge.start);
                            }
                            if (oneLevelNeighbor.contains(idx) || twoLevelNeighbor.contains(idx)) {
                                return;
                            }
                            System.out.println("idx=" + idx);
                            for (TudeySceneModel.Edge edge : entry.edges) {
                                if (edge.end == this._idx) {
                                    edge.end = idx;
                                }
                                if (edge.start != this._idx) continue;
                                edge.start = idx;
                            }
                            this._edge = this.insertEdge(entry, idx, this._idx);
                            this._editor.updateEntries(entry);
                        } else {
                            this._idx = idx;
                        }
                        return;
                    }
                    idx = sprite.getEdgeIndex(model);
                    TudeySceneModel.Edge edge = entry.edges[idx];
                    if (this._idx != -1) {
                        this.setMouseLocation(this._entry.vertices[this._idx]);
                        int newIdx = entry.vertices.length;
                        int newStart = edge.start;
                        edge.start = this._idx;
                        this.insertEdge(entry, newStart, this._idx);
                        this.insertVertex(entry, newIdx);
                        this._edge = this.insertEdge(entry, this._idx, newIdx);
                        this._idx = newIdx;
                    } else {
                        int one = entry.vertices.length;
                        int newEnd = edge.end;
                        this.insertVertex(entry, one);
                        edge.end = one;
                        this.insertEdge(entry, one, newEnd);
                        int two = entry.vertices.length;
                        this.insertVertex(entry, two);
                        this._edge = this.insertEdge(entry, one, two);
                        this._idx = two;
                    }
                    this._editor.updateEntries(entry);
                    return;
                }
                if (this._idx == -1) {
                    int newIdx = entry.vertices.length;
                    this.insertVertex(entry, newIdx);
                    this.insertVertex(entry, newIdx + 1);
                    this._edge = this.insertEdge(entry, newIdx, newIdx + 1);
                    this._idx = newIdx + 1;
                    this._editor.updateEntries(entry);
                } else {
                    int newIdx = entry.vertices.length;
                    this.insertVertex(entry, newIdx);
                    this._edge = this.insertEdge(entry, this._idx, newIdx);
                    this._idx = newIdx;
                    this._editor.updateEntries(entry);
                }
                return;
            }
            if (button == 3) {
                TudeySceneModel.GraphEntry entry = (TudeySceneModel.GraphEntry)this._entry.clone();
                if (this._idx != -1) {
                    this.release(entry);
                } else {
                    Model model = (Model)this._editor.getView().getScene().getIntersection(this._pick, this._isect, this.Graph_FILTER);
                    if (model != null) {
                        GraphSprite sprite = (GraphSprite)model.getUserObject();
                        int idx = sprite.getVertexIndex(model);
                        if (idx != -1) {
                            this.removeVertices(entry, idx);
                        } else {
                            idx = sprite.getEdgeIndex(model);
                            TudeySceneModel.Edge edge = entry.edges[idx];
                            this.removeEdge(entry, edge);
                        }
                        this._editor.updateEntries(entry);
                    }
                    this._edge = null;
                    this._idx = -1;
                }
            } else if (button == 2) {
                Model model = (Model)this._editor.getView().getScene().getIntersection(this._pick, this._isect, this.Graph_FILTER);
                if (model != null) {
                    GraphSprite sprite = (GraphSprite)model.getUserObject();
                    int idx = sprite.getVertexIndex(model);
                    if (this._idx == -1) {
                        if (idx != -1) {
                            this._idx = idx;
                        }
                    } else if (idx == -1) {
                        this.setMouseLocation(this._entry.vertices[this._idx]);
                        this._idx = -1;
                    }
                } else if (this._idx != -1) {
                    this.setMouseLocation(this._entry.vertices[this._idx]);
                    this._idx = -1;
                }
            }
        }
    }

    @Override
    public void tick(float elapsed) {
        if (this._entry == null || !this.getMousePlaneIntersection(this._isect) || this._editor.isSpecialDown()) {
            return;
        }
        if (this._entry.vertices.length == 0) {
            return;
        }
        if (this._idx != -1) {
            this.setMouseLocation(this._entry.vertices[this._idx]);
            this._editor.updateEntries(this._entry);
        }
    }

    protected void setMouseLocation(TudeySceneModel.Vertex vertex) {
        if (!this._editor.isShiftDown()) {
            this._isect.x = FloatMath.floor(this._isect.x) + 0.5f;
            this._isect.y = FloatMath.floor(this._isect.y) + 0.5f;
        }
        float z = Math.max(this._editor.getGrid().getZ(), 10.0f);
        z = Math.min(z, -10.0f);
        vertex.set(this._isect.x, this._isect.y, this._editor.getGrid().getZ());
    }

    protected void release(TudeySceneModel.GraphEntry entry) {
        if (this._idx != -1) {
            this.removeVertices(entry, this._idx);
            this._idx = -1;
            this._edge = null;
            this._editor.updateEntries(entry);
        }
    }

    protected void insertVertex(TudeySceneModel.GraphEntry entry, int idx) {
        if (this._editor.getGrid().getZ() > 50.0f || this._editor.getGrid().getZ() < -50.0f) {
            return;
        }
        TudeySceneModel.Vertex vertex = new TudeySceneModel.Vertex();
        this.setMouseLocation(vertex);
        entry.vertices = (TudeySceneModel.Vertex[])ArrayUtil.insert((Object[])entry.vertices, (Object)vertex, (int)idx);
        System.out.println("insert Vertex=" + vertex + ",idx=" + idx);
        for (TudeySceneModel.Edge edge : entry.edges) {
            if (edge.start >= idx) {
                ++edge.start;
            }
            if (edge.end < idx) continue;
            ++edge.end;
        }
    }

    protected TudeySceneModel.Edge insertEdge(TudeySceneModel.GraphEntry entry, int start, int end) {
        TudeySceneModel.Edge edge = new TudeySceneModel.Edge();
        edge.set(start, end);
        entry.edges = (TudeySceneModel.Edge[])ArrayUtil.append((Object[])entry.edges, (Object)edge);
        return edge;
    }

    protected void removeVertices(TudeySceneModel.GraphEntry nentry, int idx) {
        HashMap checked = Maps.newHashMap();
        ArrayList list = Lists.newArrayList();
        for (TudeySceneModel.Edge edge : nentry.edges) {
            if (edge.end != idx && edge.start != idx) {
                list.add(edge);
                AtomicInteger counter = (AtomicInteger)checked.get(edge.start);
                if (counter == null) {
                    counter = new AtomicInteger(1);
                    checked.put(edge.start, counter);
                } else {
                    counter.incrementAndGet();
                }
                counter = (AtomicInteger)checked.get(edge.end);
                if (counter == null) {
                    counter = new AtomicInteger(1);
                    checked.put(edge.end, counter);
                    continue;
                }
                counter.incrementAndGet();
                continue;
            }
            if (edge.end != idx && edge.start != idx) continue;
            Integer key = edge.start == idx ? edge.end : edge.start;
            AtomicInteger counter = (AtomicInteger)checked.get(key);
            if (counter == null) {
                counter = new AtomicInteger(0);
                checked.put(key, counter);
                continue;
            }
            counter.incrementAndGet();
        }
        nentry.edges = list.toArray(new TudeySceneModel.Edge[list.size()]);
        ArrayList vertics = Lists.newArrayList();
        for (int i = nentry.vertices.length - 1; i >= 0; --i) {
            AtomicInteger counter = (AtomicInteger)checked.get(i);
            if (counter != null && counter.get() > 0 && i != idx) {
                vertics.add(nentry.vertices[i]);
                continue;
            }
            for (TudeySceneModel.Edge edge : nentry.edges) {
                if (edge.start > i) {
                    --edge.start;
                }
                if (edge.end <= i) continue;
                --edge.end;
            }
        }
        nentry.vertices = vertics.toArray(new TudeySceneModel.Vertex[vertics.size()]);
        ArrayUtil.reverse((Object[])nentry.vertices);
    }

    protected void removeEdge(TudeySceneModel.GraphEntry nentry, TudeySceneModel.Edge removed) {
        int start = 0;
        int end = 0;
        TudeySceneModel.Edge[] edges = new TudeySceneModel.Edge[nentry.edges.length - 1];
        int idx = 0;
        for (TudeySceneModel.Edge edge : nentry.edges) {
            if (edge == removed) continue;
            edges[idx++] = edge;
            if (edge.end == removed.end || edge.start == removed.end) {
                ++end;
            }
            if (edge.start != removed.start && edge.end != removed.start) continue;
            ++start;
        }
        nentry.edges = edges;
        if (removed.start > removed.end) {
            if (start == 0) {
                this.removeVertices(nentry, removed.start);
            }
            if (end == 0) {
                this.removeVertices(nentry, removed.end);
            }
        } else {
            if (end == 0) {
                this.removeVertices(nentry, removed.end);
            }
            if (start == 0) {
                this.removeVertices(nentry, removed.start);
            }
        }
    }

    protected static class GraphReference
    extends ConfigTool.EditableReference<GraphConfig> {
        @Editable(nullable=true)
        public ConfigReference<GraphConfig> path;

        protected GraphReference() {
        }

        @Override
        public ConfigReference<GraphConfig> getReference() {
            return this.path;
        }

        @Override
        public void setReference(ConfigReference<GraphConfig> ref) {
            this.path = ref;
        }
    }
}

