/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.tools;

import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.VGroupLayout;
import com.threerings.config.ConfigReference;
import com.threerings.config.ManagedConfig;
import com.threerings.config.swing.ConfigTree;
import com.threerings.config.swing.ConfigTreeFilterPanel;
import com.threerings.config.swing.ConfigTreeNode;
import com.threerings.config.swing.RecentConfigList;
import com.threerings.editor.swing.EditorPanel;
import com.threerings.export.Exportable;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.tools.EditorTool;
import com.threerings.tudey.tools.SceneEditor;
import com.threerings.util.DeepObject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public abstract class ConfigTool<T extends ManagedConfig>
extends EditorTool
implements TreeSelectionListener,
ChangeListener {
    protected Class<T> _clazz;
    protected RecentConfigList _recentConfigs;
    protected EditableReference<T> _eref;
    protected JScrollPane _pane;
    protected ConfigTree _tree;
    protected ConfigTreeFilterPanel _filterPanel;
    protected EditorPanel _epanel;

    public ConfigTool(SceneEditor editor, Class<T> clazz, EditableReference<T> eref) {
        super(editor);
        this._clazz = clazz;
        this._eref = eref;
        this._recentConfigs = new RecentConfigList(this.getClass().getSimpleName());
        this._recentConfigs.addObserver(new RecentConfigList.Observer(){

            @Override
            public void configSelected(ConfigReference<?> ref) {
                ConfigReference<?> casted = ref;
                ConfigTool.this.setReference(casted);
            }
        });
        JPanel panel = new JPanel((LayoutManager)new VGroupLayout(GroupLayout.STRETCH, GroupLayout.STRETCH, 5, GroupLayout.TOP));
        JSplitPane recentSplit = new JSplitPane(0, true, this._recentConfigs, panel);
        this.add(recentSplit);
        this._filterPanel = new ConfigTreeFilterPanel(editor.getMessageManager());
        panel.add((Component)this._filterPanel, GroupLayout.FIXED);
        this._pane = new JScrollPane();
        this._epanel = new EditorPanel(editor);
        JSplitPane split = new JSplitPane(0, true, this._pane, (Component)((Object)this._epanel));
        split.setResizeWeight(1.0);
        panel.add(split);
        this._epanel.setMinimumSize(new Dimension(120, 120));
        this._epanel.setObject(eref);
        this._epanel.addChangeListener(this);
    }

    public void addAsRecent(ConfigReference<?> ref) {
        if (ref != null) {
            this._recentConfigs.addRecent(ref);
        }
    }

    public void setReference(ConfigReference<T> ref) {
        this._tree.setSelectedNode(ref == null ? null : ref.getName());
        this._eref.setReference(ref);
        this._epanel.update();
        this.referenceChanged(ref);
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        ConfigTreeNode node = this._tree.getSelectedNode();
        String name = node == null || node.getConfig() == null ? null : node.getName();
        ConfigReference ref = name == null ? null : new ConfigReference(name);
        this._eref.setReference(ref);
        this._epanel.update();
        this.referenceChanged(ref);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        ConfigReference<T> ref = this._eref.getReference();
        this._tree.setSelectedNode(ref == null ? null : ref.getName());
        this.referenceChanged(ref);
    }

    @Override
    public void sceneChanged(TudeySceneModel scene) {
        super.sceneChanged(scene);
        if (this._tree != null) {
            this._tree.dispose();
        }
        this._tree = new ConfigTree(scene.getConfigManager().getGroups(this._clazz), true);
        this._pane.setViewportView(this._tree);
        this._tree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._tree.addTreeSelectionListener(this);
        this._filterPanel.setTree(this._tree);
    }

    protected void referenceChanged(ConfigReference<T> ref) {
        this.addAsRecent(ref);
    }

    protected static abstract class EditableReference<T extends ManagedConfig>
    extends DeepObject
    implements Exportable {
        protected EditableReference() {
        }

        public abstract ConfigReference<T> getReference();

        public abstract void setReference(ConfigReference<T> var1);
    }
}

