/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.shape;

import com.threerings.math.FloatMath;
import com.threerings.math.Ray2D;
import com.threerings.math.Rect;
import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;
import com.threerings.tudey.shape.Capsule;
import com.threerings.tudey.shape.Circle;
import com.threerings.tudey.shape.Compound;
import com.threerings.tudey.shape.Point;
import com.threerings.tudey.shape.Polygon;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.shape.config.ShapeConfig;
import com.threerings.tudey.space.SpaceElement;
import org.lwjgl.opengl.GL11;

public class Segment
extends Shape {
    protected Vector2f _start = new Vector2f();
    protected Vector2f _end = new Vector2f();

    public Segment(Vector2f start, Vector2f end) {
        this._start.set(start);
        this._end.set(end);
        this.updateBounds();
    }

    public Segment() {
    }

    public Vector2f getStart() {
        return this._start;
    }

    public Vector2f getEnd() {
        return this._end;
    }

    @Override
    public boolean contains(float x, float y) {
        return this.contains(new Vector2f(x, y));
    }

    @Override
    public boolean contains(Vector2f pt) {
        return this.intersects(pt);
    }

    public boolean intersects(Vector2f pt) {
        return Segment.intersects(this._start, this._end, pt);
    }

    public boolean intersects(Vector2f ostart, Vector2f oend) {
        float ax = this._start.x;
        float ay = this._start.y;
        float bx = this._end.x - this._start.x;
        float by = this._end.y - this._start.y;
        float cx = ostart.x;
        float cy = ostart.y;
        float dy = oend.y - ostart.y;
        float dx = oend.x - ostart.x;
        float divisor = bx * dy - by * dx;
        if (Math.abs(divisor) < 1.0E-6f) {
            return this.intersects(ostart) || this.intersects(oend) || Segment.intersects(ostart, oend, this._start);
        }
        float cxax = cx - ax;
        float cyay = cy - ay;
        float s = (by * cxax - bx * cyay) / divisor;
        if (s < 0.0f || s > 1.0f) {
            return false;
        }
        float t = (dy * cxax - dx * cyay) / divisor;
        return t >= 0.0f && t <= 1.0f;
    }

    @Override
    public void updateBounds() {
        this._bounds.setToEmpty();
        this._bounds.addLocal(this._start);
        this._bounds.addLocal(this._end);
    }

    @Override
    public Vector2f getCenter(Vector2f result) {
        return this._start.add(this._end, result).multLocal(0.5f);
    }

    @Override
    public Shape transform(Transform2D transform, Shape result) {
        Segment sresult = result instanceof Segment ? (Segment)result : new Segment();
        transform.transformPoint(this._start, sresult._start);
        transform.transformPoint(this._end, sresult._end);
        sresult.updateBounds();
        return sresult;
    }

    @Override
    public Shape expand(float amount, Shape result) {
        Capsule cresult = result instanceof Capsule ? (Capsule)result : new Capsule();
        cresult.getStart().set(this._start);
        cresult.getEnd().set(this._end);
        cresult.radius = amount;
        cresult.updateBounds();
        return cresult;
    }

    @Override
    public Shape sweep(Vector2f translation, Shape result) {
        float cp;
        Polygon presult;
        Polygon polygon = presult = result instanceof Polygon ? (Polygon)result : new Polygon(4);
        if (presult.getVertexCount() != 4) {
            presult.initVertices(4);
        }
        if ((cp = (this._end.x - this._start.x) * translation.y - (this._end.y - this._start.y) * translation.x) >= 0.0f) {
            presult.getVertex(0).set(this._start);
            presult.getVertex(1).set(this._end);
            this._end.add(translation, presult.getVertex(2));
            this._start.add(translation, presult.getVertex(3));
        } else {
            this._start.add(translation, presult.getVertex(0));
            this._end.add(translation, presult.getVertex(1));
            presult.getVertex(2).set(this._end);
            presult.getVertex(3).set(this._start);
        }
        presult.updateBounds();
        return presult;
    }

    @Override
    public Vector2f[] getPerimeterPath() {
        return new Vector2f[]{new Vector2f(this._start), new Vector2f(this._end)};
    }

    @Override
    public boolean getIntersection(Ray2D ray, Vector2f result) {
        return ray.getIntersection(this._start, this._end, result);
    }

    @Override
    public void getNearestPoint(Vector2f point, Vector2f result) {
        Segment.nearestPointOnSegment(this._start, this._end, point, result);
    }

    @Override
    public Shape.IntersectionType getIntersectionType(Rect rect) {
        if (rect.contains(this._start) || rect.contains(this._end)) {
            return Shape.IntersectionType.INTERSECTS;
        }
        float dx = this._end.x - this._start.x;
        float dy = this._end.y - this._start.y;
        Vector2f min = rect.getMinimumExtent();
        Vector2f max = rect.getMaximumExtent();
        return Math.abs(dx) > 1.0E-6f && (this.intersectsX(rect, min.x, dx, dy) || this.intersectsX(rect, max.x, dx, dy)) || Math.abs(dy) > 1.0E-6f && (this.intersectsY(rect, min.y, dx, dy) || this.intersectsY(rect, max.y, dx, dy)) ? Shape.IntersectionType.INTERSECTS : Shape.IntersectionType.NONE;
    }

    @Override
    public boolean intersects(SpaceElement element) {
        return element.intersects(this);
    }

    @Override
    public boolean intersects(Shape shape) {
        return shape.intersects(this);
    }

    @Override
    public boolean intersects(Point point) {
        return this.intersects(point.getLocation());
    }

    @Override
    public boolean intersects(Segment segment) {
        return this.intersects(segment.getStart(), segment.getEnd());
    }

    @Override
    public boolean intersects(Circle circle) {
        return circle.intersects(this);
    }

    @Override
    public boolean intersects(Capsule capsule) {
        return capsule.intersects(this);
    }

    @Override
    public boolean intersects(Polygon polygon) {
        return polygon.intersects(this);
    }

    @Override
    public boolean intersects(Compound compound) {
        return compound.intersects(this);
    }

    @Override
    public Vector2f getPenetration(Shape shape, Vector2f result) {
        return shape.getPenetration(this, result).negateLocal();
    }

    @Override
    public Vector2f getPenetration(Point point, Vector2f result) {
        return result.set(Vector2f.ZERO);
    }

    @Override
    public Vector2f getPenetration(Segment segment, Vector2f result) {
        return result.set(Vector2f.ZERO);
    }

    @Override
    public Vector2f getPenetration(Circle circle, Vector2f result) {
        Vector2f center = circle.getCenter();
        Vector2f D = center.subtract(this._start);
        Vector2f axis = this._end.subtract(this._start);
        float d = D.dot(axis);
        d = FloatMath.clamp(d, 0.0f, 1.0f);
        this._start.add(axis.multLocal(d), D);
        float dist = center.distance(D);
        return dist == 0.0f ? result.set(Vector2f.ZERO) : center.subtract(D, result).multLocal(circle.radius / dist - 1.0f);
    }

    @Override
    public Vector2f getPenetration(Capsule capsule, Vector2f result) {
        return capsule.getPenetration(this, result).negateLocal();
    }

    @Override
    public Vector2f getPenetration(Polygon polygon, Vector2f result) {
        return polygon.getPenetration(this, result).negateLocal();
    }

    @Override
    public Vector2f getPenetration(Compound compound, Vector2f result) {
        return compound.getPenetration(this, result).negateLocal();
    }

    @Override
    public void draw(boolean outline) {
        GL11.glBegin((int)1);
        GL11.glVertex2f((float)this._start.x, (float)this._start.y);
        GL11.glVertex2f((float)this._end.x, (float)this._end.y);
        GL11.glEnd();
    }

    @Override
    public ShapeConfig createConfig() {
        ShapeConfig.Segment segment = new ShapeConfig.Segment();
        segment.length = this._start.distance(this._end);
        ShapeConfig.TransformedShape transformed = new ShapeConfig.TransformedShape();
        transformed.shape = segment;
        transformed.transform.set(this._start.add(this._end).multLocal(0.5f), this._start.direction(this._end));
        ShapeConfig.Compound compound = new ShapeConfig.Compound();
        compound.shapes = new ShapeConfig.TransformedShape[]{transformed};
        return compound;
    }

    public String toString() {
        return "Seg:(" + this._start + ", " + this._end + ")";
    }

    protected boolean intersectsX(Rect rect, float x, float dx, float dy) {
        float t = (x - this._start.x) / dx;
        if (t < 0.0f || t > 1.0f) {
            return false;
        }
        float iy = this._start.y + t * dy;
        return iy >= rect.getMinimumExtent().y && iy <= rect.getMaximumExtent().y;
    }

    protected boolean intersectsY(Rect rect, float y, float dx, float dy) {
        float t = (y - this._start.y) / dy;
        if (t < 0.0f || t > 1.0f) {
            return false;
        }
        float ix = this._start.x + t * dx;
        return ix >= rect.getMinimumExtent().x && ix <= rect.getMaximumExtent().x;
    }

    protected float getIntersection(Vector2f pt) {
        float dx = this._end.x - this._start.x;
        float dy = this._end.y - this._start.y;
        if (dx == 0.0f && dy == 0.0f) {
            return this._start.equals(pt) ? 0.0f : Float.MAX_VALUE;
        }
        if (Math.abs(dx) > Math.abs(dy)) {
            float t = (pt.x - this._start.x) / dx;
            return t >= 0.0f && t <= 1.0f && this._start.y + t * dy == pt.y ? t : Float.MAX_VALUE;
        }
        float t = (pt.y - this._start.y) / dy;
        return t >= 0.0f && t <= 1.0f && this._start.x + t * dx == pt.x ? t : Float.MAX_VALUE;
    }

    protected static boolean intersects(Vector2f start, Vector2f end, Vector2f pt) {
        float dx = end.x - start.x;
        float dy = end.y - start.y;
        if (dx == 0.0f && dy == 0.0f) {
            return start.equals(pt);
        }
        if (Math.abs(dx) > Math.abs(dy)) {
            float t = (pt.x - start.x) / dx;
            return t >= 0.0f && t <= 1.0f && start.y + t * dy == pt.y;
        }
        float t = (pt.y - start.y) / dy;
        return t >= 0.0f && t <= 1.0f && start.x + t * dx == pt.x;
    }
}

