/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.shape;

import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;
import com.threerings.tudey.shape.Polygon;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.util.Coord;

public class CoordShape
extends Polygon {
    public Coord _coord = new Coord();
    protected Transform2D _transform = new Transform2D();

    public CoordShape() {
        super(new Vector2f[0]);
    }

    public CoordShape(Coord coord) {
        super(new Vector2f[0]);
        this.setCoord(coord.x, coord.y);
    }

    public CoordShape(int x, int y) {
        super(new Vector2f[0]);
        this.setCoord(x, y);
    }

    @Override
    public Shape transform(Transform2D transform, Shape result) {
        this._transform.set(transform);
        this._transform.set(this._transform.getTranslation().adjustCenter(), this._transform.getRotation());
        Vector2f center = new Vector2f(this._coord.x, this._coord.y);
        CoordShape cresult = result instanceof CoordShape ? (CoordShape)result : new CoordShape();
        Vector2f nc = this.toTransform(transform).transformPoint(center);
        cresult.setCoord(Math.round(nc.x), Math.round(nc.y));
        return cresult;
    }

    protected Transform2D toTransform(Transform2D transform) {
        if (transform.getType() == 0) {
            return transform;
        }
        Vector2f v = transform.getTranslation();
        Transform2D coordTransform = new Transform2D(new Vector2f(Math.round(v.x), Math.round(v.y)), transform.getRotation());
        return coordTransform;
    }

    @Override
    public boolean intersects(Polygon polygon) {
        if (polygon instanceof CoordShape) {
            return ((CoordShape)polygon)._coord.x == this._coord.x && ((CoordShape)polygon)._coord.y == this._coord.y;
        }
        return super.intersects(polygon);
    }

    public void setCoord(int x, int y) {
        this._coord.set(x, y);
        if (this._vertices == null || this._vertices.length == 0) {
            this._vertices = new Vector2f[]{new Vector2f(), new Vector2f(), new Vector2f(), new Vector2f()};
        }
        float deta = -0.5f;
        this._vertices[0].set((float)x - 0.5f + deta, (float)y - 0.5f + deta);
        this._vertices[1].set((float)x + 0.5f + deta, (float)y - 0.5f + deta);
        this._vertices[2].set((float)x + 0.5f + deta, (float)y + 0.5f + deta);
        this._vertices[3].set((float)x - 0.5f + deta, (float)y + 0.5f + deta);
        this.updateBounds();
        System.out.println("<<<--------------------");
        System.out.println(this);
        System.out.println("<<<-------------------->>>");
    }

    public Coord getCoord() {
        return this._coord;
    }
}

