/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.samskivert.util.IntMap;
import com.samskivert.util.IntMaps;
import com.threerings.config.ConfigManager;
import com.threerings.math.FloatMath;
import com.threerings.math.Rect;
import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;
import com.threerings.media.util.AStarPathUtil;
import com.threerings.media.util.MathUtil;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.tudey.Log;
import com.threerings.tudey.config.TileConfig;
import com.threerings.tudey.data.IntPair;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.data.actor.Actor;
import com.threerings.tudey.server.TudeySceneManager;
import com.threerings.tudey.server.logic.ActorLogic;
import com.threerings.tudey.server.logic.Logic;
import com.threerings.tudey.server.util.TraversalCostCaculator;
import com.threerings.tudey.shape.Polygon;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.space.Space;
import com.threerings.tudey.space.SpaceElement;
import com.threerings.tudey.util.Coord;
import com.threerings.tudey.util.CoordIntArray;
import java.awt.Point;
import java.util.List;

public class Pathfinder
implements TudeySceneModel.Observer,
TudeySceneManager.ActorObserver,
Logic.ShapeObserver,
ActorLogic.CollisionFlagObserver,
TraversalCostCaculator {
    public boolean debug = false;
    protected CoordIntArray _actorFlags = new CoordIntArray(128, 0);
    protected TudeySceneManager _scenemgr;
    protected CoordIntArray _entryFlags = new CoordIntArray(128, 0);
    protected IntMap<List<IntPair>> _actorTraversalCosts = IntMaps.newHashIntMap();
    protected IntMap<List<Integer>> _actorFlagLists = IntMaps.newHashIntMap();
    protected Polygon _quad = new Polygon(4);
    protected List<SpaceElement> _elements = Lists.newArrayList();
    protected List<Vector2f> _waypoints = Lists.newArrayList();
    protected Rectangle _region = new Rectangle();
    protected Transform2D _transform = new Transform2D();
    protected Shape _worldShape;
    protected Vector2f _translation = new Vector2f();
    protected Vector2f _nearest = new Vector2f();
    protected Shape _sweptShape;
    protected static final int SUBDIVISION = 2;

    public Pathfinder(TudeySceneManager scenemgr) {
        this._scenemgr = scenemgr;
        TudeySceneModel model = (TudeySceneModel)this._scenemgr.getScene().getSceneModel();
        for (TudeySceneModel.Entry entry : model.getEntries()) {
            try {
                this.addFlags(entry);
            }
            catch (Exception e) {
                Log.log.warning((Object)"add entry error", new Object[]{e});
            }
        }
        model.addObserver(this);
        this._scenemgr.addActorObserver(this);
    }

    public void shutdown() {
        ((TudeySceneModel)this._scenemgr.getScene().getSceneModel()).removeObserver(this);
        this._scenemgr.removeActorObserver(this);
    }

    public Vector2f[] getEntryPath(ActorLogic actor, float longest, float bx, float by, boolean partial, boolean shortcut) {
        Vector2f translation = actor.getTranslation();
        return this.getEntryPath(actor, longest, translation.x, translation.y, bx, by, partial, shortcut);
    }

    public Vector2f[] getEntryPath(ActorLogic actor, float longest, float ax, float ay, float bx, float by, boolean partial, boolean shortcut) {
        Vector2f[] path = this.getPath(false, actor, longest, ax, ay, bx, by, partial, shortcut);
        this._scenemgr.debugPath(path);
        return path;
    }

    public Vector2f[] getPath(ActorLogic actor, float longest, float bx, float by, boolean partial, boolean shortcut) {
        Vector2f translation = actor.getTranslation();
        return this.getPath(actor, longest, translation.x, translation.y, bx, by, partial, shortcut);
    }

    public Vector2f[] getPath(ActorLogic actor, float longest, float ax, float ay, float bx, float by, boolean partial, boolean shortcut) {
        Vector2f[] path = this.getPath(true, actor, longest, ax, ay, bx, by, partial, shortcut);
        return path;
    }

    @Override
    public void entryAdded(TudeySceneModel.Entry entry) {
        this.addFlags(entry);
    }

    @Override
    public void entryUpdated(TudeySceneModel.Entry oentry, TudeySceneModel.Entry nentry) {
        this.removeFlags(oentry);
        this.addFlags(nentry);
    }

    @Override
    public void entryRemoved(TudeySceneModel.Entry oentry) {
        this.removeFlags(oentry);
    }

    @Override
    public void actorAdded(ActorLogic logic) {
        this.addFlags(logic);
        logic.addShapeObserver(this);
        logic.addCollisionFlagObserver(this);
    }

    @Override
    public void actorRemoved(ActorLogic logic) {
        this.removeFlags(logic);
        logic.removeShapeObserver(this);
        logic.removeCollisionFlagObserver(this);
    }

    @Override
    public void shapeWillChange(Logic logic) {
        this.removeFlags((ActorLogic)logic);
    }

    @Override
    public void shapeDidChange(Logic logic) {
        this.addFlags((ActorLogic)logic);
    }

    @Override
    public void collisionFlagsChanged(ActorLogic logic, int oflags) {
        int nflags = logic.getCollisionFlags();
        Shape shape = logic.getShape();
        Rect bounds = shape.getBounds();
        Vector2f min = bounds.getMinimumExtent();
        Vector2f max = bounds.getMaximumExtent();
        int minx = FloatMath.ifloor(min.x);
        int maxx = FloatMath.iceil(max.x);
        int miny = FloatMath.ifloor(min.y);
        int maxy = FloatMath.iceil(max.y);
        for (int yy = miny; yy <= maxy; ++yy) {
            for (int xx = minx; xx <= maxx; ++xx) {
                for (int ys = 0; ys < this.getSubdivision(); ++ys) {
                    for (int xs = 0; xs < this.getSubdivision(); ++xs) {
                        this.updateQuadSubdivision(xx, yy, xs, ys);
                        if (!shape.intersects(this._quad)) continue;
                        int sx = xx * this.getSubdivision() + xs;
                        int sy = yy * this.getSubdivision() + ys;
                        int coord = Coord.encode(sx, sy);
                        List list = (List)this._actorFlagLists.get(coord);
                        if (oflags != 0 && list != null) {
                            list.remove((Object)oflags);
                        }
                        if (nflags != 0) {
                            if (list == null) {
                                list = Lists.newArrayListWithCapacity((int)1);
                                this._actorFlagLists.put(coord, (Object)list);
                            }
                            list.add(nflags);
                        }
                        if (list == null) continue;
                        int nsize = list.size();
                        if (nsize == 0) {
                            this._actorFlagLists.remove(coord);
                            this._actorFlags.remove(sx, sy);
                            continue;
                        }
                        int combined = 0;
                        for (int ii = 0; ii < nsize; ++ii) {
                            combined |= ((Integer)list.get(ii)).intValue();
                        }
                        this._actorFlags.put(sx, sy, combined);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector2f[] getPath(ActorLogic logic, float longest, final Logic target, boolean partial, boolean shortcut) {
        Vector2f translation = target.getTranslation();
        Actor actor = logic.getActor();
        boolean remove = false;
        Predicate<SpaceElement> filter = Space.AWALYS_TRUE_FILTER;
        if (target instanceof ActorLogic) {
            filter = new Predicate<SpaceElement>(){

                public boolean apply(SpaceElement input) {
                    return input.getUserObject() != target;
                }
            };
            boolean bl = remove = !((ActorLogic)target).isRemoved() && actor.canCollide(((ActorLogic)target).getCollisionFlags());
            if (remove) {
                this.removeFlags((ActorLogic)target);
            }
        }
        try {
            Vector2f[] path = this.getPath(true, logic, longest, actor.getTranslation().x, actor.getTranslation().y, translation.x, translation.y, partial, shortcut, filter);
            this._scenemgr.debugPath(path);
            Vector2f[] vector2fArray = path;
            return vector2fArray;
        }
        finally {
            if (remove) {
                this.addFlags((ActorLogic)target);
            }
        }
    }

    protected Vector2f[] getPath(boolean collideActor, ActorLogic logic, float longest, float ax, float ay, float bx, float by, boolean partial, boolean shortcut) {
        Vector2f[] path = this.getPath(collideActor, logic, longest, ax, ay, bx, by, partial, shortcut, Space.AWALYS_TRUE_FILTER);
        if (path != null) {
            this._scenemgr.debugPath(path);
        }
        return path;
    }

    protected float trim(float v) {
        if (v >= 0.0f) {
            return (float)((int)v) + 0.5f;
        }
        return (float)((int)v) - 0.5f;
    }

    protected Vector2f[] getPath(boolean collideActor, ActorLogic logic, float longest, float ax, float ay, float bx, float by, boolean partial, boolean shortcut, Predicate<SpaceElement> filter) {
        boolean remove;
        Object pred;
        Vector2f start = new Vector2f(ax, ay);
        if (ax == bx && ay == by) {
            return new Vector2f[]{start};
        }
        final int subdivision = this.getSubdivision();
        Vector2f end = new Vector2f(bx, by);
        if (!this.sweptShapeCollides(collideActor, logic, start, end, filter)) {
            return new Vector2f[]{end};
        }
        Rect bounds = logic.getShape().getBounds();
        int width = Math.max(1, FloatMath.iceil(bounds.getWidth() * (float)subdivision));
        int height = Math.max(1, FloatMath.iceil(bounds.getHeight() * (float)subdivision));
        Actor actor = logic.getActor();
        final int collisionMask = actor.getCollisionMask();
        if (width == 1 && height == 1) {
            pred = collideActor ? new AStarPathUtil.TraversalPred(){

                public boolean canTraverse(Object traverser, int x, int y) {
                    return (collisionMask & Pathfinder.this._entryFlags.get(MathUtil.floorDiv((int)x, (int)subdivision), MathUtil.floorDiv((int)y, (int)subdivision))) == 0 && (collisionMask & Pathfinder.this._actorFlags.get(x, y)) == 0;
                }
            } : new AStarPathUtil.TraversalPred(){

                public boolean canTraverse(Object traverser, int x, int y) {
                    return (collisionMask & Pathfinder.this._entryFlags.get(MathUtil.floorDiv((int)x, (int)subdivision), MathUtil.floorDiv((int)y, (int)subdivision))) == 0;
                }
            };
        } else {
            final int left = width / 2;
            final int right = (width - 1) / 2;
            final int bottom = height / 2;
            final int top = (height - 1) / 2;
            pred = collideActor ? new AStarPathUtil.TraversalPred(){

                public boolean canTraverse(Object traverser, int x, int y) {
                    int yymax = y + top;
                    for (int yy = y - bottom; yy <= yymax; ++yy) {
                        int xxmax = x + right;
                        for (int xx = x - left; xx <= xxmax; ++xx) {
                            if ((collisionMask & Pathfinder.this._entryFlags.get(MathUtil.floorDiv((int)xx, (int)subdivision), MathUtil.floorDiv((int)yy, (int)subdivision))) == 0 && (collisionMask & Pathfinder.this._actorFlags.get(xx, yy)) == 0) continue;
                            return false;
                        }
                    }
                    return true;
                }
            } : new AStarPathUtil.TraversalPred(){

                public boolean canTraverse(Object traverser, int x, int y) {
                    int yymax = y + top;
                    for (int yy = y - bottom; yy <= yymax; ++yy) {
                        int xxmax = x + right;
                        for (int xx = x - left; xx <= xxmax; ++xx) {
                            if ((collisionMask & Pathfinder.this._entryFlags.get(MathUtil.floorDiv((int)xx, (int)subdivision), MathUtil.floorDiv((int)yy, (int)subdivision))) == 0) continue;
                            return false;
                        }
                    }
                    return true;
                }
            };
        }
        float xoff = (float)(width % 2) * 0.5f / (float)subdivision;
        float yoff = (float)(height % 2) * 0.5f / (float)subdivision;
        ax *= (float)subdivision;
        ay *= (float)subdivision;
        bx *= (float)subdivision;
        by *= (float)subdivision;
        boolean bl = remove = !logic.isRemoved() && collideActor && actor.canCollide(logic.getCollisionFlags());
        if (remove) {
            this.removeFlags(logic);
        }
        List path = AStarPathUtil.getPath((AStarPathUtil.TraversalPred)pred, (Object)actor, (int)((int)longest), (int)Math.round(ax - xoff), (int)Math.round(ay - yoff), (int)Math.round(bx - xoff), (int)Math.round(by - yoff), (boolean)partial);
        if (remove) {
            this.addFlags(logic);
        }
        if (path == null) {
            return null;
        }
        if (path.size() <= 1) {
            return new Vector2f[]{end};
        }
        Vector2f[] waypoints = new Vector2f[path.size() + 1];
        waypoints[0] = start;
        for (int ii = 1; ii < waypoints.length; ++ii) {
            Point pt = (Point)path.get(ii - 1);
            waypoints[ii] = new Vector2f(((float)pt.x + xoff) / (float)subdivision, ((float)pt.y + yoff) / (float)subdivision);
        }
        if (!shortcut) {
            if (waypoints.length <= 1) {
                this._worldShape = logic.getShapeElement().getLocalShape().transform(this._transform.set(start, logic.getRotation()), this._worldShape);
                if (this._worldShape.intersects(new com.threerings.tudey.shape.Point(waypoints[0].x, waypoints[0].y))) {
                    waypoints[0] = end;
                }
            }
            return waypoints;
        }
        if (waypoints.length < 3) {
            if (waypoints.length <= 1) {
                this._worldShape = logic.getShapeElement().getLocalShape().transform(this._transform.set(start, logic.getRotation()), this._worldShape);
                if (this._worldShape.intersects(new com.threerings.tudey.shape.Point(waypoints[0].x, waypoints[0].y))) {
                    waypoints[0] = end;
                }
            }
            return waypoints;
        }
        Vector2f current = logic.getTranslation();
        for (int jj = 2; jj < waypoints.length; ++jj) {
            Vector2f waypoint = waypoints[jj];
            if (!this.sweptShapeCollides(collideActor, logic, current, waypoint)) continue;
            current = waypoints[jj - 1];
            this._waypoints.add(current);
        }
        if (!this._waypoints.contains(waypoints[waypoints.length - 1])) {
            this._waypoints.add(waypoints[waypoints.length - 1]);
        }
        waypoints = this._waypoints.toArray(new Vector2f[this._waypoints.size()]);
        this._waypoints.clear();
        return waypoints;
    }

    protected boolean sweptShapeCollides(boolean collideActor, ActorLogic logic, Vector2f start, Vector2f end) {
        return this.sweptShapeCollides(collideActor, logic, start, end, Space.AWALYS_TRUE_FILTER);
    }

    protected boolean sweptShapeCollides(boolean collideActor, ActorLogic logic, Vector2f start, Vector2f end, Predicate<SpaceElement> filter) {
        this._worldShape = logic.getShapeElement().getLocalShape().transform(this._transform.set(start, logic.getRotation()), this._worldShape);
        this._sweptShape = this._worldShape.sweep(end.subtract(start, this._translation), this._sweptShape);
        if (this.debug) {
            this._scenemgr.flashShape(null, 1000, false, this._sweptShape);
            System.out.println("start=" + start + ",end=" + end);
        }
        if (!collideActor) {
            return ((TudeySceneModel)this._scenemgr.getScene().getSceneModel()).collides(logic.getActor(), this._sweptShape);
        }
        return this._scenemgr.collides(logic.getActor(), this._sweptShape, this._scenemgr.getTimestamp(), filter);
    }

    protected boolean sweptShapeCollides(boolean collideActor, ActorLogic logic, Shape shape) {
        if (this.debug) {
            this._scenemgr.flashShape(null, 1000, false, shape);
        }
        if (!collideActor) {
            return ((TudeySceneModel)this._scenemgr.getScene().getSceneModel()).collides(logic.getActor(), shape);
        }
        return this._scenemgr.collides(logic, shape);
    }

    protected void addFlags(TudeySceneModel.Entry entry) {
        int yy;
        if (!(entry instanceof TudeySceneModel.TileEntry)) {
            ConfigManager cfgmgr = this._scenemgr.getConfigManager();
            Shape shape = entry.createShape(cfgmgr);
            if (shape != null) {
                this.addFlags(shape, entry.getCollisionFlags(cfgmgr), null, true);
            }
            return;
        }
        TudeySceneModel.TileEntry tentry = (TudeySceneModel.TileEntry)entry;
        TileConfig.Original config = tentry.getConfig(this._scenemgr.getConfigManager());
        tentry.getRegion(config, this._region);
        int yymax = yy + this._region.height;
        for (yy = this._region.y; yy < yymax; ++yy) {
            int xx;
            int xxmax = xx + this._region.width;
            for (xx = this._region.x; xx < xxmax; ++xx) {
                int flags = tentry.getCollisionFlags(config, xx, yy);
                if (flags == 0) continue;
                this._entryFlags.setBits(xx, yy, flags);
            }
        }
    }

    protected void removeFlags(TudeySceneModel.Entry entry) {
        int yy;
        if (!(entry instanceof TudeySceneModel.TileEntry)) {
            ConfigManager cfgmgr = this._scenemgr.getConfigManager();
            Shape shape = entry.createShape(cfgmgr);
            if (shape != null) {
                this.removeFlags(shape, entry.getCollisionFlags(cfgmgr), null, true, null);
            }
            return;
        }
        TudeySceneModel.TileEntry tentry = (TudeySceneModel.TileEntry)entry;
        TileConfig.Original config = tentry.getConfig(this._scenemgr.getConfigManager());
        tentry.getRegion(config, this._region);
        int yymax = yy + this._region.height;
        for (yy = this._region.y; yy < yymax; ++yy) {
            int xx;
            int xxmax = xx + this._region.width;
            for (xx = this._region.x; xx < xxmax; ++xx) {
                int flags = tentry.getCollisionFlags(config, xx, yy);
                if (flags == 0) continue;
                this.updateQuad(xx, yy);
                this.updateEntryFlags(xx, yy, null);
            }
        }
    }

    protected void addFlags(ActorLogic logic) {
        this.addFlags(logic.getShape(), logic.getCollisionFlags(), logic.getActor().getOriginal().traversalCosts, false);
    }

    protected void removeFlags(ActorLogic logic) {
        this.removeFlags(logic.getShape(), logic.getCollisionFlags(), logic.getActor().getOriginal().traversalCosts, false, logic.getShapeElement());
    }

    protected void addFlags(Shape shape, int flags, IntPair[] pairs, boolean entry) {
        if (flags == 0 && pairs == null) {
            return;
        }
        Rect bounds = shape.getBounds();
        Vector2f min = bounds.getMinimumExtent();
        Vector2f max = bounds.getMaximumExtent();
        int minx = FloatMath.ifloor(min.x);
        int maxx = FloatMath.iceil(max.x);
        int miny = FloatMath.ifloor(min.y);
        int maxy = FloatMath.iceil(max.y);
        for (int yy = miny; yy <= maxy; ++yy) {
            for (int xx = minx; xx <= maxx; ++xx) {
                if (entry) {
                    this.updateQuad(xx, yy);
                    if (!shape.intersects(this._quad)) continue;
                    this._entryFlags.setBits(xx, yy, flags);
                    continue;
                }
                for (int ys = 0; ys < this.getSubdivision(); ++ys) {
                    for (int xs = 0; xs < this.getSubdivision(); ++xs) {
                        this.updateQuadSubdivision(xx, yy, xs, ys);
                        if (!shape.intersects(this._quad)) continue;
                        int sx = xx * this.getSubdivision() + xs;
                        int sy = yy * this.getSubdivision() + ys;
                        int coord = Coord.encode(sx, sy);
                        if (pairs != null) {
                            List listPair = (List)this._actorTraversalCosts.get(coord);
                            if (listPair == null) {
                                listPair = Lists.newArrayListWithCapacity((int)1);
                                this._actorTraversalCosts.put(coord, (Object)listPair);
                            }
                            for (IntPair pair : pairs) {
                                listPair.add(pair);
                            }
                        }
                        if (flags == 0) continue;
                        this._actorFlags.setBits(sx, sy, flags);
                        List list = (List)this._actorFlagLists.get(coord);
                        if (list == null) {
                            list = Lists.newArrayListWithCapacity((int)1);
                            this._actorFlagLists.put(coord, (Object)list);
                        }
                        list.add(flags);
                    }
                }
            }
        }
    }

    @Override
    public int caculate(ActorLogic actor, int x, int y) {
        int coord = Coord.encode(x, y);
        List pairs = (List)this._actorTraversalCosts.get(coord);
        if (pairs != null) {
            int normal = 0;
            for (IntPair pair : pairs) {
                if (pair.key == 0) {
                    normal = pair.value;
                    continue;
                }
                if (pair.key != actor.getActor().getOriginal().type) continue;
                return pair.value;
            }
            return normal;
        }
        return 0;
    }

    protected void removeFlags(Shape shape, int flags, IntPair[] pairs, boolean entry, SpaceElement skip) {
        if (flags == 0 && pairs == null) {
            return;
        }
        Rect bounds = shape.getBounds();
        Vector2f min = bounds.getMinimumExtent();
        Vector2f max = bounds.getMaximumExtent();
        int minx = FloatMath.ifloor(min.x);
        int maxx = FloatMath.iceil(max.x);
        int miny = FloatMath.ifloor(min.y);
        int maxy = FloatMath.iceil(max.y);
        for (int yy = miny; yy <= maxy; ++yy) {
            for (int xx = minx; xx <= maxx; ++xx) {
                if (entry) {
                    this.updateQuad(xx, yy);
                    if (!shape.intersects(this._quad)) continue;
                    this.updateEntryFlags(xx, yy, skip);
                    continue;
                }
                for (int ys = 0; ys < this.getSubdivision(); ++ys) {
                    for (int xs = 0; xs < this.getSubdivision(); ++xs) {
                        List list;
                        int sy;
                        this.updateQuadSubdivision(xx, yy, xs, ys);
                        if (!shape.intersects(this._quad)) continue;
                        int sx = xx * this.getSubdivision() + xs;
                        int coord = Coord.encode(sx, sy = yy * this.getSubdivision() + ys);
                        List listPair = (List)this._actorTraversalCosts.get(coord);
                        if (listPair != null && pairs != null) {
                            for (IntPair pair : pairs) {
                                listPair.remove(pair);
                            }
                            int nsize = listPair.size();
                            if (nsize == 0) {
                                this._actorTraversalCosts.remove(coord);
                            }
                        }
                        if (flags == 0 || (list = (List)this._actorFlagLists.get(coord)) == null) continue;
                        list.remove((Object)flags);
                        int nsize = list.size();
                        if (nsize == 0) {
                            this._actorFlagLists.remove(coord);
                            this._actorFlags.remove(sx, sy);
                            continue;
                        }
                        int combined = 0;
                        for (int ii = 0; ii < nsize; ++ii) {
                            combined |= ((Integer)list.get(ii)).intValue();
                        }
                        this._actorFlags.put(sx, sy, combined);
                    }
                }
            }
        }
    }

    protected void updateQuad(int x, int y) {
        this.updateQuad(x, y, x + 1, y + 1);
    }

    protected void updateQuadSubdivision(int x, int y, int xs, int ys) {
        this.updateQuad((float)x + (float)xs / (float)this.getSubdivision(), (float)y + (float)ys / (float)this.getSubdivision(), (float)x + (float)(xs + 1) / (float)this.getSubdivision(), (float)y + (float)(ys + 1) / (float)this.getSubdivision());
    }

    protected void updateQuad(float lx, float ly, float ux, float uy) {
        this._quad.getVertex(0).set(lx += 2.0E-6f, ly += 2.0E-6f);
        this._quad.getVertex(1).set(ux -= 2.0E-6f, ly);
        this._quad.getVertex(2).set(ux, uy -= 2.0E-6f);
        this._quad.getVertex(3).set(lx, uy);
        this._quad.getBounds().getMinimumExtent().set(lx, ly);
        this._quad.getBounds().getMaximumExtent().set(ux, uy);
    }

    protected void updateEntryFlags(int x, int y, SpaceElement skip) {
        TudeySceneModel model = (TudeySceneModel)this._scenemgr.getScene().getSceneModel();
        int flags = model.getCollisionFlags().get(x, y);
        model.getSpace().getIntersecting(this._quad, this._elements);
        ConfigManager cfgmgr = this._scenemgr.getConfigManager();
        int nn = this._elements.size();
        for (int ii = 0; ii < nn; ++ii) {
            SpaceElement element = this._elements.get(ii);
            if (element == skip) continue;
            flags |= ((TudeySceneModel.Entry)element.getUserObject()).getCollisionFlags(cfgmgr);
        }
        this._elements.clear();
        this._entryFlags.put(x, y, flags);
    }

    protected int getSubdivision() {
        return 2;
    }
}

