/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.logic;

import com.google.common.collect.Lists;
import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;
import com.threerings.tudey.config.RegionConfig;
import com.threerings.tudey.data.EntityKey;
import com.threerings.tudey.server.TudeySceneManager;
import com.threerings.tudey.server.logic.Logic;
import com.threerings.tudey.server.logic.TargetLogic;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.util.DirectionLimit;
import com.threerings.tudey.util.DirectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public abstract class RegionLogic
extends Logic {
    protected RegionConfig _config;
    protected Logic _source;

    public void init(TudeySceneManager scenemgr, RegionConfig config, Logic source) {
        super.init(scenemgr);
        this._config = config;
        this._source = source;
        this.didInit();
    }

    public abstract void resolve(Logic var1, Collection<Shape> var2);

    @Override
    public boolean isActive() {
        return this._source.isActive();
    }

    @Override
    public EntityKey getEntityKey() {
        return this._source.getEntityKey();
    }

    @Override
    public Vector2f getTranslation() {
        return this._source.getTranslation();
    }

    @Override
    public float getRotation() {
        return this._source.getRotation();
    }

    protected void didInit() {
    }

    public static class Fixed
    extends RegionLogic {
        @Override
        public void resolve(Logic activator, Collection<Shape> results) {
            results.add(((RegionConfig.Fixed)this._config).shape.getShape());
        }
    }

    public static class Transformed
    extends Located {
        protected Transform2D _transform = new Transform2D();

        @Override
        protected void getShapes(Collection<Shape> results) {
            RegionConfig.Transformed config = (RegionConfig.Transformed)this._config;
            Shape shape = config.shape.getShape();
            int nn = this._locations.size();
            for (int ii = 0; ii < nn; ++ii) {
                Logic location = (Logic)this._locations.get(ii);
                location.getTransform(this._transform);
                DirectionLimit limit = config.direct;
                if (config.fixed) {
                    this._transform.getTranslation().set(this._transform.getTranslation().adjustCenter());
                }
                if (limit == DirectionLimit.FREE) {
                    results.add(shape.transform(this._transform));
                    continue;
                }
                if (limit == DirectionLimit.FOUR) {
                    this._transform.setRotation(DirectionUtil.normalize4Direction(this._transform.getRotation()));
                    results.add(shape.transform(this._transform));
                    continue;
                }
                if (limit != DirectionLimit.TWO) continue;
                this._transform.setRotation(DirectionUtil.normalize2Direction(this._transform.getRotation()));
                results.add(shape.transform(this._transform));
            }
        }
    }

    public static class Default
    extends Located {
        @Override
        protected void getShapes(Collection<Shape> results) {
            float expansion = ((RegionConfig.Default)this._config).expansion;
            int nn = this._locations.size();
            for (int ii = 0; ii < nn; ++ii) {
                Shape shape = ((Logic)this._locations.get(ii)).getShape();
                if (shape == null) continue;
                results.add(expansion == 0.0f ? shape : shape.expand(expansion));
            }
        }
    }

    public static abstract class Located
    extends RegionLogic {
        protected TargetLogic _location;
        protected ArrayList<Logic> _locations = Lists.newArrayList();

        @Override
        public void resolve(Logic activator, Collection<Shape> results) {
            this._location.resolve(activator, this._locations);
            this.getShapes(results);
            this._locations.clear();
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._location.transfer(((Located)source)._location, refs);
        }

        @Override
        protected void didInit() {
            this._location = this.createTarget(((RegionConfig.Located)this._config).location, this._source);
        }

        protected abstract void getShapes(Collection<Shape> var1);
    }
}

