/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.logic;

import com.threerings.config.ConfigReference;
import com.threerings.math.FloatMath;
import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;
import com.threerings.tudey.config.EffectConfig;
import com.threerings.tudey.data.EntityKey;
import com.threerings.tudey.data.effect.Effect;
import com.threerings.tudey.server.TudeySceneManager;
import com.threerings.tudey.server.logic.ActionLogic;
import com.threerings.tudey.server.logic.Logic;
import com.threerings.tudey.server.logic.PawnLogic;
import com.threerings.tudey.shape.Shape;

public class EffectLogic
extends Logic {
    protected EffectConfig.Original _config;
    protected Effect _effect;
    protected Logic _target;
    protected Logic _source;
    protected Shape _shape;
    protected ActionLogic _action;

    public void init(TudeySceneManager scenemgr, ConfigReference<EffectConfig> ref, EffectConfig.Original config, int timestamp, Logic source, Logic target, Vector2f translation, float rotation) {
        EntityKey targetKey;
        super.init(scenemgr);
        this._config = config;
        this._target = target;
        this._source = source;
        if (target != null) {
            targetKey = target.getEntityKey();
            translation = translation == null ? target.getTranslation() : translation.add(target.getTranslation());
            rotation = FloatMath.normalizeAngle(rotation + target.getRotation());
        } else {
            targetKey = null;
        }
        EntityKey sourceKey = source != null ? source.getEntityKey() : null;
        this._effect = this.createEffect(ref, timestamp, sourceKey, targetKey, translation, rotation);
        this._effect.init(scenemgr.getConfigManager());
        this._shape = config.shape.getShape().transform(new Transform2D(translation, rotation));
        this._action = config.action == null ? null : this.createAction(config.action, this);
        this.didInit();
    }

    public Effect getEffect() {
        return this._effect;
    }

    @Override
    public Shape getShape() {
        return this._shape;
    }

    @Override
    public boolean isVisible(PawnLogic pawn) {
        return !this._config.targetOnly || this._target == pawn;
    }

    @Override
    public Vector2f getTranslation() {
        return this._effect.getTranslation();
    }

    @Override
    public float getRotation() {
        return this._effect.getRotation();
    }

    protected Effect createEffect(ConfigReference<EffectConfig> ref, int timestamp, EntityKey source, EntityKey target, Vector2f translation, float rotation) {
        return this._config.createEffect(ref, timestamp, source, target, translation, rotation);
    }

    protected void didInit() {
        if (this._action != null) {
            this._action.execute(this._effect.getTimestamp(), this._target == null ? this : this._target);
        }
    }

    public void removed() {
        this.wasRemoved();
    }

    protected void wasRemoved() {
        if (this._action != null) {
            this._action.removed();
        }
    }
}

