/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.logic;

import com.google.common.collect.Maps;
import com.threerings.tudey.data.actor.Active;
import com.threerings.tudey.server.logic.ActivityLogic;
import com.threerings.tudey.server.logic.Logic;
import com.threerings.tudey.server.logic.MobileLogic;
import java.util.Map;

public class ActiveLogic
extends MobileLogic {
    protected Map<Long, ActivityLogic> _activities = Maps.newHashMap();
    protected int _lastActivityStarted;
    protected ActivityLogic _lastTickedActivity;

    public int getActivityAdvance() {
        return 0;
    }

    @Override
    public void transfer(Logic source, Map<Object, Object> refs) {
        super.transfer(source, refs);
        ActiveLogic asource = (ActiveLogic)source;
        for (Map.Entry<Long, ActivityLogic> entry : asource._activities.entrySet()) {
            if (this._activities.get(entry.getKey()) == null) continue;
            this._activities.get(entry.getKey()).transfer(entry.getValue(), refs);
        }
        this._lastActivityStarted = asource._lastActivityStarted;
    }

    @Override
    public boolean tick(int timestamp) {
        super.tick(timestamp);
        return true;
    }

    @Override
    protected void advance(int timestamp) {
        this._advancer.advance(timestamp);
        this.updateActivities(timestamp);
        this._advancer.afterAdvance(timestamp);
    }

    public ActivityLogic getActivity() {
        Active active = (Active)this._actor;
        long activity = active.getActivity();
        if (activity != 0L) {
            return this._activities.get(activity);
        }
        return null;
    }

    public void activate(int timestamp) {
    }

    protected void updateActivities(int timestamp) {
        Active active = (Active)this._actor;
        ActivityLogic activity = this._activities.get(active.getActivity());
        if ((this._lastTickedActivity != activity || this._lastActivityStarted != active.getActivityStarted()) && this._lastTickedActivity != null) {
            this._lastTickedActivity.stop(timestamp);
        }
        this._lastTickedActivity = activity;
        if (activity != null) {
            int started = active.getActivityStarted();
            if (started > this._lastActivityStarted) {
                this._lastActivityStarted = started;
                activity.start(this._lastActivityStarted);
            }
            activity.tick(timestamp);
        }
    }

    @Override
    protected void wasDestroyed() {
        Active active = (Active)this._actor;
        ActivityLogic activity = this._activities.get(active.getActivity());
        if (activity != null) {
            activity.stop(this._scenemgr.getTimestamp());
        }
        if (this._lastTickedActivity != null && activity != this._lastTickedActivity) {
            this._lastTickedActivity.stop(this._scenemgr.getTimestamp());
        }
        super.wasDestroyed();
    }
}

