/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.graph;

import com.google.common.collect.Lists;
import com.threerings.math.Vector2f;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.server.graph.GraphFinder;
import com.threerings.tudey.server.graph.Node;
import com.threerings.tudey.shape.Capsule;
import com.threerings.tudey.shape.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SimpleGraphFinder
implements GraphFinder {
    private List<Node> nodes;
    private TudeySceneModel.GraphEntry entry = null;
    private int sceneId;
    private TudeySceneModel _model;

    public SimpleGraphFinder(TudeySceneModel model) {
        this._model = model;
        this.sceneId = model.sceneId;
        Iterable<TudeySceneModel.GraphEntry> ge = model.getEntries(TudeySceneModel.GraphEntry.class);
        Iterator<TudeySceneModel.GraphEntry> it = ge.iterator();
        if (it.hasNext()) {
            this.entry = it.next();
        }
        if (this.entry == null || this.entry.vertices.length == 0 || this.entry.edges.length == 0) {
            return;
        }
        this.setupGraphNodes();
    }

    private Node findStartNode(Vector2f location) {
        float dist = 2.1474836E9f;
        int radius = 10;
        int mask = 3;
        Node start = new Node("START", location, 1);
        Capsule segment = new Capsule();
        segment.radius = 0.35f;
        Node result = null;
        for (Node node : this.nodes) {
            float dd = node.getLocation().distance(location);
            if (dd < dist) {
                result = node;
                dist = dd;
            }
            if (!(dd < (float)radius)) continue;
            segment.getStart().set(location);
            segment.getEnd().set(node.getLocation());
            segment.updateBounds();
            if (this._model.collides(mask, (Shape)segment)) continue;
            start.addNeighbor(node, (int)dd);
        }
        if (start.getNeighbors().size() != 0) {
            return start;
        }
        return result;
    }

    private Node findNearestNode(Vector2f location) {
        float dist = 2.1474836E9f;
        Node result = null;
        for (Node node : this.nodes) {
            float dd = node.getLocation().distance(location);
            if (!(dd < dist)) continue;
            result = node;
            dist = dd;
        }
        return result;
    }

    @Override
    public Vector2f[] runAStar(Vector2f start, Vector2f end) {
        if (this.entry == null || this.entry.vertices.length == 0 || this.entry.edges.length == 0) {
            return null;
        }
        Node startNode = this.findStartNode(start);
        this.resetNode(startNode);
        List<Vector2f> result = this.AStarSearch(startNode, this.findNearestNode(end));
        result.add(0, end);
        return Lists.reverse(result).toArray(new Vector2f[result.size()]);
    }

    @Override
    public Vector2f[] runBreadthFirst(Vector2f start, Vector2f end) {
        if (this.entry == null || this.entry.vertices.length == 0 || this.entry.edges.length == 0) {
            return null;
        }
        Node startNode = this.findStartNode(start);
        this.resetNode(startNode);
        List<Vector2f> result = this.BreadthFirstSearch(startNode, this.findNearestNode(end));
        result.add(0, end);
        return Lists.reverse(result).toArray(new Vector2f[result.size()]);
    }

    private void setupGraphNodes() {
        Node[] nodeArrays = new Node[this.entry.vertices.length];
        for (int i = 0; i < this.entry.vertices.length; ++i) {
            nodeArrays[i] = new Node("" + i, this.entry.vertices[i].createVector(), 1);
        }
        for (TudeySceneModel.Edge edge : this.entry.edges) {
            int dist = (int)nodeArrays[edge.end].getLocation().distance(nodeArrays[edge.start].getLocation());
            nodeArrays[edge.start].addNeighbor(nodeArrays[edge.end], dist);
            nodeArrays[edge.end].addNeighbor(nodeArrays[edge.start], dist);
        }
        this.checkNode(nodeArrays[0]);
        boolean hasError = false;
        for (int i = 0; i < nodeArrays.length; ++i) {
            if (nodeArrays[i].isChecked()) continue;
            System.out.println("sceneId=" + this.sceneId + ", Node=" + nodeArrays[i].getName() + " is invalid");
            hasError = true;
        }
        if (!hasError) {
            System.out.println("sceneId=" + this.sceneId + " all nodes are valid");
        }
        this.nodes = Arrays.asList(nodeArrays);
    }

    private void checkNode(Node n) {
        for (Node node : n.getNeighbors().keySet()) {
            if (node.isChecked()) continue;
            node.setChecked(true);
            this.checkNode(node);
        }
    }

    private List<Vector2f> AStarSearch(Node start, Node goal) {
        HashMap<Node, Integer> nodeQueue = new HashMap<Node, Integer>();
        ArrayList<Node> expanded = new ArrayList<Node>();
        int startScore = start.getHeuristic() + 0;
        nodeQueue.put(start, startScore);
        Node current = start;
        while (!current.getName().equals(goal.getName())) {
            for (Node neighbor : current.getNeighbors().keySet()) {
                if (expanded.contains(neighbor)) continue;
                if (nodeQueue.containsKey(neighbor)) {
                    int existedNodeScore;
                    int tempNeighborScore = (Integer)nodeQueue.get(current) - current.getHeuristic() + current.getNeighbors().get(neighbor) + neighbor.getHeuristic();
                    if (tempNeighborScore >= (existedNodeScore = ((Integer)nodeQueue.get(neighbor)).intValue())) continue;
                    neighbor.setSource(current);
                    nodeQueue.put(neighbor, tempNeighborScore);
                    continue;
                }
                neighbor.setSource(current);
                int neighborScore = (Integer)nodeQueue.get(neighbor.getSource()) - neighbor.getSource().getHeuristic() + neighbor.getSource().getNeighbors().get(neighbor) + neighbor.getHeuristic();
                nodeQueue.put(neighbor, neighborScore);
            }
            expanded.add(current);
            nodeQueue.remove(current);
            current = this.getMinValue(nodeQueue);
        }
        Node tracker = current;
        ArrayList result = Lists.newArrayList();
        result.add(goal.getLocation());
        while (tracker.getSource() != null) {
            result.add(tracker.getSource().getLocation());
            tracker = tracker.getSource();
        }
        return result;
    }

    private List<Vector2f> BreadthFirstSearch(Node start, Node goal) {
        LinkedList<Node> nodeQueue = new LinkedList<Node>();
        ArrayList<Node> expanded = new ArrayList<Node>();
        Node current = start;
        while (!current.getName().equals(goal.getName())) {
            for (Node neighbor : current.getNeighbors().keySet()) {
                if (expanded.contains(neighbor) || nodeQueue.contains(neighbor)) continue;
                neighbor.setSource(current);
                nodeQueue.add(neighbor);
            }
            expanded.add(current);
            current = (Node)nodeQueue.remove();
        }
        Node tracker = current;
        ArrayList result = Lists.newArrayList();
        result.add(goal.getLocation());
        while (tracker.getSource() != null) {
            result.add(tracker.getSource().getLocation());
            tracker = tracker.getSource();
        }
        return result;
    }

    private Node getMinValue(Map<Node, Integer> treeMap) {
        Node minNode = null;
        int min = Integer.MAX_VALUE;
        for (Map.Entry<Node, Integer> entry : treeMap.entrySet()) {
            Node node = entry.getKey();
            Integer value = entry.getValue();
            if (value >= min) continue;
            min = value;
            minNode = node;
        }
        return minNode;
    }

    private void resetNode(Node startNode) {
        if (startNode.getSource() != null) {
            startNode.setSource(null);
        }
    }
}

