/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.graph;

import com.google.common.collect.Lists;
import com.threerings.math.Vector2f;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.server.graph.GraphFinder;
import com.threerings.tudey.server.graph.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.implementations.SingleGraph;

public class RichUIGraphFinder
implements GraphFinder {
    private static List<Node> nodes;
    private static Graph graph;
    private long DELAY = 1500L;
    TudeySceneModel.GraphEntry entry = null;

    public RichUIGraphFinder(TudeySceneModel model) {
        Iterable<TudeySceneModel.GraphEntry> ge = model.getEntries(TudeySceneModel.GraphEntry.class);
        Iterator<TudeySceneModel.GraphEntry> it = ge.iterator();
        if (it.hasNext()) {
            this.entry = it.next();
        }
        graph = new SingleGraph("PathFinder");
        graph.setAutoCreate(false);
        graph.setStrict(true);
        graph.display();
        graph.addAttribute("ui.quality", new Object[0]);
        graph.addAttribute("ui.antialias", new Object[0]);
        graph.addAttribute("ui.stylesheet", new Object[]{"url('style.css')"});
        this.setupGraphNodes();
    }

    private Node findNearestNode(Vector2f location) {
        float dist = 2.1474836E9f;
        Node result = null;
        for (Node node : nodes) {
            float dd = node.getLocation().distance(location);
            if (!(dd < dist)) continue;
            result = node;
            dist = dd;
        }
        return result;
    }

    @Override
    public Vector2f[] runAStar(Vector2f start, Vector2f end) {
        if (this.entry == null || this.entry.vertices.length == 0 || this.entry.edges.length == 0) {
            return null;
        }
        this.clearNodeColors();
        Node startNode = this.findNearestNode(start);
        this.resetNode(startNode);
        List<Vector2f> result = this.AStarSearch(startNode, this.findNearestNode(end));
        result.add(0, end);
        return Lists.reverse(result).toArray(new Vector2f[result.size()]);
    }

    @Override
    public Vector2f[] runBreadthFirst(Vector2f start, Vector2f end) {
        if (this.entry == null || this.entry.vertices.length == 0 || this.entry.edges.length == 0) {
            return null;
        }
        Node startNode = this.findNearestNode(start);
        this.resetNode(startNode);
        List<Vector2f> result = this.BreadthFirstSearch(startNode, this.findNearestNode(end));
        result.add(0, end);
        return Lists.reverse(result).toArray(new Vector2f[result.size()]);
    }

    private void setupGraphNodes() {
        Node[] nodeArrays = new Node[this.entry.vertices.length];
        for (int i = 0; i < this.entry.vertices.length; ++i) {
            nodeArrays[i] = new Node("" + i, this.entry.vertices[i].createVector(), 100);
            System.out.println(this.entry.vertices[i]);
        }
        System.out.println("---------------------");
        for (TudeySceneModel.Edge edge : this.entry.edges) {
            System.out.println(edge);
            int dist = (int)nodeArrays[edge.end].getLocation().distance(nodeArrays[edge.start].getLocation());
            nodeArrays[edge.start].addNeighbor(nodeArrays[edge.end], dist);
            nodeArrays[edge.end].addNeighbor(nodeArrays[edge.start], dist);
        }
        nodes = Arrays.asList(nodeArrays);
        for (Node node : nodes) {
            if (graph.getNode(node.getName()) == null) {
                org.graphstream.graph.Node graphNode = graph.addNode(node.getName());
                graphNode.addAttribute("ui.label", new Object[]{node.getName()});
                this.sleep(this.DELAY);
            }
            for (Map.Entry<Node, Integer> entry : node.getNeighbors().entrySet()) {
                Node neighbor = entry.getKey();
                Integer cost = entry.getValue();
                if (graph.getNode(neighbor.getName()) == null) {
                    org.graphstream.graph.Node graphNeighbor = graph.addNode(neighbor.getName());
                    graphNeighbor.addAttribute("ui.label", new Object[]{neighbor.getName()});
                    StringBuilder edgeName = new StringBuilder();
                    edgeName.append(node.getName());
                    edgeName.append(neighbor.getName());
                    Edge edge = graph.addEdge(edgeName.toString(), node.getName(), neighbor.getName());
                    edge.addAttribute("ui.label", new Object[]{cost.toString()});
                    this.sleep(this.DELAY);
                    continue;
                }
                if (graph.getNode(node.getName()).getEdgeBetween(neighbor.getName()) != null) continue;
                StringBuilder edgeName = new StringBuilder();
                edgeName.append(node.getName());
                edgeName.append(neighbor.getName());
                Edge edge = graph.addEdge(edgeName.toString(), node.getName(), neighbor.getName());
                edge.addAttribute("ui.label", new Object[]{cost.toString()});
                this.sleep(this.DELAY);
            }
        }
    }

    private List<Vector2f> AStarSearch(Node start, Node goal) {
        int NODES_EXPANDED = 0;
        HashMap<Node, Integer> nodeQueue = new HashMap<Node, Integer>();
        ArrayList<Node> expanded = new ArrayList<Node>();
        int startScore = start.getHeuristic() + 0;
        nodeQueue.put(start, startScore);
        Node current = start;
        graph.getNode(current.getName()).addAttribute("ui.class", new Object[]{"start"});
        this.sleep(this.DELAY);
        while (!current.getName().equals(goal.getName())) {
            for (Node neighbor : current.getNeighbors().keySet()) {
                if (expanded.contains(neighbor)) continue;
                if (!start.getName().equals(neighbor.getName())) {
                    graph.getNode(neighbor.getName()).addAttribute("ui.class", new Object[]{"neighbor"});
                    this.sleep(this.DELAY);
                }
                if (nodeQueue.containsKey(neighbor)) {
                    int existedNodeScore;
                    int tempNeighborScore = (Integer)nodeQueue.get(current) - current.getHeuristic() + current.getNeighbors().get(neighbor) + neighbor.getHeuristic();
                    if (tempNeighborScore >= (existedNodeScore = ((Integer)nodeQueue.get(neighbor)).intValue())) continue;
                    neighbor.setSource(current);
                    nodeQueue.put(neighbor, tempNeighborScore);
                    continue;
                }
                neighbor.setSource(current);
                int neighborScore = (Integer)nodeQueue.get(neighbor.getSource()) - neighbor.getSource().getHeuristic() + neighbor.getSource().getNeighbors().get(neighbor) + neighbor.getHeuristic();
                nodeQueue.put(neighbor, neighborScore);
            }
            for (Node node : current.getNeighbors().keySet()) {
                if (node.getName().equals(start.getName()) || graph.getNode(node.getName()).getAttribute("ui.class").equals("visited")) continue;
                graph.getNode(node.getName()).removeAttribute("ui.class");
            }
            ++NODES_EXPANDED;
            expanded.add(current);
            nodeQueue.remove(current);
            if (!start.getName().equals(current.getName())) {
                graph.getNode(current.getName()).addAttribute("ui.class", new Object[]{"visited"});
            }
            current = this.getMinValue(nodeQueue);
            if (start.getName().equals(current.getName())) continue;
            graph.getNode(current.getName()).addAttribute("ui.class", new Object[]{"current"});
            this.sleep(this.DELAY);
        }
        graph.getNode(current.getName()).addAttribute("ui.class", new Object[]{"goal"});
        this.sleep(this.DELAY);
        Node tracker = current;
        System.out.println("NODES EXPANDED DURING A STAR ALGORITHM: " + NODES_EXPANDED);
        System.out.print("Path: " + goal.getName());
        ArrayList result = Lists.newArrayList();
        result.add(goal.getLocation());
        while (tracker.getSource() != null) {
            System.out.print(" <-- " + tracker.getSource().getName());
            result.add(tracker.getSource().getLocation());
            tracker = tracker.getSource();
            graph.getNode(tracker.getName()).addAttribute("ui.class", new Object[]{"start"});
            this.sleep(this.DELAY);
        }
        System.out.println();
        return result;
    }

    private List<Vector2f> BreadthFirstSearch(Node start, Node goal) {
        int NODES_EXPANDED = 0;
        LinkedList<Node> nodeQueue = new LinkedList<Node>();
        ArrayList<Node> expanded = new ArrayList<Node>();
        Node current = start;
        graph.getNode(current.getName()).addAttribute("ui.class", new Object[]{"start"});
        this.sleep(this.DELAY);
        while (!current.getName().equals(goal.getName())) {
            for (Node neighbor : current.getNeighbors().keySet()) {
                if (expanded.contains(neighbor) || nodeQueue.contains(neighbor)) continue;
                neighbor.setSource(current);
                nodeQueue.add(neighbor);
                graph.getNode(neighbor.getName()).addAttribute("ui.class", new Object[]{"neighbor"});
                this.sleep(this.DELAY);
            }
            ++NODES_EXPANDED;
            expanded.add(current);
            current = (Node)nodeQueue.remove();
            graph.getNode(current.getName()).addAttribute("ui.class", new Object[]{"current"});
            this.sleep(this.DELAY);
        }
        graph.getNode(current.getName()).addAttribute("ui.class", new Object[]{"goal"});
        this.sleep(this.DELAY);
        Node tracker = current;
        System.out.println("NODES EXPANDED DURING BFS ALGORITHM: " + NODES_EXPANDED);
        System.out.print("Path: " + goal.getName());
        ArrayList result = Lists.newArrayList();
        result.add(goal.getLocation());
        while (tracker.getSource() != null) {
            System.out.print(" <-- " + tracker.getSource().getName());
            result.add(tracker.getSource().getLocation());
            tracker = tracker.getSource();
            graph.getNode(tracker.getName()).addAttribute("ui.class", new Object[]{"start"});
            this.sleep(this.DELAY);
        }
        System.out.println();
        return result;
    }

    private Node getMinValue(Map<Node, Integer> treeMap) {
        Node minNode = null;
        int min = Integer.MAX_VALUE;
        for (Map.Entry<Node, Integer> entry : treeMap.entrySet()) {
            Node node = entry.getKey();
            Integer value = entry.getValue();
            if (value >= min) continue;
            min = value;
            minNode = node;
        }
        return minNode;
    }

    private Node getGoalNode() {
        for (Node current : nodes) {
            if (current.getHeuristic() != 0) continue;
            return current;
        }
        return null;
    }

    private Node getNode(String nodeName) {
        for (Node node : nodes) {
            if (!node.getName().equals(nodeName)) continue;
            return node;
        }
        return null;
    }

    private void clearNodeColors() {
        for (org.graphstream.graph.Node node : graph.getNodeSet()) {
            node.removeAttribute("ui.class");
        }
    }

    private void resetNode(Node startNode) {
        if (startNode.getSource() != null) {
            startNode.setSource(null);
        }
    }

    private void sleep(long ms) {
    }

    public void setVisualizationDelay(int value) {
        this.DELAY = value;
    }

    public void setGraphFontSize(int fontSize) {
        for (org.graphstream.graph.Node node : graph.getNodeSet()) {
            node.addAttribute("ui.style", new Object[]{"size: " + fontSize + "px;"});
            node.addAttribute("ui.style", new Object[]{"text-size: " + (fontSize - 5) + "px;"});
        }
        for (Edge edge : graph.getEdgeSet()) {
            edge.addAttribute("ui.style", new Object[]{"text-size: " + (fontSize - 5) + "px;"});
        }
    }
}

