/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.data.effect;

import com.google.protobuf.Message;
import com.hexnova.clyde.scene.data.Effect;
import com.hexnova.narya.util.Vector2f;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.io.SimpleStreamableObject;
import com.threerings.opengl.util.Preloadable;
import com.threerings.opengl.util.PreloadableSet;
import com.threerings.protobuf.io.ProtobufProvider;
import com.threerings.tudey.config.EffectConfig;
import com.threerings.tudey.data.EntityKey;
import com.threerings.tudey.data.effect.Prefireable;
import java.io.IOException;

public class Effect
extends SimpleStreamableObject
implements Prefireable,
ProtobufProvider<Message> {
    protected ConfigReference<EffectConfig> _config;
    protected int _timestamp;
    protected EntityKey _target;
    protected EntityKey _source;
    protected com.threerings.math.Vector2f _translation = new com.threerings.math.Vector2f();
    protected float _rotation;
    protected int _clientOid;
    protected transient EffectConfig.Original _original;
    protected static final EffectConfig.Original NULL_ORIGINAL = new EffectConfig.Original();
    private transient Effect.Builder builder = null;

    public Effect(ConfigReference<EffectConfig> config, int timestamp, EntityKey source, EntityKey target, com.threerings.math.Vector2f translation, float rotation) {
        this._config = config;
        this._timestamp = timestamp;
        this._source = source;
        this._target = target;
        this._translation.set(translation);
        this._rotation = rotation;
    }

    public Effect() {
    }

    public void init(ConfigManager cfgmgr) {
        EffectConfig config = cfgmgr.getConfig(EffectConfig.class, this._config);
        this._original = config == null ? null : config.getOriginal(cfgmgr);
        this._original = this._original == null ? NULL_ORIGINAL : this._original;
    }

    public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
        if (preloads.add(new Preloadable.Config(EffectConfig.class, this._config))) {
            this._original.getPreloads(cfgmgr, preloads);
        }
    }

    public ConfigReference<EffectConfig> getConfig() {
        return this._config;
    }

    public int getTimestamp() {
        return this._timestamp;
    }

    public EntityKey getTarget() {
        return this._target;
    }

    public com.threerings.math.Vector2f getTranslation() {
        return this._translation;
    }

    public float getRotation() {
        return this._rotation;
    }

    public int getLifespan() {
        return this._original.lifespan;
    }

    public int getExpiry() {
        return this._timestamp + this._original.lifespan;
    }

    @Override
    public void setClientOid(int clientOid) {
        this._clientOid = clientOid;
    }

    @Override
    public int getClientOid() {
        return this._clientOid;
    }

    public void populate(Message input) throws IOException {
        com.hexnova.clyde.scene.data.Effect message = (com.hexnova.clyde.scene.data.Effect)input;
        this._config = new ConfigReference(message.getConfigId());
        this._timestamp = message.getTimestamp();
        if (message.hasRotation()) {
            this._rotation = message.getRotation();
        }
        if (message.hasTranslation()) {
            this._translation = new com.threerings.math.Vector2f(message.getTranslation().getX(), message.getTranslation().getY());
        }
        if (message.hasTarget()) {
            this._target = new EntityKey.Actor(message.getTarget());
        }
        if (message.hasSource()) {
            this._source = new EntityKey.Actor(message.getSource());
        }
    }

    public Message transform() throws IOException {
        Effect.Builder builder = (Effect.Builder)this.getBuilder();
        builder.setConfigId(this._config.getName());
        builder.setRotation(this._rotation);
        if (this._translation != null) {
            builder.setTranslation((Vector2f)this._translation.transform());
        }
        if (this._target instanceof EntityKey.Actor) {
            builder.setTarget(((EntityKey.Actor)this._target).getId());
        }
        if (this._source instanceof EntityKey.Actor) {
            builder.setSource(((EntityKey.Actor)this._source).getId());
        }
        builder.setTimestamp(this._timestamp);
        return builder.build();
    }

    public Message.Builder getBuilder() {
        if (this.builder == null) {
            this.builder = com.hexnova.clyde.scene.data.Effect.newBuilder();
        }
        return this.builder;
    }
}

