/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.data.actor;

import com.threerings.io.Streamable;
import com.threerings.math.FloatMath;

public class StepLimiter
implements Streamable {
    protected float _minDirection;
    protected float _maxDirection;

    public StepLimiter(float minDirection, float maxDirection) {
        this._minDirection = FloatMath.normalizeAngle(minDirection);
        this._maxDirection = FloatMath.normalizeAngle(maxDirection);
    }

    public StepLimiter() {
    }

    public boolean canStep(float direction) {
        if (this._minDirection < this._maxDirection) {
            return direction >= this._minDirection && direction <= this._maxDirection;
        }
        return direction >= this._minDirection || direction <= this._maxDirection;
    }

    public boolean equals(Object other) {
        if (other instanceof StepLimiter) {
            StepLimiter olimiter = (StepLimiter)other;
            return olimiter._minDirection == this._minDirection && olimiter._maxDirection == this._maxDirection;
        }
        return false;
    }
}

