/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.data.actor;

import com.threerings.config.ConfigReference;
import com.threerings.delta.ProtobufField;
import com.threerings.math.Vector2f;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.config.ActionDesc;
import com.threerings.tudey.config.ActorConfig;
import com.threerings.tudey.data.actor.Active;
import com.threerings.tudey.util.ActorAdvancer;
import com.threerings.tudey.util.PawnAdvancer;
import com.threerings.tudey.util.TudeyContext;

public class Pawn
extends Active {
    public static final long DISCONNECTED = Long.MAX_VALUE;
    public static final long LOADING = 1L;
    public static final long USE_INTERACT = 2L;
    public static final long LAST_ACTIVITY = 2L;
    @ProtobufField(fieldNumber=14)
    protected int _clientOid = 0;
    protected ActionDesc _actionDesc;
    protected String _name;

    public Pawn(ConfigReference<ActorConfig> config, int id, int created, Vector2f translation, float rotation) {
        super(config, id, created, translation, rotation);
    }

    public int getClientOid() {
        return this._clientOid;
    }

    public void setClientOid(int clientOid) {
        this._clientOid = clientOid;
        this.setDirty(true);
    }

    public Pawn() {
    }

    @Override
    public boolean isClientControlled(TudeyContext ctx, TudeySceneView view) {
        return super.isClientControlled(ctx, view) || view.getController().isControlledId(this._id);
    }

    @Override
    public ActorAdvancer createAdvancer(ActorAdvancer.Environment environment, int timestamp) {
        return new PawnAdvancer(environment, this, timestamp);
    }

    public void setActionDesc(ActionDesc action) {
        if (this._actionDesc != action) {
            this._actionDesc = action;
            this.setDirty(true);
        }
    }

    @Override
    public Object copy(Object dest) {
        Pawn result = (Pawn)super.copy(dest);
        result._clientOid = this._clientOid;
        return result;
    }

    public ActionDesc getActionDesc() {
        return this._actionDesc;
    }

    public boolean canAction() {
        return this._actionDesc != null;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
        this.setDirty(true);
    }

    public boolean canUseItem() {
        return false;
    }
}

