/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.data;

import com.google.common.collect.ComparisonChain;
import com.threerings.editor.Editable;
import com.threerings.export.Exportable;
import com.threerings.io.Streamable;
import com.threerings.util.DeepObject;

public class IntPair
extends DeepObject
implements Exportable,
Streamable,
Comparable<IntPair> {
    @Editable(hgroup="a")
    public int key;
    @Editable(hgroup="a")
    public int value;

    public IntPair() {
    }

    public IntPair(IntPair paramRankPair) {
        this.set(paramRankPair);
    }

    public IntPair(int rank, int subrank) {
        this.set(rank, subrank);
    }

    @Override
    public int compareTo(IntPair o) {
        return this.compare(o);
    }

    public int compare(int rank, int subrank) {
        return ComparisonChain.start().compare(this.key, rank).compare(this.value, subrank).result();
    }

    public void set(IntPair paramRankPair) {
        this.set(paramRankPair.key, paramRankPair.value);
    }

    public void set(int key, int value) {
        this.key = key;
        this.value = value;
    }

    public int compare(IntPair paramRankPair) {
        return this.compare(paramRankPair.key, paramRankPair.value);
    }

    @Override
    public String toString() {
        return String.valueOf(this.key) + "-" + this.value;
    }

    @Override
    public int hashCode() {
        return this.key * 31 + this.value;
    }

    @Override
    public boolean equals(Object paramObject) {
        if (paramObject instanceof IntPair) {
            IntPair localRankPair = (IntPair)paramObject;
            if (this.key == localRankPair.key && this.value == localRankPair.value) {
                return true;
            }
        }
        return false;
    }
}

