/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.samskivert.util.IntTuple;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.tudey.config.GroundConfig;
import com.threerings.tudey.config.PaintableConfig;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.util.DeepObject;

public class WallConfig
extends PaintableConfig {
    @Editable
    public Implementation implementation = new Original();

    public Original getOriginal(ConfigManager cfgmgr) {
        return this.implementation.getOriginal(cfgmgr);
    }

    @Override
    protected void fireConfigUpdated() {
        this.implementation.invalidate();
        super.fireConfigUpdated();
    }

    @Override
    protected void getUpdateReferences(ConfigReferenceSet refs) {
        this.implementation.getUpdateReferences(refs);
    }

    public static class Derived
    extends Implementation {
        @Editable(nullable=true)
        public ConfigReference<WallConfig> wall;

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            refs.add(WallConfig.class, this.wall);
        }

        @Override
        public Original getOriginal(ConfigManager cfgmgr) {
            WallConfig config = cfgmgr.getConfig(WallConfig.class, this.wall);
            return config == null ? null : config.getOriginal(cfgmgr);
        }
    }

    public static class Original
    extends Implementation {
        @Editable(nullable=true)
        public ConfigReference<GroundConfig> ground;
        @Editable
        public PaintableConfig.Case[] cases = new PaintableConfig.Case[0];

        public boolean isWall(TudeySceneModel.TileEntry entry, int elevation) {
            for (PaintableConfig.Case caze : this.cases) {
                if (!PaintableConfig.matchesAny(caze.tiles, entry, elevation)) continue;
                return true;
            }
            return false;
        }

        public IntTuple getWallCaseRotations(int pattern) {
            return PaintableConfig.getCaseRotations(this.cases, pattern);
        }

        public boolean isWall(TudeySceneModel.TileEntry entry, IntTuple caseRotations, int elevation) {
            return PaintableConfig.matchesAny(this.cases, entry, caseRotations, elevation);
        }

        public TudeySceneModel.TileEntry createWall(ConfigManager cfgmgr, IntTuple caseRotations, int maxWidth, int maxHeight, int elevation) {
            return PaintableConfig.createRandomEntry(cfgmgr, this.cases[caseRotations.left].tiles, caseRotations.right, maxWidth, maxHeight, elevation);
        }

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            for (PaintableConfig.Case caze : this.cases) {
                caze.getUpdateReferences(refs);
            }
        }

        @Override
        public Original getOriginal(ConfigManager cfgmgr) {
            return this;
        }

        @Override
        public void invalidate() {
            for (PaintableConfig.Case caze : this.cases) {
                caze.invalidate();
            }
        }
    }

    @EditorTypes(value={Original.class, Derived.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable {
        public void getUpdateReferences(ConfigReferenceSet refs) {
        }

        public abstract Original getOriginal(ConfigManager var1);

        public void invalidate() {
        }
    }
}

