/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.Strippable;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.math.Transform3D;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.model.config.StaticConfig;
import com.threerings.opengl.model.config.StaticSetConfig;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.Preloadable;
import com.threerings.opengl.util.PreloadableSet;
import com.threerings.tudey.client.cursor.TileCursor;
import com.threerings.tudey.client.sprite.TileSprite;
import com.threerings.tudey.config.HandlerConfig;
import com.threerings.tudey.config.TagConfig;
import com.threerings.tudey.util.DirectionUtil;
import com.threerings.tudey.util.TudeyContext;
import com.threerings.tudey.util.TudeySceneMetrics;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;

public class TileConfig
extends ParameterizedConfig
implements Preloadable.LoadableConfig {
    public static final Original NULL_ORIGINAL = new Original("editor/error/model.dat");
    @Editable
    public Implementation implementation = new Original();

    public Original getOriginal(ConfigManager cfgmgr) {
        return this.implementation.getOriginal(cfgmgr);
    }

    public TileCursor.Implementation getCursorImplementation(TudeyContext ctx, Scope scope, TileCursor.Implementation impl) {
        return this.implementation.getCursorImplementation(ctx, scope, impl);
    }

    public TileSprite.Implementation getSpriteImplementation(TudeyContext ctx, Scope scope, TileSprite.Implementation impl) {
        return this.implementation.getSpriteImplementation(ctx, scope, impl);
    }

    @Override
    protected void fireConfigUpdated() {
        this.implementation.invalidate();
        super.fireConfigUpdated();
    }

    @Override
    protected void getUpdateReferences(ConfigReferenceSet refs) {
        this.implementation.getUpdateReferences(refs);
    }

    @Override
    public void preload(GlContext ctx) {
        this.implementation.preload(ctx);
    }

    public static class Derived
    extends Implementation {
        @Editable(nullable=true)
        public ConfigReference<TileConfig> tile;

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            refs.add(TileConfig.class, this.tile);
        }

        @Override
        public Original getOriginal(ConfigManager cfgmgr) {
            TileConfig config = cfgmgr.getConfig(TileConfig.class, this.tile);
            return config == null ? null : config.getOriginal(cfgmgr);
        }

        @Override
        public TileCursor.Implementation getCursorImplementation(TudeyContext ctx, Scope scope, TileCursor.Implementation impl) {
            TileConfig config = ctx.getConfigManager().getConfig(TileConfig.class, this.tile);
            return config == null ? null : config.getCursorImplementation(ctx, scope, impl);
        }

        @Override
        public TileSprite.Implementation getSpriteImplementation(TudeyContext ctx, Scope scope, TileSprite.Implementation impl) {
            TileConfig config = ctx.getConfigManager().getConfig(TileConfig.class, this.tile);
            return config == null ? null : config.getSpriteImplementation(ctx, scope, impl);
        }
    }

    public static class Original
    extends Implementation {
        @Editable(min=1.0, hgroup="d")
        public int width = 1;
        @Editable(min=1.0, hgroup="d")
        public int height = 1;
        @Editable(hgroup="d")
        @Strippable
        public boolean defaultEntrance;
        @Editable(nullable=true)
        public ConfigReference<ModelConfig> model;
        @Editable(width=3)
        public int[][] collisionFlags = new int[][]{{1}};
        @Editable(width=3)
        public int[][] directionFlags = new int[][]{{0}};
        @Editable(editor="mask", mode="floor", hgroup="f")
        public int floorFlags = 1;
        @Editable(hgroup="f")
        public boolean mergeable = true;
        @Editable
        public TagConfig tags = new TagConfig();
        @Editable
        public HandlerConfig[] handlers = new HandlerConfig[0];
        @DeepOmit
        protected transient Boolean _modelStatic;

        public Original() {
        }

        public Original(String model) {
            this.model = new ConfigReference(model);
        }

        public boolean isMergeable(ConfigManager cfgmgr) {
            if (!this.mergeable || this.getLogicClassName() != null) {
                return false;
            }
            if (this._modelStatic == null) {
                ModelConfig config = cfgmgr.getConfig(ModelConfig.class, this.model);
                ModelConfig.Implementation original = config == null ? null : config.getOriginal();
                this._modelStatic = original instanceof StaticConfig || original instanceof StaticSetConfig;
            }
            return this._modelStatic;
        }

        public void getTransform(int x, int y, int elevation, int rotation, Transform3D result) {
            TudeySceneMetrics.getTileTransform(this.width, this.height, x, y, elevation, rotation, result);
        }

        public void getRegion(int x, int y, int rotation, Rectangle result) {
            TudeySceneMetrics.getTileRegion(this.width, this.height, x, y, rotation, result);
        }

        public int getWidth(int rotation) {
            return TudeySceneMetrics.getTileWidth(this.width, this.height, rotation);
        }

        public int getHeight(int rotation) {
            return TudeySceneMetrics.getTileHeight(this.width, this.height, rotation);
        }

        public int getCollisionFlags(int x, int y, int rotation, int tx, int ty) {
            return this.getRotatedValue(this.collisionFlags, x, y, rotation, tx, ty);
        }

        public int getDirectionFlags(int x, int y, int rotation, int tx, int ty) {
            return DirectionUtil.rotateCardinal(this.getRotatedValue(this.directionFlags, x, y, rotation, tx, ty), rotation);
        }

        public String getLogicClassName() {
            return this.tags.getLength() == 0 && this.handlers.length == 0 && !this.defaultEntrance ? null : "com.threerings.tudey.server.logic.EntryLogic";
        }

        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            preloads.add(new Preloadable.Model(this.model));
            for (HandlerConfig handler : this.handlers) {
                handler.getPreloads(cfgmgr, preloads);
            }
        }

        @Override
        public void preload(GlContext ctx) {
        }

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            refs.add(ModelConfig.class, this.model);
        }

        @Override
        public Original getOriginal(ConfigManager cfgmgr) {
            return this;
        }

        @Override
        public TileCursor.Implementation getCursorImplementation(TudeyContext ctx, Scope scope, TileCursor.Implementation impl) {
            if (impl instanceof TileCursor.Original) {
                ((TileCursor.Original)impl).setConfig(this);
            } else {
                impl = new TileCursor.Original(ctx, scope, this);
            }
            return impl;
        }

        @Override
        public TileSprite.Implementation getSpriteImplementation(TudeyContext ctx, Scope scope, TileSprite.Implementation impl) {
            if (impl instanceof TileSprite.Original) {
                ((TileSprite.Original)impl).setConfig(this);
            } else {
                impl = new TileSprite.Original(ctx, scope, this);
            }
            return impl;
        }

        @Override
        public void invalidate() {
            for (HandlerConfig handler : this.handlers) {
                handler.invalidate();
            }
            this._modelStatic = null;
        }

        protected int getRotatedValue(int[][] values, int x, int y, int rotation, int tx, int ty) {
            int fy;
            int fx;
            if (values.length == 0) {
                return 0;
            }
            switch (rotation) {
                default: {
                    fx = tx - x;
                    fy = this.height - 1 - (ty - y);
                    break;
                }
                case 1: {
                    fx = ty - y;
                    fy = tx - x;
                    break;
                }
                case 2: {
                    fx = this.width - 1 - (tx - x);
                    fy = ty - y;
                    break;
                }
                case 3: {
                    fx = this.width - 1 - (ty - y);
                    fy = this.height - 1 - (tx - x);
                }
            }
            int[] row = values[fy % values.length];
            return row.length == 0 ? 0 : row[fx % row.length];
        }
    }

    @EditorTypes(value={Original.class, Derived.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable {
        public void getUpdateReferences(ConfigReferenceSet refs) {
        }

        public abstract Original getOriginal(ConfigManager var1);

        public abstract TileCursor.Implementation getCursorImplementation(TudeyContext var1, Scope var2, TileCursor.Implementation var3);

        public abstract TileSprite.Implementation getSpriteImplementation(TudeyContext var1, Scope var2, TileSprite.Implementation var3);

        public void invalidate() {
        }

        public void preload(GlContext ctx) {
        }
    }
}

