/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.Strippable;
import com.threerings.export.Exportable;
import com.threerings.io.Streamable;
import com.threerings.tudey.config.ConditionConfig;
import com.threerings.tudey.config.RegionConfig;
import com.threerings.util.DeepObject;

@EditorTypes(value={Source.class, Activator.class, ActivatorOf.class, Tagged.class, InstanceOf.class, None.class, Intersecting.class, RandomSubset.class, NearestSubset.class, FarthestSubset.class, Conditional.class, Compound.class, FixedCoord.class, TrimCenter.class, Behavior.class, Excluding.class, IntersectingMask.class, Randomized.class, TargetBornTranslation.class, MultipleTagged.class, CollisionMask.class})
@Strippable
public abstract class TargetConfig
extends DeepObject
implements Exportable,
Streamable {
    public abstract String getLogicClassName();

    public void invalidate() {
    }

    public static class CollisionMask
    extends TargetConfig {
        @Editable(editor="mask", mode="collision", hgroup="a")
        public int collisionMask = 1;
        @Editable
        public TargetConfig target = new Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$CollisionMask";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class Randomized
    extends TargetConfig {
        @Editable
        public TargetConfig target = new Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$Randomized";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class Excluding
    extends TargetConfig {
        @Editable
        public TargetConfig target = new Source();
        @Editable
        public TargetConfig excluding = new Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$Excluding";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
            this.excluding.invalidate();
        }
    }

    public static class Behavior
    extends TargetConfig {
        @Editable
        public TargetConfig target = new Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$Behavior";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class Compound
    extends TargetConfig {
        @Editable
        public TargetConfig[] targets = new TargetConfig[0];

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$Compound";
        }

        @Override
        public void invalidate() {
            for (TargetConfig target : this.targets) {
                target.invalidate();
            }
        }
    }

    public static class Conditional
    extends TargetConfig {
        @Editable
        public ConditionConfig condition = new ConditionConfig.Tagged();
        @Editable
        public TargetConfig target = new Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$Conditional";
        }

        @Override
        public void invalidate() {
            this.condition.invalidate();
            this.target.invalidate();
        }
    }

    public static class FarthestSubset
    extends DistanceSubset {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$FarthestSubset";
        }
    }

    public static class NearestSubset
    extends DistanceSubset {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$NearestSubset";
        }
    }

    public static abstract class DistanceSubset
    extends Subset {
        @Editable
        public TargetConfig location = new Source();

        @Override
        public void invalidate() {
            super.invalidate();
            this.location.invalidate();
        }
    }

    public static class RandomSubset
    extends Subset {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$RandomSubset";
        }
    }

    public static abstract class Subset
    extends TargetConfig {
        @Editable(min=0.0, hgroup="a")
        public int size = 1;
        @Editable(hgroup="a")
        public boolean lockTarget;
        @Editable
        public TargetConfig target = new Source();

        @Override
        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class RandomTransform
    extends TargetConfig {
        @Editable
        public float radius;
        @Editable
        public int number;

        @Override
        public String getLogicClassName() {
            return null;
        }
    }

    public static class IntersectingMask
    extends TargetConfig {
        @Editable(editor="mask", mode="collision", hgroup="a")
        public int collisionMask = 1;
        @Editable(hgroup="a")
        public boolean includeDead = false;
        @Editable(hgroup="b", nullable=true)
        public ConditionConfig condition = new ConditionConfig.Always();
        @Editable
        public RegionConfig region = new RegionConfig.Default();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$IntersectingMask";
        }

        @Override
        public void invalidate() {
            this.region.invalidate();
        }
    }

    public static class Intersecting
    extends TargetConfig {
        @Editable(hgroup="a")
        public boolean actors = false;
        @Editable(hgroup="a")
        public boolean entries = false;
        @Editable(hgroup="a")
        public boolean includeNotAlive = false;
        @Editable(hgroup="a", tooltip="shap contains target translation")
        public boolean contains = false;
        @Editable(hgroup="b", nullable=true)
        public ConditionConfig actorCondition = new ConditionConfig.Always();
        @Editable(hgroup="c", nullable=true)
        public ConditionConfig entryCondition = new ConditionConfig.Always();
        @Editable
        public RegionConfig region = new RegionConfig.Default();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$Intersecting";
        }

        @Override
        public void invalidate() {
            this.region.invalidate();
        }
    }

    public static class InstanceOf
    extends TargetConfig {
        @Editable
        public String logicClass = "com.threerings.tudey.server.logic.PawnLogic";

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$InstanceOf";
        }
    }

    public static class MultipleTagged
    extends TargetConfig {
        @Editable
        public String[] tags = new String[0];

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$MultipleTagged";
        }
    }

    public static class Tagged
    extends TargetConfig {
        @Editable
        public String tag = "";

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$Tagged";
        }
    }

    public static class ActivatorOf
    extends TargetConfig {
        @Editable
        public TargetConfig target = new Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$ActivatorOf";
        }

        @Override
        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class Activator
    extends TargetConfig {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$Activator";
        }
    }

    public static class TargetBornTranslation
    extends TargetConfig {
        @Editable
        public TargetConfig target = new Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$TargetBornTranslation";
        }
    }

    public static class FixedCoord
    extends TargetConfig {
        @Editable(hgroup="a")
        public int x = 0;
        @Editable(hgroup="a")
        public int y = 0;

        public FixedCoord(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public FixedCoord() {
        }

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$FixedCoord";
        }

        @Override
        public int hashCode() {
            return this.x ^ this.y;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof FixedCoord)) {
                return false;
            }
            FixedCoord ovec = (FixedCoord)other;
            return this.x == ovec.x && this.y == ovec.y;
        }
    }

    public static class TrimCenter
    extends TargetConfig {
        @Editable
        public TargetConfig target = new Source();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$TrimCenter";
        }
    }

    public static class None
    extends TargetConfig {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$None";
        }
    }

    public static class Source
    extends TargetConfig {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.TargetLogic$Source";
        }
    }
}

