/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.math.Transform3D;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.util.Preloadable;
import com.threerings.opengl.util.PreloadableSet;
import com.threerings.tudey.client.sprite.GlobalSprite;
import com.threerings.tudey.config.CameraConfig;
import com.threerings.tudey.config.HandlerConfig;
import com.threerings.tudey.config.TagConfig;
import com.threerings.tudey.util.TudeyContext;
import com.threerings.util.DeepObject;

public class SceneGlobalConfig
extends ParameterizedConfig {
    public static final Original NULL_ORIGINAL = new EnvironmentModel();
    @Editable
    public Implementation implementation = new EnvironmentModel();

    public Original getOriginal(ConfigManager cfgmgr) {
        return this.implementation.getOriginal(cfgmgr);
    }

    public GlobalSprite.Implementation getSpriteImplementation(TudeyContext ctx, Scope scope, GlobalSprite.Implementation impl) {
        return this.implementation.getSpriteImplementation(ctx, scope, impl);
    }

    @Override
    protected void fireConfigUpdated() {
        this.implementation.invalidate();
        super.fireConfigUpdated();
    }

    @Override
    protected void getUpdateReferences(ConfigReferenceSet refs) {
        this.implementation.getUpdateReferences(refs);
    }

    public static class Derived
    extends Implementation {
        @Editable(nullable=true)
        public ConfigReference<SceneGlobalConfig> sceneGlobal;

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            refs.add(SceneGlobalConfig.class, this.sceneGlobal);
        }

        @Override
        public Original getOriginal(ConfigManager cfgmgr) {
            SceneGlobalConfig config = cfgmgr.getConfig(SceneGlobalConfig.class, this.sceneGlobal);
            return config == null ? null : config.getOriginal(cfgmgr);
        }

        @Override
        public GlobalSprite.Implementation getSpriteImplementation(TudeyContext ctx, Scope scope, GlobalSprite.Implementation impl) {
            SceneGlobalConfig config = ctx.getConfigManager().getConfig(SceneGlobalConfig.class, this.sceneGlobal);
            return config == null ? null : config.getSpriteImplementation(ctx, scope, impl);
        }
    }

    public static class Camera
    extends Original {
        @Editable
        public CameraConfig camera = new CameraConfig();
        @Editable
        public CameraConfig[] cameras = new CameraConfig[0];

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.EntryLogic$Camera";
        }

        @Override
        public GlobalSprite.Implementation getSpriteImplementation(TudeyContext ctx, Scope scope, GlobalSprite.Implementation impl) {
            if (impl instanceof GlobalSprite.Camera) {
                ((GlobalSprite.Camera)impl).setConfig(this);
            } else {
                impl = new GlobalSprite.Camera(ctx, scope, this);
            }
            return impl;
        }
    }

    public static class EnvironmentModel
    extends Original {
        @Editable(nullable=true)
        public ConfigReference<ModelConfig> model;
        @Editable(step=0.01)
        public Transform3D transform = new Transform3D();

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            super.getPreloads(cfgmgr, preloads);
            preloads.add(new Preloadable.Model(this.model));
        }

        @Override
        public GlobalSprite.Implementation getSpriteImplementation(TudeyContext ctx, Scope scope, GlobalSprite.Implementation impl) {
            if (impl instanceof GlobalSprite.EnvironmentModel) {
                ((GlobalSprite.EnvironmentModel)impl).setConfig(this);
            } else {
                impl = new GlobalSprite.EnvironmentModel(ctx, scope, this);
            }
            return impl;
        }
    }

    public static abstract class Original
    extends Implementation {
        @Editable
        public TagConfig tags = new TagConfig();
        @Editable
        public HandlerConfig[] handlers = new HandlerConfig[0];

        public String getLogicClassName() {
            return this.tags.getLength() == 0 && this.handlers.length == 0 ? null : "com.threerings.tudey.server.logic.EntryLogic";
        }

        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            for (HandlerConfig handler : this.handlers) {
                handler.getPreloads(cfgmgr, preloads);
            }
        }

        @Override
        public Original getOriginal(ConfigManager cfgmgr) {
            return this;
        }

        @Override
        public void invalidate() {
            for (HandlerConfig handler : this.handlers) {
                handler.invalidate();
            }
        }
    }

    @EditorTypes(value={EnvironmentModel.class, Camera.class, Derived.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable {
        public void getUpdateReferences(ConfigReferenceSet refs) {
        }

        public abstract Original getOriginal(ConfigManager var1);

        public abstract GlobalSprite.Implementation getSpriteImplementation(TudeyContext var1, Scope var2, GlobalSprite.Implementation var3);

        public void invalidate() {
        }
    }
}

