/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.google.common.base.Objects;
import com.samskivert.util.IntTuple;
import com.samskivert.util.RandomUtil;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.Strippable;
import com.threerings.export.Exportable;
import com.threerings.tudey.config.TileConfig;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import java.util.ArrayList;

@Strippable
public abstract class PaintableConfig
extends ParameterizedConfig {
    public static int createPattern(boolean n, boolean nw, boolean w, boolean sw, boolean s, boolean se, boolean e, boolean ne) {
        return (n ? 1 : 0) | (nw ? 2 : 0) | (w ? 4 : 0) | (sw ? 8 : 0) | (s ? 16 : 0) | (se ? 32 : 0) | (e ? 64 : 0) | (ne ? 128 : 0);
    }

    protected static IntTuple getCaseRotations(Case[] cases, int pattern) {
        for (int ii = 0; ii < cases.length; ++ii) {
            int rotations = cases[ii].getRotations(pattern);
            if (rotations == 0) continue;
            return new IntTuple(ii, rotations);
        }
        return null;
    }

    protected static boolean matchesAny(Case[] cases, TudeySceneModel.TileEntry entry, IntTuple caseRotations, int elevation) {
        return entry != null && (1 << entry.rotation & caseRotations.right) != 0 && PaintableConfig.matchesAny(cases[caseRotations.left].tiles, entry, elevation);
    }

    protected static boolean matchesAny(Tile[] tiles, TudeySceneModel.TileEntry entry, int elevation) {
        if (entry != null) {
            for (Tile tile : tiles) {
                if (!tile.matches(entry, elevation)) continue;
                return true;
            }
        }
        return false;
    }

    protected static TudeySceneModel.TileEntry createRandomEntry(ConfigManager cfgmgr, Tile[] tiles, int maxWidth, int maxHeight, int elevation) {
        return PaintableConfig.createRandomEntry(cfgmgr, tiles, 15, maxWidth, maxHeight, elevation);
    }

    protected static TudeySceneModel.TileEntry createRandomEntry(ConfigManager cfgmgr, Tile[] tiles, int mask, int maxWidth, int maxHeight, int elevation) {
        ArrayList<TileRotation> rotations = new ArrayList<TileRotation>();
        for (Tile tile : tiles) {
            tile.getRotations(cfgmgr, rotations, mask, maxWidth, maxHeight);
        }
        return PaintableConfig.createRandomEntry(rotations, elevation);
    }

    protected static TudeySceneModel.TileEntry createRandomEntry(ArrayList<TileRotation> rotations, int elevation) {
        float tweight = 0.0f;
        int nn = rotations.size();
        for (int ii = 0; ii < nn; ++ii) {
            tweight += rotations.get((int)ii).weight;
        }
        float random = RandomUtil.getFloat((float)tweight);
        tweight = 0.0f;
        int nn2 = rotations.size();
        for (int ii = 0; ii < nn2; ++ii) {
            float f;
            TileRotation rotation = rotations.get(ii);
            tweight += rotation.weight;
            if (!(random < f)) continue;
            return rotation.createEntry(elevation);
        }
        return null;
    }

    protected static class TileRotation {
        public Tile tile;
        public int rotation;
        public int width;
        public int height;
        public float weight;

        public TileRotation(Tile tile, int rotation) {
            this.tile = tile;
            this.rotation = rotation;
        }

        public TudeySceneModel.TileEntry createEntry(int elevation) {
            TudeySceneModel.TileEntry entry = new TudeySceneModel.TileEntry();
            entry.tile = this.tile.tile;
            entry.rotation = this.rotation;
            entry.elevation = elevation + this.tile.elevationOffset;
            return entry;
        }
    }

    public static class Tile
    extends DeepObject
    implements Exportable {
        @Editable(nullable=true)
        public ConfigReference<TileConfig> tile;
        @Editable(hgroup="d")
        public boolean north = true;
        @Editable(hgroup="d")
        public boolean west = true;
        @Editable(hgroup="d")
        public boolean south = true;
        @Editable(hgroup="d")
        public boolean east = true;
        @Editable(hgroup="e")
        public int elevationOffset;
        @Editable(min=0.0, step=0.01, hgroup="e")
        public float weight = 1.0f;
        @DeepOmit
        protected transient TileRotation[] _rotations;

        public boolean matches(TudeySceneModel.TileEntry entry, int elevation) {
            if (!Objects.equal(entry.tile, this.tile) || entry.elevation != elevation + this.elevationOffset) {
                return false;
            }
            switch (entry.rotation) {
                default: {
                    return this.north;
                }
                case 1: {
                    return this.west;
                }
                case 2: {
                    return this.south;
                }
                case 3: 
            }
            return this.east;
        }

        public void getRotations(ConfigManager cfgmgr, ArrayList<TileRotation> rotations, int mask, int maxWidth, int maxHeight) {
            for (TileRotation tile : this.getRotations(cfgmgr)) {
                if ((1 << tile.rotation & mask) == 0 || tile.width > maxWidth || tile.height > maxHeight) continue;
                rotations.add(tile);
            }
        }

        public void invalidate() {
            this._rotations = null;
        }

        protected TileRotation[] getRotations(ConfigManager cfgmgr) {
            if (this._rotations == null) {
                TileConfig.Original original;
                ArrayList<TileRotation> list = new ArrayList<TileRotation>();
                TileConfig config = cfgmgr.getConfig(TileConfig.class, this.tile);
                TileConfig.Original original2 = original = config == null ? null : config.getOriginal(cfgmgr);
                if (original != null) {
                    if (this.north) {
                        list.add(new TileRotation(this, 0));
                    }
                    if (this.west) {
                        list.add(new TileRotation(this, 1));
                    }
                    if (this.south) {
                        list.add(new TileRotation(this, 2));
                    }
                    if (this.east) {
                        list.add(new TileRotation(this, 3));
                    }
                }
                this._rotations = list.toArray(new TileRotation[list.size()]);
                if (this._rotations.length > 0) {
                    float rweight = this.weight / (float)this._rotations.length;
                    for (TileRotation rotation : this._rotations) {
                        rotation.width = original.getWidth(rotation.rotation);
                        rotation.height = original.getHeight(rotation.rotation);
                        rotation.weight = rweight;
                    }
                }
            }
            return this._rotations;
        }
    }

    public static class Case
    extends DeepObject
    implements Exportable {
        @Editable(hgroup="d")
        public boolean n;
        @Editable(hgroup="d")
        public boolean nw;
        @Editable(hgroup="d")
        public boolean w;
        @Editable(hgroup="d")
        public boolean sw;
        @Editable(hgroup="d")
        public boolean s;
        @Editable(hgroup="d")
        public boolean se;
        @Editable(hgroup="d")
        public boolean e;
        @Editable(hgroup="d")
        public boolean ne;
        @Editable(weight=1.0)
        public Tile[] tiles = new Tile[0];
        @DeepOmit
        protected transient int[] _patterns;
        @DeepOmit
        protected transient boolean[] _orientations;

        public void getUpdateReferences(ConfigReferenceSet refs) {
            for (Tile tile : this.tiles) {
                refs.add(TileConfig.class, tile.tile);
            }
        }

        public int getRotations(int pattern) {
            return this.getRotations(this.getPatterns(), pattern);
        }

        public void invalidate() {
            for (Tile tile : this.tiles) {
                tile.invalidate();
            }
            this._patterns = null;
            this._orientations = null;
        }

        protected int getRotations(int[] patterns, int pattern) {
            int rotations = 0;
            boolean[] orientations = this.getOrientations();
            for (int ii = 0; ii < 4; ++ii) {
                int mask;
                if (!orientations[ii] || (pattern & (mask = patterns[ii])) != mask) continue;
                rotations |= 1 << ii;
            }
            return rotations;
        }

        protected int[] getPatterns() {
            if (this._patterns == null) {
                this._patterns = new int[]{PaintableConfig.createPattern(this.n, this.nw, this.w, this.sw, this.s, this.se, this.e, this.ne), PaintableConfig.createPattern(this.e, this.ne, this.n, this.nw, this.w, this.sw, this.s, this.se), PaintableConfig.createPattern(this.s, this.se, this.e, this.ne, this.n, this.nw, this.w, this.sw), PaintableConfig.createPattern(this.w, this.sw, this.s, this.se, this.e, this.ne, this.n, this.nw)};
            }
            return this._patterns;
        }

        protected boolean[] getOrientations() {
            if (this._orientations == null) {
                this._orientations = new boolean[4];
                for (Tile tile : this.tiles) {
                    this._orientations[0] = this._orientations[0] | tile.north;
                    this._orientations[1] = this._orientations[1] | tile.west;
                    this._orientations[2] = this._orientations[2] | tile.south;
                    this._orientations[3] = this._orientations[3] | tile.east;
                }
            }
            return this._orientations;
        }
    }
}

