/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.Strippable;
import com.threerings.export.Exportable;
import com.threerings.io.Streamable;
import com.threerings.math.Transform2D;
import com.threerings.opengl.util.Preloadable;
import com.threerings.opengl.util.PreloadableSet;
import com.threerings.tudey.config.ActionConfig;
import com.threerings.tudey.config.ConditionConfig;
import com.threerings.tudey.config.ParameterizedHandlerConfig;
import com.threerings.tudey.config.TargetConfig;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.shape.config.ShapeConfig;
import com.threerings.util.DeepObject;

@EditorTypes(value={Startup.class, Shutdown.class, Reference.class, Tick.class, Timer.class, WarnTimer.class, Signal.class, SignalStart.class, SignalStop.class, Intersection.class, IntersectionStart.class, IntersectionStop.class, ThresholdIntersectionCount.class, Request.class, ActorAdded.class, ActorRemoved.class, BodyEntered.class, BodyLeft.class, TaggedActorRemoved.class, TaggedActorAdded.class, VariableChanged.class, Derived.class, SignalTimer.class})
public abstract class HandlerConfig
extends DeepObject
implements Exportable,
Streamable {
    public abstract String getLogicClassName();

    public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
    }

    public void invalidate() {
    }

    public static abstract class ActionHandlerConfig
    extends HandlerConfig {
        @Editable(weight=1.0)
        public ActionConfig action = new ActionConfig.SpawnActor();

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            if (this.action != null) {
                this.action.getPreloads(cfgmgr, preloads);
            }
        }

        @Override
        public void invalidate() {
            if (this.action != null) {
                this.action.invalidate();
            }
        }
    }

    public static class TransformedShape
    extends IntersectionShape {
        @Editable
        public ShapeConfig shape = new ShapeConfig.Point();

        @Override
        public Shape getShape(Shape source, Transform2D transform, Shape result) {
            return this.shape.getShape().transform(transform, result);
        }

        @Override
        public void invalidate() {
            this.shape.invalidate();
        }
    }

    public static class DefaultShape
    extends IntersectionShape {
        @Editable(step=0.01)
        public float expansion;

        @Override
        public Shape getShape(Shape source, Transform2D transform, Shape result) {
            return source == null || this.expansion == 0.0f ? source : source.expand(this.expansion, result);
        }
    }

    @EditorTypes(value={DefaultShape.class, TransformedShape.class})
    @Strippable
    public static abstract class IntersectionShape
    extends DeepObject
    implements Exportable {
        public abstract Shape getShape(Shape var1, Transform2D var2, Shape var3);

        public void invalidate() {
        }
    }

    public static class VariableChanged
    extends ActionHandlerConfig {
        @Editable(hgroup="n", nullable=true)
        @Strippable
        public String name = "";

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.HandlerLogic$VariableChanged";
        }
    }

    public static class BodyLeft
    extends ActionHandlerConfig {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.HandlerLogic$BodyLeft";
        }
    }

    public static class BodyEntered
    extends ActionHandlerConfig {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.HandlerLogic$BodyEntered";
        }
    }

    public static class TaggedActorRemoved
    extends TaggedActorAction {
        @Editable
        @Strippable
        public boolean all = true;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.HandlerLogic$TaggedActorRemoved";
        }
    }

    public static abstract class TaggedActorAdded
    extends TaggedActorAction {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.HandlerLogic$TaggedActorAdded";
        }
    }

    public static abstract class TaggedActorAction
    extends ActionHandlerConfig {
        @Editable
        @Strippable
        public String[] taggs = new String[0];
    }

    public static class ActorRemoved
    extends BaseActorObserver {
        @Editable
        @Strippable
        public boolean all = true;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.HandlerLogic$ActorRemoved";
        }
    }

    public static class ActorAdded
    extends BaseActorObserver {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.HandlerLogic$ActorAdded";
        }
    }

    public static abstract class BaseActorObserver
    extends ActionHandlerConfig {
        @Editable
        public TargetConfig target = new TargetConfig.Tagged();

        @Override
        public void invalidate() {
            this.target.invalidate();
        }
    }

    public static class Request
    extends ActionHandlerConfig {
        @Editable
        @Strippable
        public String name = "";

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.HandlerLogic$Request";
        }
    }

    public static class ThresholdIntersectionCount
    extends BaseIntersectionCount {
        @Editable(min=0.0)
        @Strippable
        public int threshold;
        @Editable(nullable=true, weight=2.0)
        public ActionConfig underAction;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.HandlerLogic$ThresholdIntersectionCount";
        }

        @Override
        public void invalidate() {
            super.invalidate();
            if (this.underAction != null) {
                this.underAction.invalidate();
            }
        }

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            super.getPreloads(cfgmgr, preloads);
            if (this.underAction != null) {
                this.underAction.getPreloads(cfgmgr, preloads);
            }
        }
    }

    public static abstract class BaseIntersectionCount
    extends BaseIntersection {
        @Editable(editor="mask", mode="collision")
        @Strippable
        public int mask = 65535;
        @Editable
        public ConditionConfig condition = new ConditionConfig.InstanceOf();

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            super.getPreloads(cfgmgr, preloads);
            this.condition.getPreloads(cfgmgr, preloads);
        }
    }

    public static class IntersectionStop
    extends BaseIntersection {
        @Editable(editor="mask", mode="collision")
        @Strippable
        public int mask = 65535;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.HandlerLogic$IntersectionStop";
        }
    }

    public static class IntersectionStart
    extends BaseIntersection {
        @Editable(editor="mask", mode="collision")
        @Strippable
        public int mask = 65535;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.HandlerLogic$IntersectionStart";
        }
    }

    public static class Intersection
    extends BaseIntersection {
        @Editable(editor="mask", mode="collision", hgroup="m")
        @Strippable
        public int mask = 65535;
        @Editable(min=0.0, step=0.1, hgroup="m")
        @Strippable
        public float refractoryPeriod;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.HandlerLogic$Intersection";
        }
    }

    public static abstract class BaseIntersection
    extends ActionHandlerConfig {
        @Editable
        public IntersectionShape shape = new DefaultShape();

        @Override
        public void invalidate() {
            super.invalidate();
            this.shape.invalidate();
        }
    }

    public static class SignalStop
    extends ActionHandlerConfig {
        @Editable
        @Strippable
        public String name = "";

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.HandlerLogic$SignalStop";
        }
    }

    public static class SignalTimer
    extends ActionHandlerConfig {
        @Editable(hgroup="a")
        @Strippable
        public String start = "";
        @Editable(hgroup="a")
        @Strippable
        public String stop = "";
        @Strippable
        @Editable(hgroup="a")
        public boolean onStart = false;
        @Editable(step=1.0, hgroup="i")
        public int delay = 0;
        @Editable(min=0.0, step=1.0, hgroup="i")
        public int interval = 1;
        @Editable(min=0.0, hgroup="i")
        @Strippable
        public int limit;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.HandlerLogic$SignalTimer";
        }
    }

    public static class SignalStart
    extends ActionHandlerConfig {
        @Editable
        @Strippable
        public String name = "";

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.HandlerLogic$SignalStart";
        }
    }

    public static class Signal
    extends ActionHandlerConfig {
        @Editable(hgroup="n")
        @Strippable
        public String name = "";
        @Editable(min=0.0, step=0.1, hgroup="n")
        @Strippable
        public float refractoryPeriod;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.HandlerLogic$Signal";
        }
    }

    public static class WarnTimer
    extends Timer {
        @Editable(min=0.0, step=0.1)
        @Strippable
        public float warn = 0.0f;
        @Editable(nullable=true)
        @Strippable
        public ActionConfig warnAction;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.HandlerLogic$WarnTimer";
        }
    }

    public static class Timer
    extends ActionHandlerConfig {
        @Editable(min=0.001, step=0.1, hgroup="i")
        @Strippable
        public float interval = 1.0f;
        @Strippable
        @Editable(hgroup="i")
        public boolean onStart = false;
        @Editable(step=0.1, hgroup="i")
        public float offset = 0.0f;
        @Editable(min=0.0, hgroup="i")
        @Strippable
        public int limit;

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.HandlerLogic$Timer";
        }
    }

    public static class Tick
    extends ActionHandlerConfig {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.HandlerLogic$Tick";
        }
    }

    public static class Reference
    extends HandlerConfig {
        @Editable(nullable=true)
        public ConfigReference<ParameterizedHandlerConfig> handler;

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            if (preloads.add(new Preloadable.Config(ParameterizedHandlerConfig.class, this.handler))) {
                ParameterizedHandlerConfig.Original original;
                ParameterizedHandlerConfig config = cfgmgr.getConfig(ParameterizedHandlerConfig.class, this.handler);
                ParameterizedHandlerConfig.Original original2 = original = config == null ? null : config.getOriginal(cfgmgr);
                if (original != null) {
                    original.getPreloads(cfgmgr, preloads);
                }
            }
        }

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.HandlerLogic$Reference";
        }
    }

    public static class Shutdown
    extends ActionHandlerConfig {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.HandlerLogic$Shutdown";
        }
    }

    public static class Startup
    extends ActionHandlerConfig {
        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.HandlerLogic$Startup";
        }
    }

    public static class Derived
    extends HandlerConfig {
        @Editable(editor="getPath")
        public DerivedObject derived = new DerivedObject();

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.HandlerLogic$Derived";
        }

        @Override
        public void invalidate() {
            super.invalidate();
            if (this.derived.handlers != null) {
                for (HandlerConfig handler : this.derived.handlers) {
                    handler.invalidate();
                }
            }
        }

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            super.getPreloads(cfgmgr, preloads);
            if (this.derived.handlers != null) {
                for (HandlerConfig handler : this.derived.handlers) {
                    handler.getPreloads(cfgmgr, preloads);
                }
            }
        }
    }

    public static class DerivedObject
    extends DeepObject
    implements Cloneable,
    Exportable {
        @Editable(nullable=true)
        public HandlerConfig[] handlers = null;
    }
}

