/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.client.util;

import com.samskivert.util.RunAnywhere;
import com.threerings.math.FloatMath;

public class TimeSmoother {
    protected long _delta;
    protected long _tdelta;
    protected long _dstamp;
    protected static final float CONVERGENCE_RATE = FloatMath.log(0.5f) / 250.0f;

    public TimeSmoother(int time) {
        this._delta = this._tdelta = (long)time - RunAnywhere.currentTimeMillis();
    }

    public void update(int time) {
        this._dstamp = RunAnywhere.currentTimeMillis();
        this._tdelta = (long)time - this._dstamp;
    }

    public int getTime() {
        long now = RunAnywhere.currentTimeMillis();
        if (this._delta != this._tdelta && now != this._dstamp) {
            long elapsed = now - this._dstamp;
            float pct = 1.0f - FloatMath.exp(CONVERGENCE_RATE * (float)elapsed);
            long diff = (long)((float)(this._tdelta - this._delta) * pct);
            if (diff == 0L) {
                diff = this._tdelta < this._delta ? -1L : 1L;
            }
            this._delta += Math.max(-elapsed, diff);
            this._dstamp = now;
        }
        return (int)(now + this._delta);
    }
}

