/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.client.util;

import com.threerings.math.Box;
import com.threerings.math.Plane;
import com.threerings.math.Ray3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.DisplayList;
import com.threerings.opengl.renderer.state.ColorState;
import com.threerings.opengl.renderer.state.LineState;
import com.threerings.opengl.renderer.state.PointState;
import com.threerings.opengl.renderer.state.RenderState;
import com.threerings.opengl.scene.SimpleSceneElement;
import com.threerings.opengl.util.GlContext;
import com.threerings.tudey.shape.Point;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.shape.config.ShapeConfig;

public class ShapeConfigElement
extends SimpleSceneElement {
    protected Box _localBounds;
    protected DisplayList _list;
    protected Shape _shape;

    public ShapeConfigElement(GlContext ctx) {
        super(ctx);
    }

    public void setConfig(ShapeConfig config, boolean outline) {
        this._localBounds = config.getBounds();
        this._list = config.getList(this._ctx, outline);
        this._shape = outline ? null : config.getShape();
        this.updateBounds();
    }

    public Color4f getColor() {
        ColorState cstate = (ColorState)this._batch.getStates()[2];
        return cstate.getColor();
    }

    @Override
    protected RenderState[] createStates() {
        RenderState[] states = super.createStates();
        states[2] = new ColorState();
        states[8] = LineState.getInstance(3.0f);
        states[10] = PointState.getInstance(3.0f);
        return states;
    }

    @Override
    public boolean getIntersection(Ray3D ray, Vector3f result) {
        if (this._shape == null || !this._bounds.intersects(ray)) {
            return false;
        }
        Vector3f pt = new Vector3f();
        if (!Plane.XY_PLANE.getIntersection(ray.transform(this._transform.invert()), pt)) {
            return false;
        }
        if (!this._shape.intersects(new Point(pt.x, pt.y))) {
            return false;
        }
        this._transform.transformPointLocal(result.set(pt));
        return true;
    }

    @Override
    protected Box getLocalBounds() {
        return this._localBounds;
    }

    @Override
    protected void draw() {
        this._ctx.getRenderer().setMatrixMode(5888);
        this._list.call();
    }
}

