/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.client.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.threerings.config.ConfigManager;
import com.threerings.crowd.client.PlaceView;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.math.FloatMath;
import com.threerings.math.Rect;
import com.threerings.math.Vector2f;
import com.threerings.opengl.gui.Image;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.renderer.Texture2D;
import com.threerings.opengl.renderer.TextureUnit;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.config.AreaConfig;
import com.threerings.tudey.config.PlaceableConfig;
import com.threerings.tudey.config.TileConfig;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.shape.Polygon;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.space.SpaceElement;
import com.threerings.tudey.util.Coord;
import com.threerings.tudey.util.CoordIntMap;
import com.threerings.tudey.util.TudeyContext;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.GL11;

public class SceneMap
implements PlaceView,
TudeySceneModel.Observer {
    private final int EMPTY_WIDTH = 124;
    private final int EMPTY_HEIGHT = 90;
    private Vector2f _trans;
    private List<Polygon> _mapRegions = new ArrayList<Polygon>();
    protected Map<Coord, ByteBuffer> _buffers = Maps.newHashMap();
    protected TudeyContext _ctx;
    protected TudeySceneView _view;
    protected TudeySceneModel _sceneModel;
    protected CoordIntMap _types = new CoordIntMap(3, -3);
    protected Set<Coord> _missing = Sets.newHashSet();
    protected Map<Coord, Texture2D> _textures = Maps.newHashMap();
    protected Color4f _floor;
    protected Color4f _wall;
    protected Color4f _walkable;
    protected int _flagMask = -1;
    protected TextureUnit[] _unmasked = new TextureUnit[]{new TextureUnit()};
    protected TextureUnit[] _masked = new TextureUnit[]{new TextureUnit(), new TextureUnit()};
    protected Coord _coord = new Coord();
    protected Set<Coord> _entrances = Sets.newHashSet();
    protected Set<Coord> _traversable = Sets.newHashSet();
    protected Rectangle _region = new Rectangle();
    protected Polygon _quad = new Polygon(4);
    protected List<SpaceElement> _elements = Lists.newArrayList();
    protected static final int SUB_DIVISION = 3;
    protected static final byte[] EMPTY_COLOR = new byte[]{0, 0, 0, 0};
    protected static final int NULL_VALUE = -3;
    protected Rect _rect = null;
    protected static final int[] XS = new int[]{1, 0, -1, 0};
    protected static final int[] YS = new int[]{0, -1, 0, 1};

    public SceneMap(TudeyContext ctx, TudeySceneView view, Vector2f trans) {
        this._ctx = ctx;
        this._view = view;
        this._trans = trans;
        this.setColors(Color4f.GRAY, Color4f.WHITE, Color4f.RED);
    }

    public void setCenter(Vector2f trans) {
        this._trans = trans;
    }

    public void setColors(Color4f floor, Color4f wall, Color4f walkable) {
        this._floor = floor;
        this._wall = wall;
        this._walkable = walkable;
    }

    public void setCollisionFlagMask(int flagMask) {
        this._flagMask = flagMask;
    }

    public void rebuildMap() {
        this.clearMap();
        this.build();
    }

    public void setSceneModel(TudeySceneModel sceneModel) {
        if (this._sceneModel != null) {
            this._sceneModel.removeObserver(this);
        }
        this._sceneModel = sceneModel;
        if (this._sceneModel != null) {
            this._sceneModel.addObserver(this);
        }
        this.rebuildMap();
    }

    public void render(float sx, float sy, float swidth, float sheight, int tx, int ty, int twidth, int theight, float alpha, Image mask) {
        Renderer renderer = this._ctx.getRenderer();
        renderer.setColorState(alpha, alpha, alpha, alpha);
        float mwidth = 1.0f;
        float mheight = 1.0f;
        if (mask != null) {
            Texture2D mtex = mask.getTexture(renderer);
            this._masked[1].setTexture(mtex);
            mwidth = (float)mask.getWidth() / (float)mtex.getWidth();
            mheight = (float)mask.getHeight() / (float)mtex.getHeight();
        }
        for (Map.Entry<Coord, Texture2D> entry : this._textures.entrySet()) {
            Texture2D texture = entry.getValue();
            Coord coord = entry.getKey();
            float bx1 = coord.x << this.getBufferPot();
            float bx2 = coord.x + 1 << this.getBufferPot();
            float by1 = coord.y << this.getBufferPot();
            float by2 = coord.y + 1 << this.getBufferPot();
            float ix1 = Math.max(sx, bx1);
            float ix2 = Math.min(sx + swidth, bx2);
            float iy1 = Math.max(sy, by1);
            float iy2 = Math.min(sy + sheight, by2);
            float ls = (ix1 - bx1) / (float)this.getBufferWidth();
            float us = (ix2 - bx1) / (float)this.getBufferWidth();
            float lt = (iy1 - by1) / (float)this.getBufferWidth();
            float ut = (iy2 - by1) / (float)this.getBufferWidth();
            float lx = (ix1 - sx) / swidth;
            float ux = (ix2 - sx) / swidth;
            float ly = (iy1 - sy) / sheight;
            float uy = (iy2 - sy) / sheight;
            float mls = lx * mwidth;
            float mus = ux * mwidth;
            float mlt = ly * mheight;
            float mut = uy * mheight;
            lx = lx * (float)twidth + (float)tx - this._trans.x;
            ux = ux * (float)twidth + (float)tx - this._trans.x;
            ly = ly * (float)theight + (float)ty - this._trans.y;
            uy = uy * (float)theight + (float)ty - this._trans.y;
            TextureUnit[] units = mask == null ? this._unmasked : this._masked;
            units[0].setTexture(texture);
            renderer.setTextureState(units);
            GL11.glBegin((int)7);
            if (mask == null) {
                GL11.glTexCoord2f((float)ls, (float)lt);
                GL11.glVertex2f((float)lx, (float)ly);
                GL11.glTexCoord2f((float)us, (float)lt);
                GL11.glVertex2f((float)ux, (float)ly);
                GL11.glTexCoord2f((float)us, (float)ut);
                GL11.glVertex2f((float)ux, (float)uy);
                GL11.glTexCoord2f((float)ls, (float)ut);
                GL11.glVertex2f((float)lx, (float)uy);
            } else {
                GL11.glTexCoord2f((float)ls, (float)lt);
                ARBMultitexture.glMultiTexCoord2fARB((int)33985, (float)mls, (float)mlt);
                GL11.glVertex2f((float)lx, (float)ly);
                GL11.glTexCoord2f((float)us, (float)lt);
                ARBMultitexture.glMultiTexCoord2fARB((int)33985, (float)mus, (float)mlt);
                GL11.glVertex2f((float)ux, (float)ly);
                GL11.glTexCoord2f((float)us, (float)ut);
                ARBMultitexture.glMultiTexCoord2fARB((int)33985, (float)mus, (float)mut);
                GL11.glVertex2f((float)ux, (float)uy);
                GL11.glTexCoord2f((float)ls, (float)ut);
                ARBMultitexture.glMultiTexCoord2fARB((int)33985, (float)mls, (float)mut);
                GL11.glVertex2f((float)lx, (float)uy);
            }
            GL11.glEnd();
            renderer.setMatrixMode(5888);
        }
    }

    public void addEntrance(int x, int y) {
        this._entrances.add(new Coord(x, y));
    }

    public void updateLocations(Set<Coord> coords) {
        for (Coord coord : coords) {
            this.updateBuffer(coord);
        }
        this.createTextures();
    }

    public void clearMap() {
        this._buffers.clear();
        this._textures.clear();
        this._traversable.clear();
        this._missing.clear();
        this._types.clear();
        this._entrances.clear();
    }

    public void populateTraversable() {
        if (this._entrances.isEmpty()) {
            return;
        }
        this._traversable.clear();
        ArrayDeque<Coord> queue = new ArrayDeque<Coord>();
        queue.addAll(this._entrances);
        Coord coord = (Coord)queue.poll();
        while (coord != null) {
            for (int ii = 0; ii < 4; ++ii) {
                Coord newCoord = new Coord(coord.x + XS[ii], coord.y + YS[ii]);
                Integer flag = this._types.get(newCoord);
                if (flag == null) {
                    this.logMissingTile(newCoord);
                    continue;
                }
                if (!flag.equals(0) || !this._traversable.add(newCoord)) continue;
                queue.add(newCoord);
            }
            coord = (Coord)queue.poll();
        }
    }

    private void fillMapEmptySpace() {
        int x = (int)this._rect.getMinimumExtent().x;
        while ((float)x <= this._rect.getMaximumExtent().x) {
            int y = (int)this._rect.getMinimumExtent().y;
            while ((float)y <= this._rect.getMaximumExtent().y) {
                if (!this._types.containsKey(x, y)) {
                    if (this._mapRegions.size() == 0) {
                        this._types.put(x, y, 0);
                    } else {
                        for (Polygon p : this._mapRegions) {
                            if (!p.contains(x, y)) continue;
                            this._types.put(x, y, 0);
                        }
                    }
                }
                ++y;
            }
            ++x;
        }
    }

    public void willEnterPlace(PlaceObject plobj) {
        this._sceneModel = (TudeySceneModel)this._ctx.getSceneDirector().getScene().getSceneModel();
        this._sceneModel.addObserver(this);
        this.build();
    }

    public void didLeavePlace(PlaceObject plobj) {
        this._sceneModel.removeObserver(this);
        this.clearMap();
    }

    @Override
    public void entryAdded(TudeySceneModel.Entry entry) {
        this.addEntry(entry);
        this.updateLocations(this._types.keySet());
        this.populateTraversable();
    }

    @Override
    public void entryUpdated(TudeySceneModel.Entry oentry, TudeySceneModel.Entry nentry) {
        this.removeEntry(oentry);
        this.addEntry(nentry);
        this.updateLocations(this._types.keySet());
        this.populateTraversable();
    }

    @Override
    public void entryRemoved(TudeySceneModel.Entry oentry) {
        this.removeEntry(oentry);
        this.updateLocations(this._types.keySet());
        this.populateTraversable();
    }

    public Set<Coord> getMissing() {
        return this._missing;
    }

    protected void logMissingTile(Coord coord) {
        this._missing.add(coord);
    }

    protected int getBufferPot() {
        return 6;
    }

    protected int getBufferWidth() {
        return 1 << this.getBufferPot();
    }

    protected int getBufferSize() {
        return this.getBufferWidth() * this.getBufferWidth() * 4;
    }

    protected void build() {
        Iterable<TudeySceneModel.AreaEntry> _mapRegionIt = this._sceneModel.getEntries(TudeySceneModel.AreaEntry.class);
        for (TudeySceneModel.AreaEntry areaEntry : _mapRegionIt) {
            if (!(areaEntry.getConfig(this._ctx.getConfigManager()) instanceof AreaConfig.MapRegion)) continue;
            Vector2f[] v = new Vector2f[areaEntry.vertices.length];
            for (int i = 0; i < areaEntry.vertices.length; ++i) {
                v[i] = new Vector2f(areaEntry.vertices[i].x, areaEntry.vertices[i].y);
            }
            this._mapRegions.add(new Polygon(v));
        }
        for (TudeySceneModel.Entry entry : this._sceneModel.getEntries()) {
            this.addEntry(entry);
        }
        this.populateTraversable();
        this.fillMapEmptySpace();
        this.updateLocations(this._types.keySet());
    }

    protected float getAlphaAtLocation(Coord coord) {
        return 1.0f;
    }

    protected void addEntry(TudeySceneModel.Entry entry) {
        Shape shape;
        if (entry instanceof TudeySceneModel.TileEntry) {
            int yy;
            TudeySceneModel.TileEntry tentry = (TudeySceneModel.TileEntry)entry;
            TileConfig.Original config = tentry.getConfig(this._sceneModel.getConfigManager());
            tentry.getRegion(config, this._region);
            int yymax = yy + this._region.height;
            for (yy = this._region.y; yy < yymax; ++yy) {
                int xx;
                int xxmax = xx + this._region.width;
                for (xx = this._region.x; xx < xxmax; ++xx) {
                    int flags = this._flagMask & tentry.getCollisionFlags(config, xx, yy);
                    int type = Math.max(this._types.get(xx, yy), flags);
                    this._types.put(xx, yy, type);
                    this.setRect(xx, yy);
                }
            }
            return;
        }
        int flags = this._flagMask & entry.getCollisionFlags(this._sceneModel.getConfigManager());
        if (entry instanceof TudeySceneModel.PlaceableEntry) {
            TudeySceneModel.PlaceableEntry pentry = (TudeySceneModel.PlaceableEntry)entry;
            PlaceableConfig.Original config = pentry.getConfig(this._sceneModel.getConfigManager());
            if (config.defaultEntrance || config instanceof PlaceableConfig.Marker && ((PlaceableConfig.Marker)config).walkableMarker) {
                Vector2f trans = pentry.getTranslation(this._sceneModel.getConfigManager());
                this.addEntrance((int)trans.x, (int)trans.y);
            }
            if (flags == 0 && !config.floorTile) {
                return;
            }
        } else if (flags == 0) {
            return;
        }
        if ((shape = entry.createShape(this._sceneModel.getConfigManager())) == null) {
            return;
        }
        Rect bounds = shape.getBounds();
        Vector2f min = bounds.getMinimumExtent();
        Vector2f max = bounds.getMaximumExtent();
        int minx = FloatMath.ifloor(min.x);
        int maxx = FloatMath.ifloor(max.x);
        int miny = FloatMath.ifloor(min.y);
        int maxy = FloatMath.ifloor(max.y);
        for (int yy = miny; yy <= maxy; ++yy) {
            for (int xx = minx; xx <= maxx; ++xx) {
                if (!this.intersects(xx, yy, shape)) continue;
                int type = Math.max(this._types.get(xx, yy), flags);
                this._types.put(xx, yy, type);
                this.setRect(xx, yy);
            }
        }
    }

    private void setRect(int xx, int yy) {
        if (this._rect == null) {
            this._rect = new Rect(new Vector2f(xx, yy), new Vector2f(xx, yy));
        } else {
            if (this._rect.getMaximumExtent().x < (float)xx) {
                this._rect.getMaximumExtent().x = xx + 124;
            }
            if (this._rect.getMaximumExtent().y < (float)yy) {
                this._rect.getMaximumExtent().y = yy + 90;
            }
            if (this._rect.getMinimumExtent().x > (float)xx) {
                this._rect.getMinimumExtent().x = xx - 124;
            }
            if (this._rect.getMinimumExtent().y > (float)yy) {
                this._rect.getMinimumExtent().y = yy - 90;
            }
        }
    }

    protected void removeEntry(TudeySceneModel.Entry entry) {
        if (entry instanceof TudeySceneModel.TileEntry) {
            int yy;
            TudeySceneModel.TileEntry tentry = (TudeySceneModel.TileEntry)entry;
            TileConfig.Original config = tentry.getConfig(this._sceneModel.getConfigManager());
            tentry.getRegion(config, this._region);
            int yymax = yy + this._region.height;
            for (yy = this._region.y; yy < yymax; ++yy) {
                int xx;
                int xxmax = xx + this._region.width;
                for (xx = this._region.x; xx < xxmax; ++xx) {
                    this.updateQuad(xx, yy);
                    this.update(xx, yy);
                }
            }
            return;
        }
        int flags = this._flagMask & entry.getCollisionFlags(this._sceneModel.getConfigManager());
        if (flags == 0) {
            return;
        }
        Shape shape = entry.createShape(this._sceneModel.getConfigManager());
        if (shape == null) {
            return;
        }
        Rect bounds = shape.getBounds();
        Vector2f min = bounds.getMinimumExtent();
        Vector2f max = bounds.getMaximumExtent();
        int minx = FloatMath.ifloor(min.x);
        int maxx = FloatMath.ifloor(max.x);
        int miny = FloatMath.ifloor(min.y);
        int maxy = FloatMath.ifloor(max.y);
        for (int yy = miny; yy <= maxy; ++yy) {
            for (int xx = minx; xx <= maxx; ++xx) {
                if (!this.intersects(xx, yy, shape)) continue;
                this.updateQuad(xx, yy);
                this.update(xx, yy);
            }
        }
    }

    protected void update(int x, int y) {
        int type = -3;
        TudeySceneModel.TileEntry tentry = this._sceneModel.getTileEntry(x, y);
        ConfigManager cfgmgr = this._sceneModel.getConfigManager();
        if (tentry != null) {
            type = tentry.getCollisionFlags(tentry.getConfig(cfgmgr), x, y);
        }
        this._sceneModel.getSpace().getIntersecting(this._quad, this._elements);
        int nn = this._elements.size();
        for (int ii = 0; ii < nn; ++ii) {
            SpaceElement element = this._elements.get(ii);
            int flags = this._flagMask & ((TudeySceneModel.Entry)element.getUserObject()).getCollisionFlags(cfgmgr);
            if (flags == 0) continue;
            type = Math.max(type, flags);
        }
        this._elements.clear();
        this._types.put(x, y, type);
    }

    protected void updateBuffer(Coord coord) {
        int x = coord.x;
        int y = coord.y;
        int tx = (int)Math.floor((float)x / (float)this.getBufferWidth());
        int ty = (int)Math.floor((float)y / (float)this.getBufferWidth());
        int bx = (x % this.getBufferWidth() + this.getBufferWidth()) % this.getBufferWidth();
        int by = (y % this.getBufferWidth() + this.getBufferWidth()) % this.getBufferWidth();
        this.putColor(this.getBuffer(tx, ty), this._types.get(x, y), bx, by, this.getAlphaAtLocation(coord), this._traversable.contains(coord));
    }

    protected void createTextures() {
        for (Map.Entry<Coord, ByteBuffer> entry : this._buffers.entrySet()) {
            Texture2D texture = this._textures.get(entry.getKey());
            if (texture == null) {
                texture = new Texture2D(this._ctx.getRenderer());
                texture.setFilters(9728, 9728);
                texture.setWrap(10496, 10496);
                this._textures.put(entry.getKey(), texture);
            }
            texture.setImage(0, 6408, this.getBufferWidth(), this.getBufferWidth(), false, 6408, 5121, entry.getValue());
        }
    }

    protected void putColor(ByteBuffer buf, int type, int x, int y, float alpha, boolean walkable) {
        int offset = (y * this.getBufferWidth() + x) * 4;
        byte[] color = this.getColor(offset, type, alpha, walkable);
        buf.position(offset);
        buf.put(color);
        buf.rewind();
    }

    protected byte[] getColor(int offset, int type, float alpha, boolean walkable) {
        if (walkable) {
            return SceneMap.getBytes(this._walkable, alpha);
        }
        if (type == -3) {
            return EMPTY_COLOR;
        }
        if (type == 0) {
            return SceneMap.getBytes(this._floor, alpha);
        }
        return SceneMap.getBytes(this._wall, alpha);
    }

    protected ByteBuffer getBuffer(int x, int y) {
        this._coord.set(x, y);
        ByteBuffer buf = this._buffers.get(this._coord);
        if (buf == null) {
            buf = BufferUtils.createByteBuffer((int)this.getBufferSize());
            this._buffers.put(this._coord.clone(), buf);
        }
        return buf;
    }

    protected void updateQuad(int x, int y) {
        this.updateQuad(x, y, (float)x + 1.0f, (float)y + 1.0f);
    }

    protected void updateQuad(float lx, float ly, float ux, float uy) {
        this._quad.getVertex(0).set(lx, ly);
        this._quad.getVertex(1).set(ux, ly);
        this._quad.getVertex(2).set(ux, uy);
        this._quad.getVertex(3).set(lx, uy);
        this._quad.getBounds().getMinimumExtent().set(lx, ly);
        this._quad.getBounds().getMaximumExtent().set(ux, uy);
    }

    protected boolean intersects(int x, int y, Shape shape) {
        Polygon rect = new Polygon(new Vector2f[0]);
        float length = 0.33333334f;
        int intersectionCount = 0;
        int nonIntersectionCount = 0;
        int intersectsThreshold = 4;
        for (int ii = 0; ii < 3; ++ii) {
            float xmin = (float)x + length * (float)ii;
            float xmax = (float)x + length * (float)(ii + 1);
            for (int jj = 0; jj < 3; ++jj) {
                float ymin = (float)y + length * (float)jj;
                float ymax = (float)y + length * (float)(jj + 1);
                this.updateQuad(xmin, ymin, xmax, ymax);
                if (shape.intersects(this._quad)) {
                    if (++intersectionCount <= intersectsThreshold) continue;
                    return true;
                }
                if (++nonIntersectionCount <= intersectsThreshold) continue;
                return false;
            }
        }
        return intersectionCount > intersectsThreshold;
    }

    protected static byte[] getBytes(Color4f color, float alpha) {
        return new byte[]{(byte)Math.round(color.r * alpha * 255.0f), (byte)Math.round(color.g * alpha * 255.0f), (byte)Math.round(color.b * alpha * 255.0f), (byte)Math.round(color.a * alpha * 255.0f)};
    }
}

