/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.client.sprite;

import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.expr.Bound;
import com.threerings.expr.Scope;
import com.threerings.expr.ScopeEvent;
import com.threerings.expr.SimpleScope;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.event.Event;
import com.threerings.opengl.gui.event.MouseEvent;
import com.threerings.opengl.model.Animation;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.renderer.state.ColorState;
import com.threerings.opengl.scene.Scene;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.client.sprite.EntrySprite;
import com.threerings.tudey.client.util.ShapeConfigElement;
import com.threerings.tudey.config.PlaceableConfig;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.util.TudeyContext;

public class PlaceableSprite
extends EntrySprite
implements ConfigUpdateListener<PlaceableConfig> {
    protected TudeySceneModel.PlaceableEntry _entry;
    protected PlaceableConfig _config = INVALID_CONFIG;
    protected Implementation _impl = NULL_IMPLEMENTATION;
    protected static PlaceableConfig INVALID_CONFIG = new PlaceableConfig();
    protected static final Implementation NULL_IMPLEMENTATION = new Implementation(null){};

    public PlaceableSprite(TudeyContext ctx, TudeySceneView view, TudeySceneModel.PlaceableEntry entry) {
        super(ctx, view);
        this.update(entry);
    }

    @Override
    public void configUpdated(ConfigEvent<PlaceableConfig> event) {
        this.updateFromConfig();
        this._impl.update(this._entry);
    }

    @Override
    public void scopeUpdated(ScopeEvent event) {
        super.scopeUpdated(event);
        this.updateFromConfig();
        this._impl.update(this._entry);
    }

    @Override
    public int getFloorFlags() {
        return this._impl.getFloorFlags();
    }

    @Override
    public boolean isHoverable() {
        return this._impl.isHoverable();
    }

    @Override
    public boolean isClickable() {
        return this._impl.isClickable();
    }

    @Override
    public String getTooltipText() {
        return this._impl.getTooltipText();
    }

    @Override
    public float getTooltipTimeout() {
        return this._impl.getTooltipTimeout();
    }

    @Override
    public String getTooltipWindowStyle() {
        return this._impl.getTooltipWindowStyle();
    }

    @Override
    public Component createTooltipComponent(String tiptext) {
        return this._impl.createTooltipComponent(tiptext);
    }

    @Override
    public boolean dispatchEvent(Event event) {
        return this._impl.dispatchEvent(event);
    }

    @Override
    public TudeySceneModel.Entry getEntry() {
        return this._entry;
    }

    @Override
    public void update(TudeySceneModel.Entry entry) {
        this._entry = (TudeySceneModel.PlaceableEntry)entry;
        this.setConfig(this._entry.placeable);
        this._impl.update(this._entry);
    }

    @Override
    public Model getModel() {
        return this._impl.getModel();
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.updateFromConfig();
        this._impl.update(this._entry);
    }

    @Override
    public void dispose() {
        super.dispose();
        this._impl.dispose();
        if (this._config != null) {
            this._config.removeListener(this);
        }
    }

    protected void setConfig(ConfigReference<PlaceableConfig> ref) {
        this.setConfig(this._ctx.getConfigManager().getConfig(PlaceableConfig.class, ref));
    }

    protected void setConfig(PlaceableConfig config) {
        if (this._config == config) {
            return;
        }
        if (this._config != null) {
            this._config.removeListener(this);
        }
        if ((this._config = config) != null) {
            this._config.addListener(this);
        }
        this.updateFromConfig();
    }

    protected void updateFromConfig() {
        PlaceableConfig.Original original = this._config == null ? null : this._config.getOriginal(this._ctx.getConfigManager());
        original = original == null ? PlaceableConfig.NULL_ORIGINAL : original;
        Implementation nimpl = original.getSpriteImplementation(this._ctx, this, this._impl);
        Implementation implementation = nimpl = nimpl == null ? NULL_IMPLEMENTATION : nimpl;
        if (this._impl != nimpl) {
            this._impl.dispose();
            this._impl = nimpl;
        }
    }

    public static class Marker
    extends Original {
        public Marker(TudeyContext ctx, Scope parentScope, PlaceableConfig.Original config) {
            super(ctx, parentScope);
            this.setConfig(config);
        }
    }

    public static class ClickableProp
    extends Prop {
        protected PlaceableConfig.ClickableProp _config;
        protected ColorState _cstate;
        protected Animation _defaultAnim;
        protected Animation _hoverAnim;
        protected boolean _hover;
        @Bound
        protected TudeySceneView _view;

        public ClickableProp(TudeyContext ctx, Scope parentScope, PlaceableConfig.ClickableProp config) {
            super(ctx, parentScope, config);
            this._model.setColorState(this._cstate);
        }

        @Override
        public void setConfig(PlaceableConfig.Original config) {
            super.setConfig(config);
            this._config = (PlaceableConfig.ClickableProp)config;
            if (this._cstate == null) {
                this._cstate = new ColorState();
            }
            this._defaultAnim = this._config.defaultAnimation == null ? null : this._model.createAnimation(this._config.defaultAnimation);
            this._hoverAnim = this._config.hoverAnimation == null ? null : this._model.createAnimation(this._config.hoverAnimation);
            this.setHover(this._hover);
        }

        @Override
        public boolean isHoverable() {
            return true;
        }

        @Override
        public boolean isClickable() {
            return true;
        }

        @Override
        public boolean dispatchEvent(Event event) {
            if (!(event instanceof MouseEvent)) {
                return false;
            }
            int type = ((MouseEvent)event).getType();
            if (type == 3) {
                this.setHover(true);
            } else if (type == 4) {
                this.setHover(false);
            } else if (type == 0) {
                this._config.action.execute(this._ctx, this._view, (PlaceableSprite)this._parentScope);
            } else {
                return false;
            }
            return true;
        }

        protected void setHover(boolean hover) {
            Animation inactive;
            Animation active;
            this._hover = hover;
            this._cstate.getColor().set(hover ? this._config.hoverColor : this._config.defaultColor);
            this._cstate.setDirty(true);
            if (hover) {
                active = this._hoverAnim;
                inactive = this._defaultAnim;
            } else {
                active = this._defaultAnim;
                inactive = this._hoverAnim;
            }
            if (inactive != null && inactive.isPlaying()) {
                inactive.stop();
            }
            if (active != null && !active.isPlaying()) {
                active.start();
            }
        }
    }

    public static class Prop
    extends Original {
        protected PlaceableConfig.Prop _config;

        public Prop(TudeyContext ctx, Scope parentScope, PlaceableConfig.Prop config) {
            this(ctx, parentScope);
            this.setConfig(config);
        }

        @Override
        public void setConfig(PlaceableConfig.Original config) {
            super.setConfig(config);
            this._config = (PlaceableConfig.Prop)config;
        }

        @Override
        public int getFloorFlags() {
            return this._config.floorFlags;
        }

        protected Prop(TudeyContext ctx, Scope parentScope) {
            super(ctx, parentScope);
        }
    }

    public static abstract class Original
    extends Implementation {
        protected TudeyContext _ctx;
        protected Model _model;
        protected ShapeConfigElement _footprint;
        @Bound
        protected Scene _scene;

        public Original(TudeyContext ctx, Scope parentScope) {
            super(parentScope);
            this._ctx = ctx;
            this._model = new Model(ctx);
            this._scene.add(this._model);
            this._model.setUserObject(parentScope);
        }

        public void setConfig(PlaceableConfig.Original config) {
            this._model.setConfig(this.getModelConfig(config));
            boolean selected = ((PlaceableSprite)this._parentScope).isSelected();
            if (selected && this._footprint == null) {
                this._footprint = new ShapeConfigElement(this._ctx);
                this._footprint.getColor().set(EntrySprite.SELECTED_COLOR);
                this._footprint.setConfig(config.shape, true);
                this._scene.add(this._footprint);
            } else if (!selected && this._footprint != null) {
                this._scene.remove(this._footprint);
                this._footprint = null;
            }
        }

        @Override
        public Component createTooltipComponent(String tiptext) {
            return Component.createDefaultTooltipComponent(this._ctx, tiptext);
        }

        @Override
        public Model getModel() {
            return this._model;
        }

        @Override
        public void update(TudeySceneModel.PlaceableEntry entry) {
            this._model.setLocalTransform(entry.transform);
            if (this._footprint != null) {
                this._footprint.setTransform(entry.transform);
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            this._scene.remove(this._model);
            this._model.dispose();
            if (this._footprint != null) {
                this._scene.remove(this._footprint);
            }
        }

        protected ConfigReference<ModelConfig> getModelConfig(PlaceableConfig.Original config) {
            return config.model;
        }
    }

    public static abstract class Implementation
    extends SimpleScope {
        public Implementation(Scope parentScope) {
            super(parentScope);
        }

        public Model getModel() {
            return null;
        }

        public int getFloorFlags() {
            return 0;
        }

        public boolean isHoverable() {
            return false;
        }

        public boolean isClickable() {
            return false;
        }

        public String getTooltipText() {
            return null;
        }

        public float getTooltipTimeout() {
            return -1.0f;
        }

        public String getTooltipWindowStyle() {
            return "Default/TooltipWindow";
        }

        public Component createTooltipComponent(String tiptext) {
            return null;
        }

        public boolean dispatchEvent(Event event) {
            return false;
        }

        public void update(TudeySceneModel.PlaceableEntry entry) {
        }

        @Override
        public String getScopeName() {
            return "impl";
        }
    }
}

