/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.client.cursor;

import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.client.cursor.Cursor;
import com.threerings.tudey.client.cursor.EntryCursor;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.shape.Compound;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.util.TudeyContext;
import java.util.ArrayList;
import java.util.HashMap;

public class SelectionCursor
extends Cursor {
    protected ArrayList<EntryCursor> _cursors = new ArrayList();
    protected HashMap<Object, EntryCursor> _cursorsByKey = new HashMap();
    protected Compound _shape = new Compound(new Shape[0]);
    protected ArrayList<Shape> _shapes = new ArrayList();

    public SelectionCursor(TudeyContext ctx, TudeySceneView view) {
        super(ctx, view);
    }

    public Compound getShape() {
        return this._shape;
    }

    public void update(TudeySceneModel.Entry[] entries) {
        for (TudeySceneModel.Entry entry : entries) {
            Object key = entry.getKey();
            EntryCursor cursor = this._cursorsByKey.get(key);
            if (cursor == null) {
                cursor = entry.createCursor(this._ctx, (TudeySceneView)this._parentScope);
                this._cursors.add(cursor);
                this._cursorsByKey.put(key, cursor);
                continue;
            }
            cursor.update(entry);
        }
        if (this._cursors.size() > entries.length) {
            for (int ii = this._cursors.size() - 1; ii >= 0; --ii) {
                Object key = this._cursors.get(ii).getEntry().getKey();
                if (SelectionCursor.containsKey(entries, key)) continue;
                this._cursors.remove(ii);
                this._cursorsByKey.remove(key);
            }
        }
        int nn = this._cursors.size();
        for (int ii = 0; ii < nn; ++ii) {
            Shape shape = this._cursors.get(ii).getShape();
            if (shape == null) continue;
            this._shapes.add(shape);
        }
        int scount = this._shapes.size();
        if (this._shape.getShapeCount() != scount) {
            this._shape = new Compound(scount);
        }
        this._shapes.toArray(this._shape.getShapes());
        this._shape.updateBounds();
        this._shapes.clear();
    }

    @Override
    public void tick(float elapsed) {
        int nn = this._cursors.size();
        for (int ii = 0; ii < nn; ++ii) {
            this._cursors.get(ii).tick(elapsed);
        }
    }

    @Override
    public void composite() {
        int nn = this._cursors.size();
        for (int ii = 0; ii < nn; ++ii) {
            this._cursors.get(ii).composite();
        }
    }

    protected static boolean containsKey(TudeySceneModel.Entry[] entries, Object key) {
        for (TudeySceneModel.Entry entry : entries) {
            if (!entry.getKey().equals(key)) continue;
            return true;
        }
        return false;
    }
}

