/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.client.cursor;

import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.expr.Scope;
import com.threerings.expr.SimpleScope;
import com.threerings.opengl.compositor.Compositable;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.renderer.state.ColorState;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.Tickable;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.client.cursor.EntryCursor;
import com.threerings.tudey.client.sprite.GraphSprite;
import com.threerings.tudey.client.util.ShapeSceneElement;
import com.threerings.tudey.config.GraphConfig;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.util.TudeyContext;

public class GraphCursor
extends EntryCursor
implements ConfigUpdateListener<GraphConfig> {
    protected TudeySceneModel.GraphEntry _entry;
    protected GraphConfig _config;
    protected Implementation _impl = NULL_IMPLEMENTATION;
    protected static final Implementation NULL_IMPLEMENTATION = new Implementation(null){};

    public static Model[] maybeResize(Model[] omodels, int ncount, TudeyContext ctx, Scope parentScope, String name, ColorState colorState) {
        if (omodels.length == ncount) {
            return omodels;
        }
        Model[] nmodels = new Model[ncount];
        System.arraycopy(omodels, 0, nmodels, 0, Math.min(omodels.length, ncount));
        for (int ii = omodels.length; ii < ncount; ++ii) {
            Model model = nmodels[ii] = new Model(ctx);
            model.setParentScope(parentScope);
            model.setRenderScheme("Translucent");
            model.setColorState(colorState);
            model.setConfig(name);
        }
        return nmodels;
    }

    public GraphCursor(TudeyContext ctx, TudeySceneView view, TudeySceneModel.GraphEntry entry) {
        super(ctx, view);
        this.update(entry);
    }

    @Override
    public void configUpdated(ConfigEvent<GraphConfig> event) {
        this.updateFromConfig();
        this._impl.update(this._entry);
    }

    @Override
    public TudeySceneModel.Entry getEntry() {
        return this._entry;
    }

    @Override
    public Shape getShape() {
        return this._impl.getShape();
    }

    @Override
    public void update(TudeySceneModel.Entry entry) {
        this._entry = (TudeySceneModel.GraphEntry)entry;
        this.setConfig(this._entry.graph);
        this._impl.update(this._entry);
    }

    @Override
    public void tick(float elapsed) {
        this._impl.tick(elapsed);
    }

    @Override
    public void composite() {
        this._impl.composite();
    }

    @Override
    public void dispose() {
        super.dispose();
        this._impl.dispose();
        if (this._config != null) {
            this._config.removeListener(this);
        }
    }

    protected void setConfig(ConfigReference<GraphConfig> ref) {
        this.setConfig(this._ctx.getConfigManager().getConfig(GraphConfig.class, ref));
    }

    protected void setConfig(GraphConfig config) {
        if (this._config == config) {
            return;
        }
        if (this._config != null) {
            this._config.removeListener(this);
        }
        if ((this._config = config) != null) {
            this._config.addListener(this);
        }
        this.updateFromConfig();
    }

    protected void updateFromConfig() {
        Implementation nimpl = this._config == null ? null : this._config.getCursorImplementation(this._ctx, this, this._impl);
        Implementation implementation = nimpl = nimpl == null ? NULL_IMPLEMENTATION : nimpl;
        if (this._impl != nimpl) {
            this._impl.dispose();
            this._impl = nimpl;
        }
    }

    public static class Original
    extends Implementation {
        protected TudeyContext _ctx;
        protected Model[] _vertices = new Model[0];
        protected Model[] _edges = new Model[0];
        protected ShapeSceneElement _footprint;
        protected ColorState _colorState = new ColorState();

        public Original(TudeyContext ctx, Scope parentScope, GraphConfig.Original config) {
            super(parentScope);
            this._ctx = ctx;
            this._footprint = new ShapeSceneElement((GlContext)ctx, true);
            this._footprint.getColor().set(EntryCursor.FOOTPRINT_COLOR);
            this.setConfig(config);
        }

        public void setConfig(GraphConfig.Original config) {
            this._colorState.getColor().set(config.color).multLocal(0.5f);
        }

        @Override
        public Shape getShape() {
            return this._footprint.getShape();
        }

        @Override
        public void update(TudeySceneModel.GraphEntry entry) {
            this._vertices = GraphCursor.maybeResize(this._vertices, entry.vertices.length, this._ctx, this, "editor/marker/vertex/model_label.dat", this._colorState);
            float minz = GraphSprite.updateVertices(entry.vertices, this._vertices);
            this._edges = GraphCursor.maybeResize(this._edges, entry.edges.length - 1, this._ctx, this, "editor/marker/edge/model.dat", this._colorState);
            GraphSprite.updateEdges(entry.vertices, entry.edges, this._edges);
            this._footprint.getTransform().getTranslation().z = minz;
            this._footprint.setShape(entry.createShape(this._ctx.getConfigManager()));
        }

        @Override
        public void tick(float elapsed) {
            for (Model model : this._vertices) {
                model.tick(elapsed);
            }
            for (Model model : this._edges) {
                model.tick(elapsed);
            }
        }

        @Override
        public void composite() {
            for (Model model : this._vertices) {
                model.composite();
            }
            for (Model model : this._edges) {
                model.composite();
            }
            this._footprint.composite();
        }
    }

    public static abstract class Implementation
    extends SimpleScope
    implements Tickable,
    Compositable {
        public Implementation(Scope parentScope) {
            super(parentScope);
        }

        public Shape getShape() {
            return null;
        }

        public void update(TudeySceneModel.GraphEntry entry) {
        }

        @Override
        public void tick(float elapsed) {
        }

        @Override
        public void composite() {
        }

        @Override
        public String getScopeName() {
            return "impl";
        }
    }
}

